/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.delivery.sax;

import java.io.IOException;
import org.dhatim.SmooksException;
import org.dhatim.cdr.annotation.ConfigParam;
import org.dhatim.container.ExecutionContext;
import org.dhatim.delivery.sax.SAXElement;
import org.dhatim.delivery.sax.SAXElementVisitor;
import org.dhatim.delivery.sax.SAXElementWriterUtil;
import org.dhatim.delivery.sax.SAXText;
import org.dhatim.delivery.sax.SAXVisitor;

public class DefaultSAXElementSerializer
implements SAXElementVisitor {
    private SAXVisitor writerOwner = this;
    private boolean rewriteEntities = true;

    public void setWriterOwner(SAXVisitor writerOwner) {
        this.writerOwner = writerOwner;
    }

    @ConfigParam(name="entities.rewrite", defaultVal="true")
    public void setRewriteEntities(boolean rewriteEntities) {
        this.rewriteEntities = rewriteEntities;
    }

    @Override
    public void visitBefore(SAXElement element, ExecutionContext executionContext) throws SmooksException, IOException {
        element.getWriter(this.writerOwner);
    }

    @Override
    public void onChildText(SAXElement element, SAXText text, ExecutionContext executionContext) throws SmooksException, IOException {
        this.writeStartElement(element);
        if (element.isWriterOwner(this.writerOwner)) {
            text.toWriter(element.getWriter(this.writerOwner), this.rewriteEntities);
        }
    }

    @Override
    public void onChildElement(SAXElement element, SAXElement childElement, ExecutionContext executionContext) throws SmooksException, IOException {
        this.writeStartElement(element);
    }

    @Override
    public void visitAfter(SAXElement element, ExecutionContext executionContext) throws SmooksException, IOException {
        this.writeEndElement(element);
    }

    public void writeStartElement(SAXElement element) throws IOException {
        if (element.isWriterOwner(this.writerOwner) && !this.isStartWritten(element)) {
            element.setCache(this, true);
            this.writeStart(element);
        }
    }

    public void writeEndElement(SAXElement element) throws IOException {
        if (element.isWriterOwner(this.writerOwner)) {
            this.writeEnd(element);
        }
    }

    protected void writeStart(SAXElement element) throws IOException {
        SAXElementWriterUtil.writeStartElement(element, element.getWriter(this.writerOwner), this.rewriteEntities);
    }

    protected void writeEnd(SAXElement element) throws IOException {
        if (!this.isStartWritten(element)) {
            SAXElementWriterUtil.writeEmptyElement(element, element.getWriter(this.writerOwner), this.rewriteEntities);
        } else {
            SAXElementWriterUtil.writeEndElement(element, element.getWriter(this.writerOwner));
        }
    }

    public boolean isStartWritten(SAXElement element) {
        return element.getCache(this) != null;
    }
}

