/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.edisax.unedifact;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.dhatim.assertion.AssertArgument;
import org.dhatim.edisax.BufferedSegmentReader;
import org.dhatim.edisax.interchange.ControlBlockHandler;
import org.dhatim.edisax.interchange.ControlBlockHandlerFactory;
import org.dhatim.edisax.interchange.InterchangeContext;
import org.dhatim.edisax.model.internal.Delimiters;
import org.dhatim.edisax.registry.LazyMappingsRegistry;
import org.dhatim.edisax.registry.MappingsRegistry;
import org.dhatim.edisax.unedifact.handlers.r41.UNEdifact41ControlBlockHandlerFactory;
import org.dhatim.namespace.NamespaceDeclarationStack;
import org.dhatim.namespace.NamespaceDeclarationStackAware;
import org.dhatim.xml.hierarchy.HierarchyChangeListener;
import org.dhatim.xml.hierarchy.HierarchyChangeReader;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public class UNEdifactInterchangeParser
implements XMLReader,
NamespaceDeclarationStackAware,
HierarchyChangeReader {
    private Map<String, Boolean> features = new HashMap<String, Boolean>();
    public static final Delimiters defaultUNEdifactDelimiters = new Delimiters().setSegment("'").setField("+").setComponent(":").setEscape("?").setDecimalSeparator(".");
    protected MappingsRegistry registry = new LazyMappingsRegistry();
    private ContentHandler contentHandler;
    private HierarchyChangeListener hierarchyChangeListener;
    private InterchangeContext interchangeContext;
    private NamespaceDeclarationStack namespaceDeclarationStack;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parse(InputSource unedifactInterchange) throws IOException, SAXException {
        AssertArgument.isNotNull(unedifactInterchange, "unedifactInterchange");
        if (this.contentHandler == null) {
            throw new IllegalStateException("'contentHandler' not set.  Cannot parse EDI stream.");
        }
        if (this.registry == null) {
            throw new IllegalStateException("'mappingsRegistry' not set.  Cannot parse EDI stream.");
        }
        try {
            String segCode;
            UNEdifact41ControlBlockHandlerFactory handlerFactory = new UNEdifact41ControlBlockHandlerFactory(this.hierarchyChangeListener);
            BufferedSegmentReader segmentReader = new BufferedSegmentReader(unedifactInterchange, defaultUNEdifactDelimiters);
            boolean validate = this.getFeature("http://xml.org/sax/features/validation");
            segmentReader.mark();
            segmentReader.setIgnoreNewLines(this.getFeature("http://xml.org/sax/features/ignore-newlines"));
            this.contentHandler.startDocument();
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute("http://www.w3.org/2000/xmlns/", "env", "xmlns:env", "CDATA", handlerFactory.getNamespace());
            String envElementQName = "env:unEdifact";
            this.contentHandler.startElement(handlerFactory.getNamespace(), "unEdifact", envElementQName, attrs);
            while ((segCode = segmentReader.peek(3, true)).length() == 3) {
                this.interchangeContext = this.createInterchangeContext(segmentReader, validate, handlerFactory, this.namespaceDeclarationStack);
                this.namespaceDeclarationStack = this.interchangeContext.getNamespaceDeclarationStack();
                if (this.hierarchyChangeListener != null) {
                    this.hierarchyChangeListener.attachXMLReader(this.interchangeContext.getControlSegmentParser());
                } else if (!this.interchangeContext.isContainerManagedNamespaceStack()) {
                    this.interchangeContext.getNamespaceDeclarationStack().pushReader(this.interchangeContext.getControlSegmentParser());
                }
                this.namespaceDeclarationStack.pushNamespaces(envElementQName, handlerFactory.getNamespace(), attrs);
                ControlBlockHandler handler = handlerFactory.getControlBlockHandler(segCode);
                ++this.interchangeContext.indentDepth.value;
                handler.process(this.interchangeContext);
                --this.interchangeContext.indentDepth.value;
            }
            this.contentHandler.characters(new char[]{'\n'}, 0, 1);
            this.contentHandler.endElement(handlerFactory.getNamespace(), "unEdifact", envElementQName);
            this.contentHandler.endDocument();
        }
        finally {
            if (this.namespaceDeclarationStack != null) {
                this.namespaceDeclarationStack.popNamespaces();
                if (this.hierarchyChangeListener != null) {
                    this.hierarchyChangeListener.detachXMLReader();
                } else if (!this.interchangeContext.isContainerManagedNamespaceStack()) {
                    this.interchangeContext.getNamespaceDeclarationStack().popReader();
                }
            }
            this.contentHandler = null;
        }
    }

    protected InterchangeContext createInterchangeContext(BufferedSegmentReader segmentReader, boolean validate, ControlBlockHandlerFactory controlBlockHandlerFactory, NamespaceDeclarationStack namespaceDeclarationStack) {
        return new InterchangeContext(segmentReader, this.registry, this.contentHandler, this.getFeatures(), controlBlockHandlerFactory, namespaceDeclarationStack, validate);
    }

    public InterchangeContext getInterchangeContext() {
        return this.interchangeContext;
    }

    public UNEdifactInterchangeParser setMappingsRegistry(MappingsRegistry registry) {
        AssertArgument.isNotNull(registry, "mappingsRegistry");
        this.registry = registry;
        return this;
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    @Override
    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    public void ignoreNewLines(boolean ignoreNewLines) {
        this.setFeature("http://xml.org/sax/features/ignore-newlines", ignoreNewLines);
    }

    public void ignoreEmptyNodes(boolean ignoreEmptyNodes) {
        this.setFeature("http://smooks.org/edi/sax/features/ignore-empty-nodes", ignoreEmptyNodes);
    }

    public void validate(boolean validate) {
        this.setFeature("http://xml.org/sax/features/validation", validate);
    }

    public Map<String, Boolean> getFeatures() {
        return this.features;
    }

    @Override
    public void setFeature(String name, boolean value) {
        this.features.put(name, value);
    }

    @Override
    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        Boolean feature = this.features.get(name);
        if (feature == null) {
            return false;
        }
        return feature;
    }

    @Override
    public void setNamespaceDeclarationStack(NamespaceDeclarationStack namespaceDeclarationStack) {
        this.namespaceDeclarationStack = namespaceDeclarationStack;
    }

    @Override
    public void setHierarchyChangeListener(HierarchyChangeListener listener) {
        this.hierarchyChangeListener = listener;
    }

    @Override
    public void parse(String systemId) throws IOException, SAXException {
        throw new UnsupportedOperationException("Operation not supports by this reader.");
    }

    @Override
    public DTDHandler getDTDHandler() {
        return null;
    }

    @Override
    public void setDTDHandler(DTDHandler arg0) {
    }

    @Override
    public EntityResolver getEntityResolver() {
        return null;
    }

    @Override
    public void setEntityResolver(EntityResolver arg0) {
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return null;
    }

    @Override
    public void setErrorHandler(ErrorHandler arg0) {
    }

    @Override
    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return null;
    }

    @Override
    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }
}

