/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.event.report;

import java.io.File;
import java.io.Writer;
import org.dhatim.assertion.AssertArgument;
import org.dhatim.cdr.SmooksConfigurationException;
import org.dhatim.event.ExecutionEvent;
import org.dhatim.event.types.ConfigBuilderEvent;
import org.dhatim.event.types.ElementVisitEvent;

public class ReportConfiguration {
    public static File TEMP_DIR = new File(System.getProperty("java.io.tmpdir"));
    private Writer outputWriter;
    private boolean escapeXMLChars = false;
    private boolean showDefaultAppliedResources = false;
    private Class<? extends ExecutionEvent>[] filterEvents;
    private boolean autoCloseWriter = true;
    private File tempOutDir = TEMP_DIR;

    public ReportConfiguration(Writer outputWriter) {
        AssertArgument.isNotNull(outputWriter, "outputWriter");
        this.outputWriter = outputWriter;
        this.filterEvents = new Class[]{ConfigBuilderEvent.class, ElementVisitEvent.class};
    }

    public void setOutputWriter(Writer outputWriter) {
        this.outputWriter = outputWriter;
    }

    public Writer getOutputWriter() {
        return this.outputWriter;
    }

    public boolean escapeXMLChars() {
        return this.escapeXMLChars;
    }

    public void setEscapeXMLChars(boolean escapeXMLChars) {
        this.escapeXMLChars = escapeXMLChars;
    }

    public boolean showDefaultAppliedResources() {
        return this.showDefaultAppliedResources;
    }

    public void setShowDefaultAppliedResources(boolean showDefaultAppliedResources) {
        this.showDefaultAppliedResources = showDefaultAppliedResources;
    }

    public void setFilterEvents(Class<? extends ExecutionEvent> ... filterEvents) {
        this.filterEvents = filterEvents;
    }

    public Class<? extends ExecutionEvent>[] getFilterEvents() {
        return this.filterEvents;
    }

    public boolean autoCloseWriter() {
        return this.autoCloseWriter;
    }

    public void setAutoCloseWriter(boolean autoCloseWriter) {
        this.autoCloseWriter = autoCloseWriter;
    }

    public File getTempOutDir() {
        if (this.tempOutDir == null) {
            throw new SmooksConfigurationException("Temp OutDir not set.");
        }
        return this.tempOutDir;
    }

    public void setTempOutDir(File tempOutDir) {
        this.tempOutDir = tempOutDir;
    }
}

