/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.javabean.decoders;

import java.text.NumberFormat;
import java.text.ParseException;
import org.dhatim.javabean.DataDecodeException;
import org.dhatim.javabean.DecodeType;
import org.dhatim.javabean.decoders.NumberDecoder;

@DecodeType(value={Double.class, double.class})
public class DoubleDecoder
extends NumberDecoder {
    @Override
    public Object decode(String data) throws DataDecodeException {
        NumberFormat format = this.getNumberFormat();
        if (format != null) {
            try {
                Number number = format.parse(data.trim());
                return number.doubleValue();
            }
            catch (ParseException e) {
                throw new DataDecodeException("Failed to decode Double value '" + data + "' using NumberFormat instance " + format + ".", e);
            }
        }
        try {
            return Double.parseDouble(data.trim());
        }
        catch (NumberFormatException e) {
            throw new DataDecodeException("Failed to decode Double value '" + data + "'.", e);
        }
    }
}

