/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.payload;

import java.util.Set;
import org.dhatim.cdr.annotation.AppContext;
import org.dhatim.cdr.annotation.ConfigParam;
import org.dhatim.container.ApplicationContext;
import org.dhatim.delivery.ContentHandler;
import org.dhatim.delivery.annotation.Initialize;
import org.dhatim.payload.Exports;
import org.dhatim.util.CollectionsUtil;

public class Export
implements ContentHandler<Export> {
    @ConfigParam(use=ConfigParam.Use.OPTIONAL)
    private String name;
    @ConfigParam
    private Class<?> type;
    @ConfigParam(use=ConfigParam.Use.OPTIONAL)
    private String extract;
    private Set<String> extractSet;
    @AppContext
    private ApplicationContext applicationContext;

    public Export() {
    }

    public Export(Class<?> type) {
        this.type = type;
    }

    public Export(Class<?> type, String name) {
        this(type);
        this.name = name;
    }

    public Export(Class<?> type, String name, String extract) {
        this(type, name);
        this.extract = extract;
        this.initExtractSet();
    }

    @Initialize
    public void addToExportsInApplicationContext() {
        this.initExtractSet();
        Exports.addExport(this.applicationContext, this);
    }

    private void initExtractSet() {
        if (this.extract != null) {
            this.extractSet = CollectionsUtil.toSet(this.extract.split(","));
        }
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getType() {
        return this.type;
    }

    public String getExtract() {
        return this.extract;
    }

    public Set<String> getExtractSet() {
        return this.extractSet;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.extract == null ? 0 : this.extract.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Export)) {
            return false;
        }
        Export other = (Export)obj;
        return (this.type == other.type || this.type != null && this.type.equals(other.type)) && (this.extract == other.extract || this.extract != null && this.extract.equals(other.extract)) && (this.name == other.name || this.name != null && this.name.equals(other.name));
    }

    public String toString() {
        return "Export [type=" + this.type.getName() + ", name=" + this.name + ", extract=" + this.extract + "]";
    }
}

