/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.smooks.scripting.groovy;

import groovy.lang.GroovyClassLoader;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.control.CompilationFailedException;
import org.dhatim.cdr.SmooksConfigurationException;
import org.dhatim.cdr.SmooksResourceConfiguration;
import org.dhatim.cdr.annotation.Configurator;
import org.dhatim.delivery.ContentHandler;
import org.dhatim.delivery.ContentHandlerFactory;
import org.dhatim.delivery.Visitor;
import org.dhatim.delivery.annotation.Initialize;
import org.dhatim.delivery.annotation.Resource;
import org.dhatim.io.StreamUtils;
import org.dhatim.util.FreeMarkerTemplate;

@Resource(type="groovy")
public class GroovyContentHandlerFactory
implements ContentHandlerFactory {
    private static Log logger = LogFactory.getLog(GroovyContentHandlerFactory.class);
    private FreeMarkerTemplate classTemplate;
    private volatile int classGenCount = 1;

    @Initialize
    public void initialize() throws IOException {
        String templateText = StreamUtils.readStreamAsString(this.getClass().getResourceAsStream("ScriptedGroovy.ftl"));
        this.classTemplate = new FreeMarkerTemplate(templateText);
    }

    @Override
    public ContentHandler create(SmooksResourceConfiguration configuration) throws SmooksConfigurationException, InstantiationException {
        try {
            Object groovyObject;
            byte[] groovyScriptBytes = configuration.getBytes();
            String groovyScript = new String(groovyScriptBytes, "UTF-8");
            if (groovyScriptBytes == null) {
                throw new InstantiationException("No resource specified in either the resource path or resource 'resdata'.");
            }
            GroovyClassLoader groovyClassLoader = new GroovyClassLoader(this.getClass().getClassLoader());
            try {
                Class groovyClass = groovyClassLoader.parseClass(groovyScript);
                groovyObject = groovyClass.newInstance();
            }
            catch (CompilationFailedException e) {
                logger.debug((Object)("Failed to create Visitor class instance directly from script:\n==========================\n" + groovyScript + "\n==========================\n Will try applying Visitor template to script."), (Throwable)e);
                groovyObject = null;
            }
            if (!(groovyObject instanceof Visitor)) {
                groovyObject = this.createFromTemplate(groovyScript, configuration);
            }
            ContentHandler groovyResource = (ContentHandler)groovyObject;
            Configurator.configure(groovyResource, configuration);
            return groovyResource;
        }
        catch (Exception e) {
            throw new SmooksConfigurationException("Error constructing class from Groovy script " + configuration.getResource(), e);
        }
    }

    private Object createFromTemplate(String groovyScript, SmooksResourceConfiguration configuration) throws InstantiationException, IllegalAccessException {
        GroovyClassLoader groovyClassLoader = new GroovyClassLoader(this.getClass().getClassLoader());
        HashMap<String, Object> templateVars = new HashMap<String, Object>();
        String imports = configuration.getStringParameter("imports", "");
        templateVars.put("imports", this.cleanImportsConfig(imports));
        templateVars.put("visitorName", this.createClassName());
        templateVars.put("elementName", this.getElementName(configuration));
        templateVars.put("visitBefore", configuration.getBoolParameter("executeBefore", false));
        templateVars.put("visitorScript", groovyScript);
        String templatedClass = this.classTemplate.apply(templateVars);
        if (groovyScript.indexOf("writeFragment") != -1) {
            configuration.setParameter("writeFragment", "true");
        }
        try {
            Class groovyClass = groovyClassLoader.parseClass(templatedClass);
            return groovyClass.newInstance();
        }
        catch (CompilationFailedException e) {
            throw new SmooksConfigurationException("Failed to compile Groovy scripted Visitor class:\n==========================\n" + templatedClass + "\n==========================\n", e);
        }
    }

    private Object cleanImportsConfig(String imports) {
        try {
            StringBuffer importsBuffer = StreamUtils.trimLines(new StringReader(imports));
            imports = importsBuffer.toString();
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected IOException reading String.", e);
        }
        return imports.replace("import ", "\nimport ");
    }

    private synchronized String createClassName() {
        StringBuilder className = new StringBuilder();
        className.append("SmooksVisitor_");
        className.append(System.identityHashCode(this));
        className.append("_");
        className.append(this.classGenCount++);
        return className.toString();
    }

    private String getElementName(SmooksResourceConfiguration configuration) {
        String elementName = configuration.getTargetElement();
        for (int i = 0; i < elementName.length(); ++i) {
            if (Character.isLetterOrDigit(elementName.charAt(i))) continue;
            return elementName + "_Mangled";
        }
        return elementName;
    }
}

