/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.templating;

import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Set;
import javax.xml.transform.TransformerConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dhatim.SmooksException;
import org.dhatim.assertion.AssertArgument;
import org.dhatim.cdr.SmooksConfigurationException;
import org.dhatim.cdr.SmooksResourceConfiguration;
import org.dhatim.cdr.annotation.AppContext;
import org.dhatim.cdr.annotation.Config;
import org.dhatim.cdr.annotation.ConfigParam;
import org.dhatim.container.ApplicationContext;
import org.dhatim.container.ExecutionContext;
import org.dhatim.delivery.Fragment;
import org.dhatim.delivery.annotation.Initialize;
import org.dhatim.delivery.dom.DOMElementVisitor;
import org.dhatim.delivery.dom.serialize.ContextObjectSerializationUnit;
import org.dhatim.delivery.dom.serialize.TextSerializationUnit;
import org.dhatim.delivery.ordering.Producer;
import org.dhatim.io.AbstractOutputStreamResource;
import org.dhatim.javabean.DataDecodeException;
import org.dhatim.javabean.DataDecoder;
import org.dhatim.javabean.repository.BeanId;
import org.dhatim.templating.BindTo;
import org.dhatim.templating.Inline;
import org.dhatim.templating.OutputTo;
import org.dhatim.templating.TemplatingConfiguration;
import org.dhatim.templating.Usage;
import org.dhatim.util.CollectionsUtil;
import org.dhatim.xml.DomUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractTemplateProcessor
implements DOMElementVisitor,
Producer {
    public static final String TEMPLATE_SPLIT_PI = "<\\?TEMPLATE-SPLIT-PI\\?>";
    private final Log logger = LogFactory.getLog(this.getClass());
    private static boolean legactVisitBeforeParamWarn = false;
    private TemplatingConfiguration templatingConfiguration;
    @ConfigParam(defaultVal="false")
    private boolean applyTemplateBefore;
    @ConfigParam(name="action", defaultVal="replace", choice={"replace", "addto", "insertbefore", "insertafter", "bindto"}, decoder=ActionDecoder.class)
    private Action action;
    @ConfigParam(defaultVal="UTF-8")
    private Charset encoding = Charset.forName("UTF-8");
    @ConfigParam(use=ConfigParam.Use.OPTIONAL)
    private String bindId;
    @ConfigParam(use=ConfigParam.Use.OPTIONAL)
    private String outputStreamResource;
    @Config
    private SmooksResourceConfiguration smooksConfig;
    @AppContext
    private ApplicationContext applicationContext;
    private BeanId bindBeanId;

    @Initialize
    public void initialize() {
        if (this.templatingConfiguration != null) {
            SmooksResourceConfiguration config = new SmooksResourceConfiguration();
            config.setResource(this.templatingConfiguration.getTemplate());
            Usage resultUsage = this.templatingConfiguration.getUsage();
            if (resultUsage == Inline.ADDTO) {
                this.action = Action.ADDTO;
            } else if (resultUsage == Inline.REPLACE) {
                this.action = Action.REPLACE;
            } else if (resultUsage == Inline.INSERT_BEFORE) {
                this.action = Action.INSERT_BEFORE;
            } else if (resultUsage == Inline.INSERT_AFTER) {
                this.action = Action.INSERT_AFTER;
            } else if (resultUsage instanceof BindTo) {
                this.action = Action.BIND_TO;
                this.bindId = ((BindTo)resultUsage).getBeanId();
                this.bindBeanId = this.applicationContext.getBeanIdStore().register(this.bindId);
            } else if (resultUsage instanceof OutputTo) {
                this.outputStreamResource = ((OutputTo)resultUsage).getOutputStreamResource();
            }
            try {
                this.loadTemplate(config);
            }
            catch (Exception e) {
                throw new SmooksConfigurationException("Error loading Templating resource: " + config, e);
            }
        }
        if (this.smooksConfig != null) {
            if (this.smooksConfig.getResource() == null) {
                throw new SmooksConfigurationException("Templating resource undefined in resource configuration: " + this.smooksConfig);
            }
            try {
                this.loadTemplate(this.smooksConfig);
            }
            catch (Exception e) {
                throw new SmooksConfigurationException("Error loading Templating resource: " + this.smooksConfig, e);
            }
            String visitBefore = this.smooksConfig.getStringParameter("visitBefore");
            if (visitBefore != null) {
                if (!legactVisitBeforeParamWarn) {
                    this.logger.warn((Object)"Templating <param> 'visitBefore' deprecated.  Use 'applyTemplateBefore'.");
                    legactVisitBeforeParamWarn = true;
                }
                this.applyTemplateBefore = visitBefore.equalsIgnoreCase("true");
            }
            if (this.action == Action.BIND_TO) {
                if (this.bindId == null) {
                    throw new SmooksConfigurationException("'bindto' templating action configurations must also specify a 'bindId' configuration for the Id under which the result is bound to the ExecutionContext");
                }
                this.bindBeanId = this.applicationContext.getBeanIdStore().register(this.bindId);
            }
        } else {
            throw new SmooksConfigurationException(this.getClass().getSimpleName() + " not configured.");
        }
    }

    protected void setTemplatingConfiguration(TemplatingConfiguration templatingConfiguration) {
        AssertArgument.isNotNull(templatingConfiguration, "templatingConfiguration");
        this.templatingConfiguration = templatingConfiguration;
    }

    protected abstract void loadTemplate(SmooksResourceConfiguration var1) throws IOException, TransformerConfigurationException;

    public boolean applyTemplateBefore() {
        return this.applyTemplateBefore;
    }

    public Set<String> getProducts() {
        if (this.outputStreamResource != null) {
            return CollectionsUtil.toSet(this.outputStreamResource);
        }
        return CollectionsUtil.toSet(new String[0]);
    }

    protected Action getAction() {
        return this.action;
    }

    public Charset getEncoding() {
        return this.encoding;
    }

    public String getBindId() {
        return this.bindId;
    }

    public String getOutputStreamResource() {
        return this.outputStreamResource;
    }

    protected void processTemplateAction(Element element, Node templatingResult, ExecutionContext executionContext) {
        if (this.getOutputStreamResource() == null && this.action == Action.REPLACE) {
            DomUtils.replaceNode(templatingResult, (Node)element);
        } else {
            this._processTemplateAction(element, templatingResult, this.action, executionContext);
        }
    }

    protected void processTemplateAction(Element element, NodeList templatingResultNodeList, ExecutionContext executionContext) {
        if (element.getParentNode() instanceof Document) {
            int count = templatingResultNodeList.getLength();
            for (int i = 0; i < count; ++i) {
                Node node = templatingResultNodeList.item(0);
                if (node.getNodeType() != 1) continue;
                this.processTemplateAction(element, node, executionContext);
                break;
            }
        } else if (this.action == Action.REPLACE) {
            this.processTemplateAction(element, templatingResultNodeList, Action.INSERT_BEFORE, executionContext);
            element.getParentNode().removeChild(element);
        } else {
            this.processTemplateAction(element, templatingResultNodeList, this.action, executionContext);
        }
    }

    private void processTemplateAction(Element element, NodeList templatingResultNodeList, Action action, ExecutionContext executionContext) {
        int count = templatingResultNodeList.getLength();
        for (int i = 0; i < count; ++i) {
            this._processTemplateAction(element, templatingResultNodeList.item(0), action, executionContext);
        }
    }

    private void _processTemplateAction(Element element, Node node, Action action, ExecutionContext executionContext) {
        Node parent = element.getParentNode();
        if (parent instanceof Document && (action == Action.INSERT_BEFORE || action == Action.INSERT_AFTER)) {
            this.logger.debug((Object)"Insert before/after root element not allowed.  Consider using the replace action!!");
            return;
        }
        String outputStreamResourceName = this.getOutputStreamResource();
        if (outputStreamResourceName != null) {
            Writer writer = AbstractOutputStreamResource.getOutputWriter(outputStreamResourceName, executionContext);
            String text = this.extractTextContent(node, executionContext);
            try {
                writer.write(text);
            }
            catch (IOException e) {
                throw new SmooksException("Failed to write to output stream resource '" + outputStreamResourceName + "'.", e);
            }
        } else if (action == Action.ADDTO) {
            element.appendChild(node);
        } else if (action == Action.INSERT_BEFORE) {
            DomUtils.insertBefore(node, (Node)element);
        } else if (action == Action.INSERT_AFTER) {
            Node nextSibling = element.getNextSibling();
            if (nextSibling == null) {
                parent.appendChild(node);
            } else {
                DomUtils.insertBefore(node, nextSibling);
            }
        } else if (action == Action.BIND_TO) {
            String text = this.extractTextContent(node, executionContext);
            executionContext.getBeanContext().addBean(this.bindBeanId, (Object)text, new Fragment(element));
        } else if (action == Action.REPLACE) {
            // empty if block
        }
    }

    private String extractTextContent(Node node, ExecutionContext executionContext) {
        if (node.getNodeType() == 3) {
            return node.getTextContent();
        }
        if (node.getNodeType() == 1 && ContextObjectSerializationUnit.isContextObjectElement((Element)node)) {
            String contextKey = ContextObjectSerializationUnit.getContextKey((Element)node);
            return (String)executionContext.getAttribute(contextKey);
        }
        if (node.getNodeType() == 1 && TextSerializationUnit.isTextElement((Element)node)) {
            return TextSerializationUnit.getText((Element)node);
        }
        throw new SmooksException("Unsupported 'bindTo' or toOutStream templating action.  The bind data must be attached to a DOM Text node, or already bound to a <context-object> element.");
    }

    @Override
    public void visitBefore(Element element, ExecutionContext executionContext) throws SmooksException {
        if (this.applyTemplateBefore) {
            this.visit(element, executionContext);
        }
    }

    @Override
    public void visitAfter(Element element, ExecutionContext executionContext) throws SmooksException {
        if (!this.applyTemplateBefore) {
            this.visit(element, executionContext);
        }
    }

    protected abstract void visit(Element var1, ExecutionContext var2) throws SmooksException;

    public BeanId getBindBeanId() {
        return this.bindBeanId;
    }

    public static class ActionDecoder
    implements DataDecoder {
        @Override
        public Object decode(String data) throws DataDecodeException {
            if ("addto".equals(data)) {
                return Action.ADDTO;
            }
            if ("insertbefore".equals(data)) {
                return Action.INSERT_BEFORE;
            }
            if ("insertafter".equals(data)) {
                return Action.INSERT_AFTER;
            }
            if ("bindto".equals(data)) {
                return Action.BIND_TO;
            }
            return Action.REPLACE;
        }
    }

    protected static enum Action {
        REPLACE,
        ADDTO,
        INSERT_BEFORE,
        INSERT_AFTER,
        BIND_TO;

    }
}

