/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.thread;

import java.util.EmptyStackException;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StackedThreadLocal<T> {
    private static Log logger = LogFactory.getLog(StackedThreadLocal.class);
    private String resourceName;
    private ThreadLocal<Stack<T>> stackTL = new ThreadLocal();

    public StackedThreadLocal(String resourceName) {
        this.resourceName = resourceName;
    }

    public T get() {
        Stack<T> execContextStack = this.getExecutionContextStack();
        try {
            return execContextStack.peek();
        }
        catch (EmptyStackException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("No currently stacked '" + this.resourceName + "' instance on active Thread."), (Throwable)e);
            }
            return null;
        }
    }

    public void set(T value) {
        Stack<T> execContextStack = this.getExecutionContextStack();
        execContextStack.push(value);
    }

    public void remove() {
        block2: {
            Stack<T> execContextStack = this.getExecutionContextStack();
            try {
                execContextStack.pop();
            }
            catch (EmptyStackException e) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug((Object)("No currently stacked '" + this.resourceName + "' instance on active Thread."), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Stack<T> getExecutionContextStack() {
        Stack<Object> stack = this.stackTL.get();
        if (stack == null) {
            StackedThreadLocal stackedThreadLocal = this;
            synchronized (stackedThreadLocal) {
                stack = this.stackTL.get();
                if (stack == null) {
                    stack = new Stack();
                    this.stackTL.set(stack);
                }
            }
        }
        return stack;
    }
}

