/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.dhatim.container.ExecutionContext;
import org.dhatim.payload.FilterResult;
import org.dhatim.payload.FilterSource;

public class MultiLineToStringBuilder {
    private static final int SPACES = 3;
    private static final String PARENT_OPEN = "PARENT-";
    private static final String PARENT_CLOSE = "";
    private static final String SPACE = " ";
    private static final String QUOTE = "\"";
    private static final String SQUARE_BRACKET_CLOSE = "]";
    private static final String SQUARE_BRACKET_OPEN = "[";
    private static final String THIS = "THIS";
    private static final String NULL = "NULL";
    private static final String VALUE_KEY_SEPARATOR = " : ";
    private static final String COMMA = ",";
    private static final String CURLY_BRACKET_CLOSE = "}";
    private static final String CURLY_BRACKET_OPEN = "{";
    private static final String NL = System.getProperty("line.separator");
    private static final Pattern NL_PATTERN = Pattern.compile("\r\n|\n|\r");
    private static final List<String> EXECUTION_CONTEXT_FILTER_LIST = new ArrayList<String>();

    private MultiLineToStringBuilder() {
    }

    public static String toString(ExecutionContext executionContext) {
        Stack<Object> stack = new Stack<Object>();
        stack.push(executionContext);
        StringBuilder builder = new StringBuilder();
        builder.append("BeanContext : ");
        builder.append(MultiLineToStringBuilder.toString(executionContext.getBeanContext().getBeanMap(), stack, new ArrayList()));
        builder.append(NL);
        builder.append(NL);
        builder.append("Attributes : ");
        builder.append(MultiLineToStringBuilder.toString(executionContext.getAttributes(), stack, EXECUTION_CONTEXT_FILTER_LIST));
        return builder.toString();
    }

    public static String toString(Map<? extends Object, ? extends Object> map) {
        return MultiLineToStringBuilder.toString(map, Collections.emptyList());
    }

    public static String toString(Map<? extends Object, ? extends Object> map, List<?> filterKeyList) {
        Stack<Object> stack = new Stack<Object>();
        stack.add(new Object());
        return MultiLineToStringBuilder.toString(map, stack, filterKeyList);
    }

    public static String toString(Collection<? extends Object> collection) {
        return MultiLineToStringBuilder.toString(collection, Collections.emptyList());
    }

    public static String toString(Collection<? extends Object> collection, List<?> filterKeyList) {
        Stack<Object> stack = new Stack<Object>();
        stack.add(new Object());
        return MultiLineToStringBuilder.toString(collection, stack, filterKeyList);
    }

    public static String toString(Object[] array) {
        return MultiLineToStringBuilder.toString(array, Collections.emptyList());
    }

    public static String toString(Object[] array, List<?> filterKeyList) {
        Stack<Object> stack = new Stack<Object>();
        stack.add(new Object());
        return MultiLineToStringBuilder.toString(array, stack, filterKeyList);
    }

    private static String toString(Map<? extends Object, ? extends Object> map, Stack<Object> parentStack, List<?> filterKeys) {
        StringBuilder builder = new StringBuilder();
        builder.append(CURLY_BRACKET_OPEN);
        String indent = StringUtils.repeat((String)SPACE, (int)(parentStack.size() * 3));
        String bracketIndent = StringUtils.repeat((String)SPACE, (int)((parentStack.size() - 1) * 3));
        int i = 0;
        int size = map.entrySet().size();
        for (Map.Entry<? extends Object, ? extends Object> entry : map.entrySet()) {
            String key = entry.getKey().toString();
            if (filterKeys.contains(key)) continue;
            builder.append(NL);
            Object value = entry.getValue();
            builder.append(indent);
            builder.append(QUOTE);
            builder.append(key);
            builder.append(QUOTE);
            builder.append(VALUE_KEY_SEPARATOR);
            if (value == null) {
                builder.append(NULL);
            } else if (MultiLineToStringBuilder.isTraversable(value) && parentStack.contains(value)) {
                MultiLineToStringBuilder.processParent(parentStack, builder, value);
            } else if (value == map) {
                builder.append(THIS);
            } else {
                MultiLineToStringBuilder.processValue(map, value, key, parentStack, builder, filterKeys);
            }
            if (++i >= size) continue;
            builder.append(COMMA);
        }
        if (i > 0) {
            builder.append(NL);
            builder.append(bracketIndent);
        }
        builder.append(CURLY_BRACKET_CLOSE);
        return builder.toString();
    }

    private static String toString(Collection<? extends Object> collection, Stack<Object> parentStack, List<?> filterKeys) {
        StringBuilder builder = new StringBuilder();
        builder.append(SQUARE_BRACKET_OPEN);
        String indent = StringUtils.repeat((String)SPACE, (int)(parentStack.size() * 3));
        String bracketIndent = StringUtils.repeat((String)SPACE, (int)((parentStack.size() - 1) * 3));
        int i = 0;
        int size = collection.size();
        for (Object object : collection) {
            builder.append(NL);
            builder.append(indent);
            if (object == null) {
                builder.append(NULL);
            } else if (MultiLineToStringBuilder.isTraversable(object) && parentStack.contains(object)) {
                MultiLineToStringBuilder.processParent(parentStack, builder, object);
            } else if (object == collection) {
                builder.append(THIS);
            } else {
                MultiLineToStringBuilder.processValue(collection, object, null, parentStack, builder, filterKeys);
            }
            if (++i >= size) continue;
            builder.append(COMMA);
        }
        if (i > 0) {
            builder.append(NL);
            builder.append(bracketIndent);
        }
        builder.append(SQUARE_BRACKET_CLOSE);
        return builder.toString();
    }

    private static String toString(Object[] array, Stack<Object> parentStack, List<?> filterKeys) {
        StringBuilder builder = new StringBuilder();
        builder.append(SQUARE_BRACKET_OPEN);
        String indent = StringUtils.repeat((String)SPACE, (int)(parentStack.size() * 3));
        String bracketIndent = StringUtils.repeat((String)SPACE, (int)((parentStack.size() - 1) * 3));
        int i = 0;
        int size = array.length;
        for (Object value : array) {
            builder.append(NL);
            builder.append(indent);
            if (value == null) {
                builder.append(NULL);
            } else if (MultiLineToStringBuilder.isTraversable(value) && parentStack.contains(value)) {
                MultiLineToStringBuilder.processParent(parentStack, builder, value);
            } else if (value == array) {
                builder.append(THIS);
            } else {
                MultiLineToStringBuilder.processValue(array, value, null, parentStack, builder, filterKeys);
            }
            if (++i >= size) continue;
            builder.append(COMMA);
        }
        if (i > 0) {
            builder.append(NL);
            builder.append(bracketIndent);
        }
        builder.append(SQUARE_BRACKET_CLOSE);
        return builder.toString();
    }

    private static void processParent(Stack<Object> parentStack, StringBuilder builder, Object value) {
        int index = parentStack.indexOf(value);
        builder.append(PARENT_OPEN).append(parentStack.size() - index).append(PARENT_CLOSE);
    }

    private static void processValue(Object current, Object value, String key, Stack<Object> parentStack, StringBuilder builder, List<?> filterKeys) {
        if (value instanceof Map) {
            parentStack.push(current);
            builder.append(MultiLineToStringBuilder.toString((Map)value, parentStack, filterKeys));
            parentStack.pop();
        } else if (value instanceof Collection) {
            parentStack.push(current);
            builder.append(MultiLineToStringBuilder.toString((Collection)value, parentStack, filterKeys));
            parentStack.pop();
        } else if (value.getClass().isArray()) {
            parentStack.push(current);
            builder.append(MultiLineToStringBuilder.toString((Object[])value, parentStack, filterKeys));
            parentStack.pop();
        } else if (value instanceof Number) {
            builder.append(value);
        } else {
            builder.append(QUOTE);
            String valueStr = value.toString();
            Matcher matcher = NL_PATTERN.matcher(valueStr);
            if (matcher.find()) {
                int keyLength = key == null ? 0 : key.length() + VALUE_KEY_SEPARATOR.length();
                String spaces = StringUtils.repeat((String)SPACE, (int)(keyLength + parentStack.size() * 3));
                valueStr = matcher.replaceAll(NL + spaces);
                builder.append(valueStr);
            } else {
                builder.append(valueStr);
            }
            builder.append(QUOTE);
        }
    }

    private static boolean isTraversable(Object obj) {
        return obj instanceof Collection || obj instanceof Map || obj.getClass().isArray();
    }

    static {
        EXECUTION_CONTEXT_FILTER_LIST.add(FilterResult.CONTEXT_KEY);
        EXECUTION_CONTEXT_FILTER_LIST.add(FilterSource.CONTEXT_KEY);
    }
}

