/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.xml;

import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dhatim.cdr.SmooksResourceConfiguration;
import org.dhatim.cdr.annotation.AppContext;
import org.dhatim.cdr.annotation.Config;
import org.dhatim.container.ApplicationContext;
import org.dhatim.container.ApplicationContextInitializer;
import org.dhatim.container.ExecutionContext;
import org.dhatim.delivery.annotation.Initialize;
import org.dhatim.namespace.NamespaceDeclarationStack;

public class NamespaceMappings
implements ApplicationContextInitializer {
    private static Log logger = LogFactory.getLog(NamespaceMappings.class);
    @Config
    private SmooksResourceConfiguration config;
    @AppContext
    private ApplicationContext appContext;

    @Initialize
    public void loadNamespaces() {
        Properties namespaces = NamespaceMappings.getMappings(this.appContext);
        Properties namespacesToAdd = this.config.toProperties();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Adding namespace prefix-to-uri mappings: " + namespacesToAdd));
        }
        namespaces.putAll((Map<?, ?>)namespacesToAdd);
        NamespaceMappings.setMappings(namespaces, this.appContext);
    }

    public static void setMappings(Properties namespaces, ApplicationContext appContext) {
        appContext.setAttribute(NamespaceMappings.class, namespaces);
    }

    public static Properties getMappings(ApplicationContext appContext) {
        Properties properties = (Properties)appContext.getAttribute(NamespaceMappings.class);
        if (properties == null) {
            return new Properties();
        }
        return properties;
    }

    public static void setNamespaceDeclarationStack(NamespaceDeclarationStack namespaceDeclarationStack, ExecutionContext executionContext) {
        executionContext.setAttribute(NamespaceDeclarationStack.class, namespaceDeclarationStack);
    }

    public static NamespaceDeclarationStack getNamespaceDeclarationStack(ExecutionContext executionContext) {
        return (NamespaceDeclarationStack)executionContext.getAttribute(NamespaceDeclarationStack.class);
    }
}

