/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.yaml;

import java.util.List;
import java.util.Map;
import org.dhatim.GenericReaderConfigurator;
import org.dhatim.ReaderConfigurator;
import org.dhatim.assertion.AssertArgument;
import org.dhatim.cdr.Parameter;
import org.dhatim.cdr.SmooksResourceConfiguration;
import org.dhatim.yaml.AliasStrategy;
import org.dhatim.yaml.YamlReader;

public class YamlReaderConfigurator
implements ReaderConfigurator {
    private String rootName = "yaml";
    private String documentName = "document";
    private String arrayElementName = "element";
    private String keyWhitspaceReplacement;
    private String keyPrefixOnNumeric;
    private String illegalElementNameCharReplacement;
    private Map<String, String> keyMap;
    private String targetProfile;
    private AliasStrategy aliasStrategy = AliasStrategy.REFER;
    private String anchorAttributeName = "id";
    private String aliasAttributeName = "ref";
    private boolean indent = false;

    public YamlReaderConfigurator setRootName(String rootName) {
        AssertArgument.isNotNull(rootName, "rootName");
        this.rootName = rootName;
        return this;
    }

    public YamlReaderConfigurator setDocumentName(String documentName) {
        AssertArgument.isNotNull(documentName, "documentName");
        this.documentName = documentName;
        return this;
    }

    public YamlReaderConfigurator setArrayElementName(String arrayElementName) {
        AssertArgument.isNotNull(arrayElementName, "arrayElementName");
        this.arrayElementName = arrayElementName;
        return this;
    }

    public YamlReaderConfigurator setKeyWhitspaceReplacement(String keyWhitspaceReplacement) {
        AssertArgument.isNotNull(keyWhitspaceReplacement, "keyWhitspaceReplacement");
        this.keyWhitspaceReplacement = keyWhitspaceReplacement;
        return this;
    }

    public YamlReaderConfigurator setKeyPrefixOnNumeric(String keyPrefixOnNumeric) {
        AssertArgument.isNotNull(keyPrefixOnNumeric, "keyPrefixOnNumeric");
        this.keyPrefixOnNumeric = keyPrefixOnNumeric;
        return this;
    }

    public YamlReaderConfigurator setIllegalElementNameCharReplacement(String illegalElementNameCharReplacement) {
        AssertArgument.isNotNull(illegalElementNameCharReplacement, "illegalElementNameCharReplacement");
        this.illegalElementNameCharReplacement = illegalElementNameCharReplacement;
        return this;
    }

    public YamlReaderConfigurator setKeyMap(Map<String, String> keyMap) {
        AssertArgument.isNotNull(keyMap, "keyMap");
        this.keyMap = keyMap;
        return this;
    }

    public YamlReaderConfigurator setTargetProfile(String targetProfile) {
        AssertArgument.isNotNullAndNotEmpty(targetProfile, "targetProfile");
        this.targetProfile = targetProfile;
        return this;
    }

    public YamlReaderConfigurator setAliasStrategy(AliasStrategy aliasStrategy) {
        AssertArgument.isNotNull((Object)aliasStrategy, "aliasStrategy");
        this.aliasStrategy = aliasStrategy;
        return this;
    }

    public YamlReaderConfigurator setAnchorAttributeName(String anchorAttributeName) {
        AssertArgument.isNotNull(anchorAttributeName, "anchorAttributeName");
        this.anchorAttributeName = anchorAttributeName;
        return this;
    }

    public YamlReaderConfigurator setAliasAttributeName(String aliasAttributeName) {
        AssertArgument.isNotNull(aliasAttributeName, "aliasAttributeName");
        this.aliasAttributeName = aliasAttributeName;
        return this;
    }

    public YamlReaderConfigurator setIndent(boolean indent) {
        this.indent = indent;
        return this;
    }

    @Override
    public List<SmooksResourceConfiguration> toConfig() {
        GenericReaderConfigurator configurator = new GenericReaderConfigurator(YamlReader.class);
        configurator.getParameters().setProperty("aliasStrategy", this.aliasStrategy.toString());
        configurator.getParameters().setProperty("anchorAttributeName", this.anchorAttributeName);
        configurator.getParameters().setProperty("aliasAttributeName", this.aliasAttributeName);
        configurator.getParameters().setProperty("indent", Boolean.toString(this.indent));
        configurator.getParameters().setProperty("rootName", this.rootName);
        configurator.getParameters().setProperty("documentName", this.documentName);
        configurator.getParameters().setProperty("arrayElementName", this.arrayElementName);
        if (this.keyWhitspaceReplacement != null) {
            configurator.getParameters().setProperty("keyWhitspaceReplacement", this.keyWhitspaceReplacement);
        }
        if (this.keyPrefixOnNumeric != null) {
            configurator.getParameters().setProperty("keyPrefixOnNumeric", this.keyPrefixOnNumeric);
        }
        if (this.illegalElementNameCharReplacement != null) {
            configurator.getParameters().setProperty("illegalElementNameCharReplacement", this.illegalElementNameCharReplacement);
        }
        configurator.setTargetProfile(this.targetProfile);
        List<SmooksResourceConfiguration> configList = configurator.toConfig();
        SmooksResourceConfiguration config = configList.get(0);
        if (this.keyMap != null) {
            Parameter keyMapParam = new Parameter("keyMap", this.keyMap);
            config.setParameter(keyMapParam);
        }
        return configList;
    }
}

