/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.smooks.camel.routing;

import java.io.IOException;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;
import org.dhatim.SmooksException;
import org.dhatim.assertion.AssertArgument;
import org.dhatim.cdr.SmooksConfigurationException;
import org.dhatim.cdr.SmooksResourceConfiguration;
import org.dhatim.cdr.annotation.AppContext;
import org.dhatim.cdr.annotation.Config;
import org.dhatim.cdr.annotation.ConfigParam;
import org.dhatim.container.ApplicationContext;
import org.dhatim.container.ExecutionContext;
import org.dhatim.delivery.ExecutionLifecycleCleanable;
import org.dhatim.delivery.ExecutionLifecycleInitializable;
import org.dhatim.delivery.annotation.Initialize;
import org.dhatim.delivery.annotation.Uninitialize;
import org.dhatim.delivery.ordering.Consumer;
import org.dhatim.delivery.sax.SAXElement;
import org.dhatim.delivery.sax.SAXVisitAfter;
import org.dhatim.expression.ExecutionContextExpressionEvaluator;
import org.dhatim.javabean.lifecycle.BeanContextLifecycleObserver;
import org.dhatim.smooks.camel.routing.BeanRouterObserver;
import org.dhatim.util.FreeMarkerTemplate;
import org.dhatim.util.FreeMarkerUtils;

public class BeanRouter
implements SAXVisitAfter,
Consumer,
ExecutionLifecycleInitializable,
ExecutionLifecycleCleanable {
    @ConfigParam
    private String beanId;
    @ConfigParam
    private String toEndpoint;
    @ConfigParam(use=ConfigParam.Use.OPTIONAL)
    private String correlationIdName;
    @ConfigParam(use=ConfigParam.Use.OPTIONAL)
    private FreeMarkerTemplate correlationIdPattern;
    @AppContext
    private ApplicationContext applicationContext;
    @Config
    SmooksResourceConfiguration routingConfig;
    private ProducerTemplate producerTemplate;
    private BeanRouterObserver camelRouterObserable;
    private CamelContext camelContext;

    public BeanRouter() {
    }

    public BeanRouter(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Initialize
    public void initialize() {
        if (this.routingConfig == null) {
            this.routingConfig = new SmooksResourceConfiguration();
        }
        this.producerTemplate = this.getCamelContext().createProducerTemplate();
        if (this.isBeanRoutingConfigured()) {
            this.camelRouterObserable = new BeanRouterObserver(this, this.beanId);
            this.camelRouterObserable.setConditionEvaluator((ExecutionContextExpressionEvaluator)this.routingConfig.getConditionEvaluator());
        }
        if (this.correlationIdName != null && this.correlationIdPattern == null) {
            throw new SmooksConfigurationException("Camel router component configured with a 'correlationIdName', but 'correlationIdPattern' is not configured.");
        }
        if (this.correlationIdName == null && this.correlationIdPattern != null) {
            throw new SmooksConfigurationException("Camel router component configured with a 'correlationIdPattern', but 'correlationIdName' is not configured.");
        }
    }

    public BeanRouter setBeanId(String beanId) {
        this.beanId = beanId;
        return this;
    }

    public BeanRouter setToEndpoint(String toEndpoint) {
        this.toEndpoint = toEndpoint;
        return this;
    }

    public BeanRouter setCorrelationIdName(String correlationIdName) {
        AssertArgument.isNotNullAndNotEmpty((String)correlationIdName, (String)"correlationIdName");
        this.correlationIdName = correlationIdName;
        return this;
    }

    public BeanRouter setCorrelationIdPattern(String correlationIdPattern) {
        this.correlationIdPattern = new FreeMarkerTemplate(correlationIdPattern);
        return this;
    }

    public void visitAfter(SAXElement element, ExecutionContext execContext) throws SmooksException, IOException {
        Object bean = this.getBeanFromExecutionContext(execContext, this.beanId);
        this.sendBean(bean, execContext);
    }

    protected void sendBean(final Object bean, final ExecutionContext execContext) {
        try {
            if (this.correlationIdPattern != null) {
                Processor processor = new Processor(){

                    public void process(Exchange exchange) {
                        Message in = exchange.getIn();
                        in.setBody(bean);
                        in.setHeader(BeanRouter.this.correlationIdName, (Object)BeanRouter.this.correlationIdPattern.apply((Object)FreeMarkerUtils.getMergedModel((ExecutionContext)execContext)));
                    }
                };
                this.producerTemplate.send(this.toEndpoint, processor);
            } else {
                this.producerTemplate.sendBodyAndHeaders(this.toEndpoint, bean, execContext.getBeanContext().getBeanMap());
            }
        }
        catch (Exception e) {
            throw new SmooksException("Exception routing beanId '" + this.beanId + "' to endpoint '" + this.toEndpoint + "'.", (Throwable)e);
        }
    }

    private Object getBeanFromExecutionContext(ExecutionContext execContext, String beanId) {
        Object bean = execContext.getBeanContext().getBean(beanId);
        if (bean == null) {
            throw new SmooksException("Exception routing beanId '" + beanId + "'. The bean was not found in the Smooks ExceutionContext.");
        }
        return bean;
    }

    private CamelContext getCamelContext() {
        if (this.camelContext == null) {
            return (CamelContext)this.applicationContext.getAttribute(CamelContext.class);
        }
        return this.camelContext;
    }

    private boolean isBeanRoutingConfigured() {
        return "none".equals(this.routingConfig.getSelector());
    }

    @Uninitialize
    public void uninitialize() {
        try {
            this.producerTemplate.stop();
        }
        catch (Exception e) {
            throw new SmooksException(e.getMessage(), (Throwable)e);
        }
    }

    public boolean consumes(Object object) {
        return this.beanId.equals(object);
    }

    public void executeExecutionLifecycleInitialize(ExecutionContext executionContext) {
        if (this.isBeanRoutingConfigured()) {
            executionContext.getBeanContext().addObserver((BeanContextLifecycleObserver)this.camelRouterObserable);
        }
    }

    public void executeExecutionLifecycleCleanup(ExecutionContext executionContext) {
        if (this.isBeanRoutingConfigured()) {
            executionContext.getBeanContext().removeObserver((BeanContextLifecycleObserver)this.camelRouterObserable);
        }
    }
}

