/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.javabean.decoders;

import java.util.Arrays;
import java.util.List;
import org.dhatim.javabean.DataDecodeException;
import org.dhatim.javabean.DataDecoder;
import org.dhatim.javabean.DecodeType;

@DecodeType(value={Boolean.class, boolean.class})
public class BooleanDecoder
implements DataDecoder {
    private static List<String> trueValues = Arrays.asList("y", "yes", "true", "1");
    private static List<String> falseValues = Arrays.asList("n", "no", "false", "0");

    public Object decode(String data) throws DataDecodeException {
        if (trueValues.contains(data.trim().toLowerCase())) {
            return Boolean.TRUE;
        }
        if (falseValues.contains(data.trim().toLowerCase())) {
            return Boolean.FALSE;
        }
        try {
            return Boolean.parseBoolean(data.trim());
        }
        catch (NumberFormatException e) {
            throw new DataDecodeException("Failed to decode Boolean value '" + data + "'.", (Throwable)e);
        }
    }
}

