/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.javabean.decoders;

import java.util.Arrays;
import java.util.Locale;
import java.util.Properties;
import org.dhatim.cdr.SmooksConfigurationException;
import org.dhatim.config.Configurable;
import org.dhatim.javabean.DataDecoder;

public abstract class LocaleAwareDecoder
implements DataDecoder,
Configurable {
    public static final String LOCALE = "locale";
    public static final String LOCALE_LANGUAGE_CODE = "locale-language";
    public static final String LOCALE_COUNTRY_CODE = "locale-country";
    public static final String VERIFY_LOCALE = "verify-locale";
    private Locale locale;
    private boolean verifyLocale;
    private Properties configuration;

    public void setConfiguration(Properties resourceConfig) throws SmooksConfigurationException {
        String countryCode;
        String languageCode;
        String locale = resourceConfig.getProperty(LOCALE);
        if (locale != null) {
            String[] localTokens = locale.indexOf(45) != -1 ? locale.split("-") : locale.split("_");
            languageCode = localTokens[0];
            countryCode = localTokens.length == 2 ? localTokens[1] : null;
        } else {
            languageCode = resourceConfig.getProperty(LOCALE_LANGUAGE_CODE);
            countryCode = resourceConfig.getProperty(LOCALE_COUNTRY_CODE);
        }
        this.verifyLocale = Boolean.parseBoolean(resourceConfig.getProperty(VERIFY_LOCALE, "false"));
        this.locale = this.getLocale(languageCode, countryCode);
        this.configuration = resourceConfig;
    }

    public Properties getConfiguration() {
        return this.configuration;
    }

    public Locale getLocale() {
        return this.locale;
    }

    protected Locale getLocale(String languageCode, String countryCode) {
        Locale locale = null;
        if (languageCode == null) {
            return null;
        }
        locale = countryCode == null ? new Locale(languageCode.trim()) : new Locale(languageCode.trim(), countryCode.trim());
        if (this.verifyLocale && !this.isLocalInstalled(locale)) {
            throw new SmooksConfigurationException("Locale " + locale + " is not available on this system.");
        }
        return locale;
    }

    protected boolean isLocalInstalled(Locale locale) {
        return Arrays.asList(Locale.getAvailableLocales()).contains(locale);
    }
}

