/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.javabean.decoders;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.dhatim.assertion.AssertArgument;
import org.dhatim.javabean.DataDecodeException;
import org.dhatim.javabean.DataDecoder;
import org.dhatim.javabean.DataEncoder;
import org.dhatim.javabean.DecodeType;
import org.dhatim.javabean.decoders.LocaleAwareDateDecoder;

@DecodeType(value={Date.class})
public class DateDecoder
extends LocaleAwareDateDecoder
implements DataDecoder,
DataEncoder {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object decode(String data) throws DataDecodeException {
        try {
            SimpleDateFormat simpleDateFormat = this.decoder;
            synchronized (simpleDateFormat) {
                return this.decoder.parse(data.trim());
            }
        }
        catch (ParseException e) {
            throw new DataDecodeException("Error decoding Date data value '" + data + "' with decode format '" + this.format + "'.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String encode(Object date) throws DataDecodeException {
        AssertArgument.isNotNull((Object)date, (String)"date");
        if (!(date instanceof Date)) {
            throw new DataDecodeException("Cannot encode Object type '" + date.getClass().getName() + "'.  Must be type '" + Date.class.getName() + "'.");
        }
        SimpleDateFormat simpleDateFormat = this.decoder;
        synchronized (simpleDateFormat) {
            return this.decoder.format((Date)date);
        }
    }
}

