/*
 * Decompiled with CFR 0.152.
 */
package example;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.camel.CamelContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class Main {
    private static final String camelConfig = "META-INF/spring/camel-context.xml";

    public static void main(String ... args) throws Exception {
        CamelContext camelContext = Main.configureAndStartCamel(camelConfig);
        Thread.sleep(3000L);
        camelContext.stop();
        Main.printEndMessage();
    }

    private static void pause(String message) {
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            System.out.print("> " + message);
            in.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("\n");
    }

    private static CamelContext configureAndStartCamel(String camelConfig) throws Exception {
        ClassPathXmlApplicationContext springContext = new ClassPathXmlApplicationContext(camelConfig);
        return (CamelContext)springContext.getBean("camelContext");
    }

    private static void printEndMessage() {
        System.out.println("\n\n");
        Main.pause("And that's it!  Press 'enter' to finish...");
    }
}

