/*
 * Decompiled with CFR 0.152.
 */
package example;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Locale;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.dhatim.Smooks;
import org.dhatim.SmooksException;
import org.dhatim.container.ExecutionContext;
import org.dhatim.event.ExecutionEventListener;
import org.dhatim.event.report.HtmlReportGenerator;
import org.dhatim.io.StreamUtils;
import org.dhatim.payload.StringResult;
import org.xml.sax.SAXException;

public class Main {
    private static byte[] messageIn = Main.readInputMessage();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String runSmooksTransform() throws IOException, SAXException, SmooksException {
        Locale defaultLocale = Locale.getDefault();
        Locale.setDefault(new Locale("en", "IE"));
        try (Smooks smooks = new Smooks("smooks-config.xml");){
            ExecutionContext executionContext = smooks.createExecutionContext();
            StringResult result = new StringResult();
            executionContext.setEventListener((ExecutionEventListener)new HtmlReportGenerator("target/report/report.html"));
            smooks.filterSource(executionContext, (Source)new StreamSource(new ByteArrayInputStream(messageIn)), new Result[]{result});
            Locale.setDefault(defaultLocale);
            String string = result.getResult();
            return string;
        }
    }

    public static void main(String[] args) throws IOException, SAXException, SmooksException {
        System.out.println("\n\n==============Message In==============");
        System.out.println(new String(messageIn));
        System.out.println("======================================\n");
        Main.pause("The EDI input stream can be seen above.  Press 'enter' to see this stream transformed into XML...");
        String messageOut = Main.runSmooksTransform();
        System.out.println("==============Message Out=============");
        System.out.println(messageOut);
        System.out.println("======================================\n\n");
        Main.pause("And that's it!  Press 'enter' to finish...");
    }

    private static byte[] readInputMessage() {
        try {
            return StreamUtils.readStream((InputStream)new FileInputStream("input-message.edi"));
        }
        catch (IOException e) {
            e.printStackTrace();
            return "<no-message/>".getBytes();
        }
    }

    private static void pause(String message) {
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            System.out.print("> " + message);
            in.readLine();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.out.println("\n");
    }
}

