/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.javabean;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dhatim.javabean.DataDecodeException;
import org.dhatim.javabean.DecodeType;
import org.dhatim.javabean.decoders.EnumDecoder;
import org.dhatim.javabean.decoders.StringDecoder;
import org.dhatim.util.ClassUtil;

public interface DataDecoder
extends Serializable {
    public Object decode(String var1) throws DataDecodeException;

    public static class Factory {
        private static Log logger = LogFactory.getLog(DataDecoder.class);
        private static volatile Map<Class, Class<? extends DataDecoder>> installedDecoders;

        public static DataDecoder create(Class targetType) throws DataDecodeException {
            Class<? extends DataDecoder> decoderType = Factory.getInstance(targetType);
            if (decoderType != null) {
                if (decoderType == EnumDecoder.class) {
                    EnumDecoder decoder = new EnumDecoder();
                    decoder.setEnumType(targetType);
                    return decoder;
                }
                return Factory.newInstance(decoderType);
            }
            return null;
        }

        public static Class<? extends DataDecoder> getInstance(Class targetType) {
            if (installedDecoders == null) {
                Factory.loadInstalledDecoders();
            }
            if (targetType.isEnum()) {
                return EnumDecoder.class;
            }
            return installedDecoders.get(targetType);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static synchronized void loadInstalledDecoders() throws DataDecodeException {
            if (installedDecoders != null) return;
            Class<Factory> clazz = Factory.class;
            synchronized (Factory.class) {
                if (installedDecoders != null) return;
                List decoders = ClassUtil.getClasses((String)"META-INF/data-decoders.inf", DataDecoder.class);
                if (decoders.isEmpty()) {
                    throw new DataDecodeException("Failed to find installed DataDecoders on clasaspath.");
                }
                installedDecoders = new HashMap<Class, Class<? extends DataDecoder>>();
                for (Class decoder : decoders) {
                    Class[] types;
                    DecodeType decoodeType = decoder.getAnnotation(DecodeType.class);
                    if (decoodeType == null) continue;
                    for (Class type : types = decoodeType.value()) {
                        if (installedDecoders.containsKey(type)) {
                            logger.warn((Object)("More than one DataDecoder for type '" + type.getName() + "' is installed on the classpath.  You must manually configure decoding of this type, where required."));
                            installedDecoders.put(type, null);
                            continue;
                        }
                        installedDecoders.put(type, decoder);
                    }
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
        }

        public static Map<Class, Class<? extends DataDecoder>> getInstalledDecoders() {
            if (installedDecoders == null) {
                Factory.loadInstalledDecoders();
            }
            return Collections.unmodifiableMap(installedDecoders);
        }

        public static DataDecoder create(String typeAlias) throws DataDecodeException {
            if (typeAlias == null) {
                return new StringDecoder();
            }
            String className = StringDecoder.class.getPackage().getName() + "." + typeAlias + "Decoder";
            try {
                Class decoderType = ClassUtil.forName((String)className, DataDecoder.class);
                return Factory.newInstance(decoderType);
            }
            catch (ClassNotFoundException e) {
                try {
                    Class decoderType = ClassUtil.forName((String)typeAlias, DataDecoder.class);
                    return Factory.newInstance(decoderType);
                }
                catch (ClassNotFoundException e1) {
                    throw new DataDecodeException("DataDecoder Class '" + className + "' is not available on the classpath.");
                }
            }
        }

        private static DataDecoder newInstance(Class decoderType) throws DataDecodeException {
            try {
                return (DataDecoder)decoderType.newInstance();
            }
            catch (ClassCastException e) {
                throw new DataDecodeException("Class '" + decoderType.getName() + "' is not a valid DataDecoder.  It doesn't implement " + DataDecoder.class.getName());
            }
            catch (IllegalAccessException e) {
                throw new DataDecodeException("Failed to load DataDecoder Class '" + decoderType.getName() + "'.", e);
            }
            catch (InstantiationException e) {
                throw new DataDecodeException("Failed to load DataDecoder Class '" + decoderType.getName() + "'.", e);
            }
        }
    }
}

