/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.javabean.context;

import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import org.dhatim.container.ExecutionContext;
import org.dhatim.javabean.context.BeanIdStore;
import org.dhatim.javabean.context.StandaloneBeanContext;
import org.dhatim.payload.FilterResult;
import org.dhatim.payload.FilterSource;
import org.dhatim.payload.JavaResult;
import org.dhatim.payload.JavaSource;

public class StandaloneBeanContextFactory {
    public static StandaloneBeanContext create(ExecutionContext executionContext) {
        BeanIdStore beanIdStore = executionContext.getContext().getBeanIdStore();
        Map<String, Object> beanMap = StandaloneBeanContextFactory.createBeanMap(executionContext, beanIdStore);
        StandaloneBeanContext beanContext = new StandaloneBeanContext(executionContext, beanIdStore, beanMap);
        return beanContext;
    }

    private static Map<String, Object> createBeanMap(ExecutionContext executionContext, BeanIdStore beanIdStore) {
        JavaSource javaSource;
        Map sourceBeans;
        Result result = FilterResult.getResult((ExecutionContext)executionContext, JavaResult.class);
        Source source = FilterSource.getSource((ExecutionContext)executionContext);
        Map<String, Object> beanMap = null;
        if (result != null) {
            JavaResult javaResult = (JavaResult)result;
            beanMap = javaResult.getResultMap();
        }
        if (source instanceof JavaSource && (sourceBeans = (javaSource = (JavaSource)source).getBeans()) != null) {
            if (beanMap != null) {
                beanMap.putAll(sourceBeans);
            } else {
                beanMap = sourceBeans;
            }
        }
        if (beanMap == null) {
            beanMap = new HashMap<String, Object>();
        } else {
            for (String beanId : beanMap.keySet()) {
                if (beanIdStore.containsBeanId(beanId)) continue;
                beanIdStore.register(beanId);
            }
        }
        return beanMap;
    }
}

