/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.javabean.dynamic.ext;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.dhatim.cdr.SmooksConfigurationException;
import org.dhatim.cdr.SmooksResourceConfiguration;
import org.dhatim.cdr.annotation.AppContext;
import org.dhatim.cdr.annotation.Config;
import org.dhatim.cdr.annotation.ConfigParam;
import org.dhatim.cdr.annotation.Configurator;
import org.dhatim.container.ApplicationContext;
import org.dhatim.delivery.ContentHandler;
import org.dhatim.delivery.annotation.Initialize;
import org.dhatim.javabean.dynamic.serialize.BeanWriter;

public class BeanWriterFactory
implements ContentHandler {
    @ConfigParam
    private String beanId;
    @ConfigParam(name="class")
    private Class<? extends BeanWriter> beanWriterClass;
    @ConfigParam(name="beanClass")
    private Class<?> beanClass;
    @Config
    private SmooksResourceConfiguration config;
    @AppContext
    private ApplicationContext appContext;

    @Initialize
    public void createBeanWriter() {
        try {
            BeanWriter beanWriter = this.beanWriterClass.newInstance();
            Configurator.configure((Object)beanWriter, (SmooksResourceConfiguration)this.config, (ApplicationContext)this.appContext);
            BeanWriterFactory.getBeanWriters(this.beanClass, this.appContext).put(this.config.getSelectorNamespaceURI(), beanWriter);
        }
        catch (InstantiationException e) {
            throw new SmooksConfigurationException("Unable to create BeanWriter instance.", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new SmooksConfigurationException("Unable to create BeanWriter instance.", (Throwable)e);
        }
    }

    public static Map<String, BeanWriter> getBeanWriters(Class<?> beanClass, ApplicationContext appContext) {
        Map<Class<?>, Map<String, BeanWriter>> beanWriterMap = BeanWriterFactory.getBeanWriters(appContext);
        Map<String, BeanWriter> beanWriters = beanWriterMap.get(beanClass);
        if (beanWriters == null) {
            beanWriters = new LinkedHashMap<String, BeanWriter>();
            beanWriterMap.put(beanClass, beanWriters);
        }
        return beanWriters;
    }

    public static Map<Class<?>, Map<String, BeanWriter>> getBeanWriters(ApplicationContext appContext) {
        HashMap beanWriters = (HashMap)appContext.getAttribute(BeanWriter.class);
        if (beanWriters == null) {
            beanWriters = new HashMap();
            appContext.setAttribute(BeanWriter.class, beanWriters);
        }
        return beanWriters;
    }
}

