/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.javabean.dynamic.serialize.freemarker;

import freemarker.core.Environment;
import freemarker.ext.beans.BeanModel;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dhatim.javabean.dynamic.BeanMetadata;
import org.dhatim.javabean.dynamic.BeanRegistrationException;
import org.dhatim.javabean.dynamic.Model;
import org.dhatim.javabean.dynamic.serialize.BeanWriter;
import org.dhatim.javabean.dynamic.serialize.freemarker.AbstractBeanDirective;
import org.dhatim.xml.XmlUtil;

public class WriteBeanDirective
extends AbstractBeanDirective {
    private static Log logger = LogFactory.getLog(WriteBeanDirective.class);

    public void execute(Environment environment, Map params, TemplateModel[] templateModels, TemplateDirectiveBody templateDirectiveBody) throws TemplateException, IOException {
        BeanModel modelBeanModel;
        Model model;
        BeanMetadata beanMetadata;
        Object bean = this.getBeanObject(environment, params, "writeBean");
        SimpleScalar indentScalar = (SimpleScalar)params.get("indent");
        int indent = 0;
        if (indentScalar != null) {
            String indentParamVal = indentScalar.getAsString().trim();
            try {
                indent = Integer.parseInt(indentParamVal);
                indent = Math.min(indent, 100);
            }
            catch (NumberFormatException e) {
                logger.debug((Object)("Invalid <@writeNamespaces> 'indent' parameter value '" + indentParamVal + "'.  Must be a valid integer (<= 100)."));
            }
        }
        if ((beanMetadata = (model = (Model)(modelBeanModel = (BeanModel)environment.getDataModel().get("dyna_model_inst")).getWrappedObject()).getBeanMetadata(bean)) == null) {
            BeanRegistrationException.throwUnregisteredBeanInstanceException(bean);
        }
        BeanWriter beanWriter = beanMetadata.getWriter();
        if (beanMetadata.getPreText() != null) {
            environment.getOut().write(beanMetadata.getPreText());
        }
        if (indent > 0) {
            StringWriter beanWriteBuffer = new StringWriter();
            beanWriteBuffer.write(10);
            beanWriter.write(bean, beanWriteBuffer, model);
            environment.getOut().write(XmlUtil.indent((String)beanWriteBuffer.toString(), (int)indent));
        } else {
            beanWriter.write(bean, environment.getOut(), model);
        }
    }
}

