/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.javabean;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dhatim.SmooksException;
import org.dhatim.assertion.AssertArgument;
import org.dhatim.cdr.Parameter;
import org.dhatim.cdr.SmooksConfigurationException;
import org.dhatim.cdr.SmooksResourceConfiguration;
import org.dhatim.cdr.annotation.AppContext;
import org.dhatim.cdr.annotation.Config;
import org.dhatim.cdr.annotation.ConfigParam;
import org.dhatim.container.ApplicationContext;
import org.dhatim.container.ExecutionContext;
import org.dhatim.delivery.ContentDeliveryConfigBuilderLifecycleEvent;
import org.dhatim.delivery.ContentDeliveryConfigBuilderLifecycleListener;
import org.dhatim.delivery.Fragment;
import org.dhatim.delivery.VisitLifecycleCleanable;
import org.dhatim.delivery.annotation.Initialize;
import org.dhatim.delivery.dom.DOMElementVisitor;
import org.dhatim.delivery.ordering.Producer;
import org.dhatim.delivery.sax.SAXElement;
import org.dhatim.delivery.sax.SAXVisitAfter;
import org.dhatim.delivery.sax.SAXVisitBefore;
import org.dhatim.event.report.annotation.VisitAfterReport;
import org.dhatim.event.report.annotation.VisitBeforeReport;
import org.dhatim.expression.MVELExpressionEvaluator;
import org.dhatim.javabean.BeanRuntimeInfo;
import org.dhatim.javabean.BeanUtils;
import org.dhatim.javabean.binding.model.ModelSet;
import org.dhatim.javabean.context.BeanContext;
import org.dhatim.javabean.factory.Factory;
import org.dhatim.javabean.factory.FactoryDefinitionParser;
import org.dhatim.javabean.lifecycle.BeanContextLifecycleEvent;
import org.dhatim.javabean.lifecycle.BeanLifecycle;
import org.dhatim.javabean.repository.BeanId;
import org.dhatim.util.CollectionsUtil;
import org.w3c.dom.Element;

@VisitBeforeReport(summary="Created <b>${resource.parameters.beanId!'undefined'}</b> bean instance.  Associated lifecycle if wired to another bean.", detailTemplate="reporting/BeanInstanceCreatorReport_Before.html")
@VisitAfterReport(condition="parameters.containsKey('setOn') || parameters.beanClass.value.endsWith('[]')", summary="Ended bean lifecycle. Set bean on any targets.", detailTemplate="reporting/BeanInstanceCreatorReport_After.html")
public class BeanInstanceCreator
implements DOMElementVisitor,
SAXVisitBefore,
SAXVisitAfter,
ContentDeliveryConfigBuilderLifecycleListener,
Producer,
VisitLifecycleCleanable {
    private static Log logger = LogFactory.getLog(BeanInstanceCreator.class);
    public static final String INIT_VAL_EXPRESSION = "initValExpression";
    private String id;
    @ConfigParam(name="beanId")
    private String beanIdName;
    @ConfigParam(name="beanClass", use=ConfigParam.Use.OPTIONAL)
    private String beanClassName;
    @ConfigParam(name="beanFactory", use=ConfigParam.Use.OPTIONAL)
    private String beanFactoryDefinition;
    @ConfigParam(defaultVal="true")
    private boolean retain = true;
    @Config
    private SmooksResourceConfiguration config;
    @AppContext
    private ApplicationContext appContext;
    private BeanRuntimeInfo beanRuntimeInfo;
    private BeanId beanId;
    private MVELExpressionEvaluator initValsExpression;
    private Factory<?> factory;

    public BeanInstanceCreator() {
    }

    public BeanInstanceCreator(String beanId, Class<?> beanClass) {
        this(beanId, beanClass, null);
    }

    public <T> BeanInstanceCreator(String beanId, Class<T> beanClass, Factory<? extends T> factory) {
        AssertArgument.isNotNull((Object)beanId, (String)"beanId");
        AssertArgument.isNotNull(beanClass, (String)"beanClass");
        this.beanIdName = beanId;
        this.beanClassName = BeanInstanceCreator.toClassName(beanClass);
        this.factory = factory;
    }

    public String getBeanId() {
        return this.beanIdName;
    }

    public SmooksResourceConfiguration getConfig() {
        return this.config;
    }

    @Initialize
    public void initialize() throws SmooksConfigurationException {
        List initValExpressions;
        this.buildId();
        this.beanId = this.appContext.getBeanIdStore().register(this.beanIdName);
        this.beanId.setCreateResourceConfiguration(this.config);
        if (StringUtils.isNotBlank((String)this.beanFactoryDefinition)) {
            int aliasSplitterIndex;
            String alias = null;
            String definition = this.beanFactoryDefinition;
            if (definition.indexOf("#") == -1) {
                try {
                    URI definitionURI = new URI(definition);
                    if (definitionURI.getScheme() == null) {
                        definition = "mvel:" + definition;
                    }
                }
                catch (URISyntaxException e) {
                    // empty catch block
                }
            }
            if ((aliasSplitterIndex = definition.indexOf(58)) > 0) {
                alias = definition.substring(0, aliasSplitterIndex);
                definition = definition.substring(aliasSplitterIndex + 1);
            }
            this.factory = FactoryDefinitionParser.FactoryDefinitionParserFactory.getInstance(alias, this.appContext).parse(definition);
        }
        this.beanRuntimeInfo = BeanRuntimeInfo.getBeanRuntimeInfo(this.beanIdName, this.beanClassName, this.appContext);
        if (this.factory == null) {
            this.checkForDefaultConstructor();
        } else if (this.beanRuntimeInfo.getClassification() == BeanRuntimeInfo.Classification.ARRAY_COLLECTION) {
            throw new SmooksConfigurationException("Using a factory with an array is not supported");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("BeanInstanceCreator created for [" + this.beanIdName + "]. BeanRuntimeInfo: " + this.beanRuntimeInfo));
        }
        if ((initValExpressions = this.config.getParameters(INIT_VAL_EXPRESSION)) != null && !initValExpressions.isEmpty()) {
            StringBuilder initValsExpressionString = new StringBuilder();
            for (Parameter initValExpression : initValExpressions) {
                initValsExpressionString.append(initValExpression.getValue());
                initValsExpressionString.append("\n");
            }
            this.initValsExpression = new MVELExpressionEvaluator();
            this.initValsExpression.setExpression(initValsExpressionString.toString());
        }
    }

    public void handle(ContentDeliveryConfigBuilderLifecycleEvent event) throws SmooksConfigurationException {
        if (event == ContentDeliveryConfigBuilderLifecycleEvent.CONFIG_BUILDER_CREATED) {
            ModelSet.build(this.appContext);
        }
    }

    public BeanRuntimeInfo getBeanRuntimeInfo() {
        return this.beanRuntimeInfo;
    }

    private void buildId() {
        StringBuilder idBuilder = new StringBuilder();
        idBuilder.append(BeanInstanceCreator.class.getName());
        idBuilder.append("#");
        idBuilder.append(this.beanIdName);
        this.id = idBuilder.toString();
    }

    public void visitBefore(Element element, ExecutionContext executionContext) throws SmooksException {
        this.createAndSetBean(executionContext, new Fragment(element));
    }

    public void visitBefore(SAXElement element, ExecutionContext executionContext) throws SmooksException, IOException {
        this.createAndSetBean(executionContext, new Fragment(element));
    }

    public void visitAfter(Element element, ExecutionContext executionContext) throws SmooksException {
        this.visitAfter(executionContext, new Fragment(element));
    }

    public void visitAfter(SAXElement element, ExecutionContext executionContext) throws SmooksException, IOException {
        this.visitAfter(executionContext, new Fragment(element));
    }

    public void visitAfter(ExecutionContext executionContext, Fragment source) {
        BeanRuntimeInfo.Classification thisBeanType = this.beanRuntimeInfo.getClassification();
        boolean isBeanTypeArray = thisBeanType == BeanRuntimeInfo.Classification.ARRAY_COLLECTION;
        BeanContext beanContext = executionContext.getBeanContext();
        beanContext.setBeanInContext(this.beanId, false);
        if (isBeanTypeArray) {
            Object bean = beanContext.getBean(this.beanId);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Converting bean [" + this.beanIdName + "] to an array and rebinding to context."));
            }
            bean = this.convert(executionContext, bean, source);
        }
    }

    private Object convert(ExecutionContext executionContext, Object bean, Fragment source) {
        bean = BeanUtils.convertListToArray((List)bean, this.beanRuntimeInfo.getArrayType());
        executionContext.getBeanContext().changeBean(this.beanId, bean, source);
        return bean;
    }

    private void createAndSetBean(ExecutionContext executionContext, Fragment source) {
        BeanContext beanContext = executionContext.getBeanContext();
        Object bean = this.createBeanInstance(executionContext);
        executionContext.getBeanContext().notifyObservers(new BeanContextLifecycleEvent(executionContext, source, BeanLifecycle.START_FRAGMENT, this.beanId, bean));
        if (this.initValsExpression != null) {
            this.initValsExpression.exec(bean);
        }
        beanContext.setBeanInContext(this.beanId, false);
        beanContext.addBean(this.beanId, bean, source);
        beanContext.setBeanInContext(this.beanId, true);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Bean [" + this.beanIdName + "] instance created."));
        }
    }

    private Object createBeanInstance(ExecutionContext executionContext) {
        Object bean;
        if (this.factory == null) {
            try {
                bean = this.beanRuntimeInfo.getPopulateType().newInstance();
            }
            catch (InstantiationException e) {
                throw new SmooksConfigurationException("Unable to create bean instance [" + this.beanIdName + ":" + this.beanRuntimeInfo.getPopulateType().getName() + "].", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new SmooksConfigurationException("Unable to create bean instance [" + this.beanIdName + ":" + this.beanRuntimeInfo.getPopulateType().getName() + "].", (Throwable)e);
            }
        }
        try {
            bean = this.factory.create(executionContext);
        }
        catch (RuntimeException e) {
            throw new SmooksConfigurationException("The factory was unable to create the bean instance [" + this.beanIdName + "] using the factory '" + this.factory + "'.", (Throwable)e);
        }
        return bean;
    }

    public Set<? extends Object> getProducts() {
        return CollectionsUtil.toSet((Object[])new String[]{this.beanIdName});
    }

    private String getId() {
        return this.id;
    }

    public String toString() {
        return this.getId();
    }

    private static String toClassName(Class<?> beanClass) {
        if (!beanClass.isArray()) {
            return beanClass.getName();
        }
        return beanClass.getComponentType().getName() + "[]";
    }

    private void checkForDefaultConstructor() {
        try {
            this.beanRuntimeInfo.getPopulateType().getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new SmooksConfigurationException("Invalid Smooks bean configuration.  Bean class " + this.beanRuntimeInfo.getPopulateType().getName() + " doesn't have a public default constructor.");
        }
    }

    public void executeVisitLifecycleCleanup(Fragment fragment, ExecutionContext executionContext) {
        BeanContext beanContext = executionContext.getBeanContext();
        Object bean = beanContext.getBean(this.beanId);
        beanContext.notifyObservers(new BeanContextLifecycleEvent(executionContext, fragment, BeanLifecycle.END_FRAGMENT, this.beanId, bean));
        if (!this.retain) {
            beanContext.removeBean(this.beanId, null);
        }
    }
}

