/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.javabean.dynamic.serialize.freemarker;

import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dhatim.cdr.annotation.AppContext;
import org.dhatim.cdr.annotation.ConfigParam;
import org.dhatim.container.ApplicationContext;
import org.dhatim.delivery.annotation.Initialize;
import org.dhatim.io.StreamUtils;
import org.dhatim.javabean.dynamic.BeanMetadata;
import org.dhatim.javabean.dynamic.BeanRegistrationException;
import org.dhatim.javabean.dynamic.Model;
import org.dhatim.javabean.dynamic.serialize.BeanWriter;
import org.dhatim.javabean.dynamic.serialize.freemarker.WriteAttribsDirective;
import org.dhatim.javabean.dynamic.serialize.freemarker.WriteBeanDirective;
import org.dhatim.javabean.dynamic.serialize.freemarker.WriteBeanPreTextDirective;
import org.dhatim.javabean.dynamic.serialize.freemarker.WriteNamespacesDirective;
import org.dhatim.util.FreeMarkerTemplate;

public class FreeMarkerBeanWriter
implements BeanWriter {
    private static Log logger = LogFactory.getLog(FreeMarkerBeanWriter.class);
    public static final String MODEL_CTX_KEY = "dyna_model_inst";
    @AppContext
    private ApplicationContext appContext;
    @ConfigParam(name="template")
    private String templateConfig;
    private FreeMarkerTemplate template;
    private static final WriteNamespacesDirective writeNamespacesDirective = new WriteNamespacesDirective();
    private static final WriteBeanDirective writeBeanDirective = new WriteBeanDirective();
    private static final WriteBeanPreTextDirective writePreTextDirective = new WriteBeanPreTextDirective();
    private static final WriteAttribsDirective writeAttribsDirective = new WriteAttribsDirective();

    @Initialize
    public void intialize() {
        String trimmedTemplateConfig = this.templateConfig.trim();
        if (trimmedTemplateConfig.trim().indexOf(10) == -1) {
            try {
                InputStream templateStream = this.appContext.getResourceLocator().getResource(trimmedTemplateConfig);
                if (templateStream != null) {
                    this.templateConfig = StreamUtils.readStreamAsString((InputStream)templateStream);
                }
            }
            catch (IOException e) {
                logger.debug((Object)("'template' configuration value '" + trimmedTemplateConfig + "' does not resolve to an external FreeMarker template.  Using configured value as the actual template."));
            }
        }
        this.template = new FreeMarkerTemplate(this.templateConfig);
    }

    @Override
    public void write(Object bean, Writer writer, Model model) throws BeanRegistrationException, IOException {
        HashMap<String, Object> templateContext = new HashMap<String, Object>();
        BeanMetadata beanMetadata = model.getBeanMetadata(bean);
        if (beanMetadata == null) {
            BeanRegistrationException.throwUnregisteredBeanInstanceException(bean);
        }
        templateContext.put("bean", bean);
        templateContext.put(MODEL_CTX_KEY, model);
        templateContext.put("nsp", beanMetadata.getNamespacePrefix());
        templateContext.put("writeNamespaces", writeNamespacesDirective);
        templateContext.put("writeBean", writeBeanDirective);
        templateContext.put("writePreText", writePreTextDirective);
        templateContext.put("writeAttribs", writeAttribsDirective);
        this.template.apply(templateContext, writer);
    }
}

