/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.javabean.ext;

import org.apache.commons.lang.StringUtils;
import org.dhatim.SmooksException;
import org.dhatim.cdr.SmooksConfigurationException;
import org.dhatim.container.ExecutionContext;
import org.dhatim.delivery.dom.DOMVisitBefore;
import org.w3c.dom.Element;

public class WireOnElementChecker
implements DOMVisitBefore {
    public void visitBefore(Element element, ExecutionContext executionContext) throws SmooksException {
        if (!this.isCreateOnElementSet(element) && !this.isWireOnElementSet(element)) {
            throw new SmooksConfigurationException("The bindings attribute 'createOnElement' and wiring attribute 'wireOnElement' are both not set. One of them must at least be set. If the result of this binding should be a new populated Object then you need to set the 'createOnElement' bindings attribute. If you want to update an existing object in the bean context then you must set the 'wireOnElement' attribute.");
        }
    }

    private boolean isCreateOnElementSet(Element element) {
        return StringUtils.isNotEmpty((String)((Element)element.getParentNode()).getAttribute("createOnElement"));
    }

    private boolean isWireOnElementSet(Element element) {
        return StringUtils.isNotEmpty((String)element.getAttribute("wireOnElement"));
    }
}

