/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.persistence;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dhatim.SmooksException;
import org.dhatim.cdr.SmooksConfigurationException;
import org.dhatim.cdr.annotation.AppContext;
import org.dhatim.cdr.annotation.ConfigParam;
import org.dhatim.container.ApplicationContext;
import org.dhatim.container.ExecutionContext;
import org.dhatim.delivery.Fragment;
import org.dhatim.delivery.annotation.Initialize;
import org.dhatim.delivery.annotation.VisitAfterIf;
import org.dhatim.delivery.annotation.VisitBeforeIf;
import org.dhatim.delivery.dom.DOMElementVisitor;
import org.dhatim.delivery.ordering.Consumer;
import org.dhatim.delivery.ordering.Producer;
import org.dhatim.delivery.sax.SAXElement;
import org.dhatim.delivery.sax.SAXVisitAfter;
import org.dhatim.delivery.sax.SAXVisitBefore;
import org.dhatim.event.report.annotation.VisitAfterReport;
import org.dhatim.event.report.annotation.VisitBeforeReport;
import org.dhatim.javabean.context.BeanContext;
import org.dhatim.javabean.context.BeanIdStore;
import org.dhatim.javabean.repository.BeanId;
import org.dhatim.persistence.ApplicationContextObjectStore;
import org.dhatim.persistence.util.PersistenceUtil;
import org.dhatim.scribe.ObjectStore;
import org.dhatim.scribe.invoker.DaoInvoker;
import org.dhatim.scribe.invoker.DaoInvokerFactory;
import org.dhatim.scribe.register.DaoRegister;
import org.dhatim.util.CollectionsUtil;
import org.w3c.dom.Element;

@VisitBeforeIf(condition="parameters.containsKey('updateBefore') && parameters.updateBefore.value == 'true'")
@VisitAfterIf(condition="!parameters.containsKey('updateBefore') || parameters.updateBefore.value != 'true'")
@VisitBeforeReport(summary="Updating bean under beanId '${resource.parameters.beanId}'.", detailTemplate="reporting/EntityUpdater.html")
@VisitAfterReport(summary="Updating bean under beanId '${resource.parameters.beanId}'.", detailTemplate="reporting/EntityUpdater.html")
public class EntityUpdater
implements DOMElementVisitor,
SAXVisitBefore,
SAXVisitAfter,
Producer,
Consumer {
    private static Log logger = LogFactory.getLog(EntityUpdater.class);
    @ConfigParam(name="beanId")
    private String beanIdName;
    @ConfigParam(name="updatedBeanId", use=ConfigParam.Use.OPTIONAL)
    private String updatedBeanIdName;
    @ConfigParam(name="dao", use=ConfigParam.Use.OPTIONAL)
    private String daoName;
    @ConfigParam(use=ConfigParam.Use.OPTIONAL)
    private String name;
    @AppContext
    private ApplicationContext appContext;
    private ObjectStore objectStore;
    private BeanId beanId;
    private BeanId updatedBeanId;

    @Initialize
    public void initialize() throws SmooksConfigurationException {
        BeanIdStore beanIdStore = this.appContext.getBeanIdStore();
        this.beanId = beanIdStore.register(this.beanIdName);
        if (this.updatedBeanIdName != null) {
            this.updatedBeanId = beanIdStore.register(this.updatedBeanIdName);
        }
        this.objectStore = new ApplicationContextObjectStore(this.appContext);
    }

    public Set<? extends Object> getProducts() {
        if (this.updatedBeanIdName == null) {
            return Collections.emptySet();
        }
        return CollectionsUtil.toSet((Object[])new String[]{this.updatedBeanIdName});
    }

    public boolean consumes(Object object) {
        return object.equals(this.beanIdName);
    }

    public void visitBefore(Element element, ExecutionContext executionContext) throws SmooksException {
        this.update(executionContext, new Fragment(element));
    }

    public void visitAfter(Element element, ExecutionContext executionContext) throws SmooksException {
        this.update(executionContext, new Fragment(element));
    }

    public void visitBefore(SAXElement element, ExecutionContext executionContext) throws SmooksException, IOException {
        this.update(executionContext, new Fragment(element));
    }

    public void visitAfter(SAXElement element, ExecutionContext executionContext) throws SmooksException, IOException {
        this.update(executionContext, new Fragment(element));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(ExecutionContext executionContext, Fragment source) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Updating bean under BeanId '" + this.beanIdName + "' with DAO '" + this.daoName + "'."));
        }
        BeanContext beanContext = executionContext.getBeanContext();
        Object bean = beanContext.getBean(this.beanId);
        DaoRegister<?> emr = PersistenceUtil.getDAORegister(executionContext);
        Object dao = null;
        try {
            Object result;
            dao = this.daoName == null ? emr.getDefaultDao() : emr.getDao(this.daoName);
            if (dao == null) {
                throw new IllegalStateException("The DAO register returned null while getting the DAO '" + this.daoName + "'");
            }
            DaoInvoker daoInvoker = DaoInvokerFactory.getInstance().create(dao, this.objectStore);
            Object object = result = this.name == null ? daoInvoker.update(bean) : daoInvoker.update(this.name, bean);
            if (this.updatedBeanId != null) {
                if (result == null) {
                    result = bean;
                }
                beanContext.addBean(this.updatedBeanId, result, source);
            } else if (result != null && bean != result) {
                beanContext.changeBean(this.beanId, bean, source);
            }
        }
        finally {
            if (dao != null) {
                emr.returnDao(dao);
            }
        }
    }
}

