/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.persistence.observers;

import org.dhatim.container.ExecutionContext;
import org.dhatim.javabean.BeanRuntimeInfo;
import org.dhatim.javabean.lifecycle.BeanContextLifecycleEvent;
import org.dhatim.javabean.lifecycle.BeanContextLifecycleObserver;
import org.dhatim.javabean.lifecycle.BeanLifecycle;
import org.dhatim.javabean.repository.BeanId;
import org.dhatim.persistence.EntityLocatorParameterVisitor;

public class BeanCreateLifecycleObserver
implements BeanContextLifecycleObserver {
    private EntityLocatorParameterVisitor populator;
    private BeanId watchedBean;
    private BeanRuntimeInfo wiredBeanRI;
    private ArrayToListChangeObserver arrayToListChangeObserver;

    public BeanCreateLifecycleObserver(BeanId watchedBean, EntityLocatorParameterVisitor populator, BeanRuntimeInfo wiredBeanRI) {
        this.watchedBean = watchedBean;
        this.populator = populator;
        this.wiredBeanRI = wiredBeanRI;
    }

    public void onBeanLifecycleEvent(BeanContextLifecycleEvent event) {
        if (event.getBean() == this.watchedBean) {
            switch (event.getLifecycle()) {
                case ADD: {
                    if (this.wiredBeanRI != null && this.wiredBeanRI.getClassification() == BeanRuntimeInfo.Classification.ARRAY_COLLECTION) {
                        this.arrayToListChangeObserver = new ArrayToListChangeObserver();
                        event.getExecutionContext().getBeanContext().addObserver((BeanContextLifecycleObserver)this.arrayToListChangeObserver);
                    } else {
                        this.populator.populateAndSetPropertyValue(event.getBean(), event.getExecutionContext());
                    }
                }
                case REMOVE: {
                    try {
                        if (this.arrayToListChangeObserver == null) break;
                        event.getExecutionContext().getBeanContext().removeObserver((BeanContextLifecycleObserver)this.arrayToListChangeObserver);
                        break;
                    }
                    finally {
                        event.getExecutionContext().getBeanContext().removeObserver((BeanContextLifecycleObserver)this);
                    }
                }
            }
        }
    }

    class ArrayToListChangeObserver
    implements BeanContextLifecycleObserver {
        ArrayToListChangeObserver() {
        }

        public void onBeanLifecycleEvent(BeanContextLifecycleEvent event) {
            if (event.getBeanId() == BeanCreateLifecycleObserver.this.watchedBean && event.getLifecycle() == BeanLifecycle.CHANGE) {
                ExecutionContext executionContext = event.getExecutionContext();
                BeanCreateLifecycleObserver.this.populator.populateAndSetPropertyValue(event.getBean(), executionContext);
                executionContext.getBeanContext().removeObserver((BeanContextLifecycleObserver)this);
                BeanCreateLifecycleObserver.this.arrayToListChangeObserver = null;
            }
        }
    }
}

