/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.persistence.parameter;

import org.dhatim.container.ApplicationContext;
import org.dhatim.container.ExecutionContext;
import org.dhatim.persistence.ParameterListType;
import org.dhatim.persistence.parameter.NamedParameter;
import org.dhatim.persistence.parameter.NamedParameterContainer;
import org.dhatim.persistence.parameter.NamedParameterIndex;
import org.dhatim.persistence.parameter.Parameter;
import org.dhatim.persistence.parameter.ParameterContainer;
import org.dhatim.persistence.parameter.ParameterIndex;
import org.dhatim.persistence.parameter.PositionalParameterContainer;
import org.dhatim.persistence.parameter.PositionalParameterIndex;

public class ParameterManager {
    private static final String PARAMETER_CONTAINER_CONTEXT_KEY = ParameterContainer.class.getName() + "#CONTEXT_KEY";
    private static final String PARAMETER_INDEX_CONTEXT_KEY = ParameterIndex.class.getName() + "#CONTEXT_KEY";

    public static String getParameterIndexName(int id) {
        return PARAMETER_INDEX_CONTEXT_KEY + "#" + id;
    }

    public static String getParameterContainerName(int id) {
        return PARAMETER_CONTAINER_CONTEXT_KEY + "#" + id;
    }

    public static ParameterIndex<?, ?> initializeParameterIndex(int id, ParameterListType type, ApplicationContext applicationContext) {
        ParameterIndex index;
        switch (type) {
            case NAMED: {
                index = new NamedParameterIndex();
                break;
            }
            case POSITIONAL: {
                index = new PositionalParameterIndex();
                break;
            }
            default: {
                throw new IllegalStateException("Unknown ParameterListType '" + (Object)((Object)type) + "'.");
            }
        }
        applicationContext.setAttribute((Object)ParameterManager.getParameterIndexName(id), (Object)index);
        return index;
    }

    public static ParameterIndex<?, ? extends Parameter<?>> getParameterIndex(int id, ApplicationContext applicationContext) {
        return (ParameterIndex)applicationContext.getAttribute((Object)ParameterManager.getParameterIndexName(id));
    }

    public static void initializeParameterContainer(int id, ParameterListType type, ExecutionContext executionContext) {
        ParameterContainer<NamedParameter> container = ParameterManager.getParameterContainer(id, executionContext);
        if (container == null) {
            switch (type) {
                case NAMED: {
                    container = new NamedParameterContainer((NamedParameterIndex)ParameterManager.getParameterIndex(id, executionContext.getContext()));
                    break;
                }
                case POSITIONAL: {
                    container = new PositionalParameterContainer((PositionalParameterIndex)ParameterManager.getParameterIndex(id, executionContext.getContext()));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown ParameterListType '" + (Object)((Object)type) + "'.");
                }
            }
            executionContext.setAttribute((Object)ParameterManager.getParameterContainerName(id), (Object)container);
        } else {
            container.clear();
        }
    }

    public static ParameterContainer<Parameter<?>> getParameterContainer(int id, ExecutionContext executionContext) {
        return (ParameterContainer)executionContext.getAttribute((Object)ParameterManager.getParameterContainerName(id));
    }

    private ParameterManager() {
    }
}

