/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.routing.jms.message.creationstrategies;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.dhatim.SmooksException;
import org.dhatim.cdr.SmooksConfigurationException;
import org.dhatim.container.ExecutionContext;
import org.dhatim.routing.jms.message.creationstrategies.MessageCreationStrategy;

public class TextMessageCreationStrategy
implements MessageCreationStrategy {
    @Override
    public Message createJMSMessage(String beanId, ExecutionContext context, Session jmsSession) throws SmooksException {
        Object bean = context.getBeanContext().getBean(beanId);
        if (bean == null) {
            throw new SmooksException("Bean beandId '" + beanId + "' not available in the bean repository of this execution context.  Check the order in which your resources are being applied (in Smooks configuration).");
        }
        return this.createTextMessage(bean.toString(), jmsSession);
    }

    private TextMessage createTextMessage(String text, Session jmsSession) throws SmooksException {
        try {
            return jmsSession.createTextMessage(text);
        }
        catch (JMSException e) {
            String errorMsg = "JMSException while trying to create TextMessae";
            throw new SmooksConfigurationException("JMSException while trying to create TextMessae", (Throwable)e);
        }
    }
}

