/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.routing.basic;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.dhatim.SmooksException;
import org.dhatim.cdr.annotation.ConfigParam;
import org.dhatim.container.ExecutionContext;
import org.dhatim.delivery.Fragment;
import org.dhatim.delivery.VisitLifecycleCleanable;
import org.dhatim.delivery.dom.DOMVisitAfter;
import org.dhatim.delivery.dom.DOMVisitBefore;
import org.dhatim.delivery.ordering.Producer;
import org.dhatim.delivery.sax.DynamicSAXElementVisitorList;
import org.dhatim.delivery.sax.SAXElement;
import org.dhatim.delivery.sax.SAXElementVisitor;
import org.dhatim.delivery.sax.SAXElementWriterUtil;
import org.dhatim.delivery.sax.SAXText;
import org.dhatim.delivery.sax.SAXVisitAfter;
import org.dhatim.delivery.sax.SAXVisitBefore;
import org.dhatim.delivery.sax.SAXVisitor;
import org.dhatim.javabean.context.BeanContext;
import org.dhatim.javabean.lifecycle.BeanContextLifecycleEvent;
import org.dhatim.javabean.lifecycle.BeanLifecycle;
import org.dhatim.javabean.repository.BeanId;
import org.dhatim.namespace.NamespaceDeclarationStack;
import org.dhatim.util.CollectionsUtil;
import org.dhatim.xml.NamespaceMappings;
import org.dhatim.xml.XmlUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class FragmentSerializer
implements SAXVisitBefore,
SAXVisitAfter,
DOMVisitBefore,
DOMVisitAfter,
Producer,
VisitLifecycleCleanable {
    private String bindTo;
    private boolean omitXMLDeclaration;
    private boolean childContentOnly;
    private boolean retain;

    @ConfigParam
    public FragmentSerializer setBindTo(String bindTo) {
        this.bindTo = bindTo;
        return this;
    }

    @ConfigParam(defaultVal="false")
    public FragmentSerializer setOmitXMLDeclaration(boolean omitXMLDeclaration) {
        this.omitXMLDeclaration = omitXMLDeclaration;
        return this;
    }

    @ConfigParam(defaultVal="false")
    public FragmentSerializer setChildContentOnly(boolean childContentOnly) {
        this.childContentOnly = childContentOnly;
        return this;
    }

    @ConfigParam(defaultVal="false")
    public FragmentSerializer setRetain(boolean retain) {
        this.retain = retain;
        return this;
    }

    public Set<? extends Object> getProducts() {
        return CollectionsUtil.toSet((Object[])new String[]{this.bindTo});
    }

    public void visitBefore(SAXElement saxElement, ExecutionContext executionContext) throws SmooksException, IOException {
        HashMap<String, SAXSerializer> fragmentSerializers = (HashMap<String, SAXSerializer>)executionContext.getAttribute(FragmentSerializer.class);
        if (fragmentSerializers == null) {
            fragmentSerializers = new HashMap<String, SAXSerializer>();
            executionContext.setAttribute(FragmentSerializer.class, fragmentSerializers);
        }
        SAXSerializer serializer = new SAXSerializer();
        fragmentSerializers.put(this.bindTo, serializer);
        if (!this.omitXMLDeclaration) {
            serializer.fragmentWriter.write("<?xml version=\"1.0\"?>\n");
        }
        DynamicSAXElementVisitorList.addDynamicVisitor((SAXVisitor)serializer, (ExecutionContext)executionContext);
        this.notifyStartBean(new Fragment(saxElement), executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitAfter(SAXElement saxElement, ExecutionContext executionContext) throws SmooksException, IOException {
        Map fragmentSerializers = (Map)executionContext.getAttribute(FragmentSerializer.class);
        SAXSerializer serializer = (SAXSerializer)fragmentSerializers.get(this.bindTo);
        try {
            executionContext.getBeanContext().addBean(this.bindTo, (Object)serializer.fragmentWriter.toString().trim(), new Fragment(saxElement));
        }
        finally {
            DynamicSAXElementVisitorList.removeDynamicVisitor((SAXVisitor)serializer, (ExecutionContext)executionContext);
        }
    }

    public void visitBefore(Element element, ExecutionContext executionContext) throws SmooksException {
        this.notifyStartBean(new Fragment(element), executionContext);
    }

    public void visitAfter(Element element, ExecutionContext executionContext) throws SmooksException {
        String serializedFragment = this.childContentOnly ? XmlUtil.serialize((NodeList)element.getChildNodes(), (boolean)false) : XmlUtil.serialize((Node)element, (boolean)true);
        if (!this.omitXMLDeclaration) {
            serializedFragment = "<?xml version=\"1.0\"?>\n" + serializedFragment;
        }
        executionContext.getBeanContext().addBean(this.bindTo, (Object)serializedFragment, new Fragment(element));
    }

    private void notifyStartBean(Fragment source, ExecutionContext executionContext) {
        BeanContext beanContext = executionContext.getBeanContext();
        beanContext.notifyObservers(new BeanContextLifecycleEvent(executionContext, source, BeanLifecycle.START_FRAGMENT, beanContext.getBeanId(this.bindTo), (Object)""));
    }

    public void executeVisitLifecycleCleanup(Fragment fragment, ExecutionContext executionContext) {
        BeanContext beanContext = executionContext.getBeanContext();
        BeanId beanId = beanContext.getBeanId(this.bindTo);
        Object bean = beanContext.getBean(beanId);
        beanContext.notifyObservers(new BeanContextLifecycleEvent(executionContext, fragment, BeanLifecycle.END_FRAGMENT, beanId, bean));
        if (!this.retain) {
            executionContext.getBeanContext().removeBean(beanId, null);
        }
    }

    private class SAXSerializer
    implements SAXElementVisitor {
        int depth = 0;
        StringWriter fragmentWriter = new StringWriter();

        private SAXSerializer() {
        }

        public void visitBefore(SAXElement element, ExecutionContext executionContext) throws SmooksException, IOException {
            if (this.depth == 0) {
                this.addRootNamespaces(element, executionContext);
            }
            if (FragmentSerializer.this.childContentOnly) {
                if (this.depth > 0) {
                    SAXElementWriterUtil.writeStartElement((SAXElement)element, (Writer)this.fragmentWriter, (boolean)true);
                }
            } else {
                SAXElementWriterUtil.writeStartElement((SAXElement)element, (Writer)this.fragmentWriter, (boolean)true);
            }
            ++this.depth;
        }

        public void onChildElement(SAXElement element, SAXElement childElement, ExecutionContext executionContext) throws SmooksException, IOException {
        }

        public void onChildText(SAXElement element, SAXText text, ExecutionContext executionContext) throws SmooksException, IOException {
            SAXElementWriterUtil.writeText((SAXText)text, (Writer)this.fragmentWriter);
        }

        public void visitAfter(SAXElement element, ExecutionContext executionContext) throws SmooksException, IOException {
            --this.depth;
            if (FragmentSerializer.this.childContentOnly) {
                if (this.depth > 0) {
                    SAXElementWriterUtil.writeEndElement((SAXElement)element, (Writer)this.fragmentWriter);
                }
            } else {
                SAXElementWriterUtil.writeEndElement((SAXElement)element, (Writer)this.fragmentWriter);
            }
        }

        private void addRootNamespaces(SAXElement element, ExecutionContext executionContext) {
            NamespaceDeclarationStack nsDeclStack = NamespaceMappings.getNamespaceDeclarationStack((ExecutionContext)executionContext);
            Map rootNamespaces = nsDeclStack.getActiveNamespaces();
            if (!rootNamespaces.isEmpty()) {
                Set namespaces = rootNamespaces.entrySet();
                for (Map.Entry namespace : namespaces) {
                    this.addNamespace((String)namespace.getKey(), (String)namespace.getValue(), element);
                }
            }
        }

        private void addNamespace(String prefix, String namespaceURI, SAXElement element) {
            if (prefix == null || namespaceURI == null) {
                return;
            }
            if (prefix.equals("") && namespaceURI.equals("")) {
                return;
            }
            String prefixNS = element.getAttributeNS("http://www.w3.org/2000/xmlns/", prefix);
            if (prefixNS != null && prefixNS.length() != 0) {
                return;
            }
            Attributes attributes = element.getAttributes();
            AttributesImpl attributesCopy = new AttributesImpl();
            attributesCopy.setAttributes(attributes);
            if (prefix.length() > 0) {
                attributesCopy.addAttribute("http://www.w3.org/2000/xmlns/", prefix, "xmlns:" + prefix, null, namespaceURI);
            } else {
                attributesCopy.addAttribute("http://www.w3.org/2000/xmlns/", prefix, "xmlns", null, namespaceURI);
            }
            element.setAttributes((Attributes)attributesCopy);
        }
    }
}

