/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose;

import com.nimbusds.jose.UnprotectedHeader;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jose.util.JSONObjectUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
public class JWERecipient {
    private final Base64URL encryptedKey;
    private final UnprotectedHeader header;

    public JWERecipient(UnprotectedHeader header, Base64URL encryptedKey) {
        this.header = header;
        this.encryptedKey = encryptedKey;
    }

    public UnprotectedHeader getHeader() {
        return this.header;
    }

    public Base64URL getEncryptedKey() {
        return this.encryptedKey;
    }

    public Map<String, Object> toJSONObject() {
        HashMap<String, Object> json = new HashMap<String, Object>();
        if (this.getHeader() != null) {
            json.put("header", this.getHeader().toJSONObject());
        }
        if (this.getEncryptedKey() != null) {
            json.put("encrypted_key", this.getEncryptedKey().toString());
        }
        return json;
    }

    public static JWERecipient parse(Map<String, Object> jsonObject) throws ParseException {
        UnprotectedHeader header = UnprotectedHeader.parse(JSONObjectUtils.getJSONObject(jsonObject, "header"));
        Base64URL encryptedKey = JSONObjectUtils.getBase64URL(jsonObject, "encrypted_key");
        return new JWERecipient(header, encryptedKey);
    }

    public static List<JWERecipient> parse(Map<String, Object>[] jsonArray) throws ParseException {
        ArrayList<JWERecipient> recipients = new ArrayList<JWERecipient>();
        if (jsonArray != null) {
            for (Map<String, Object> json : jsonArray) {
                recipients.add(JWERecipient.parse(json));
            }
        }
        return recipients;
    }
}

