/*
 * Decompiled with CFR 0.152.
 */
package org.didcommx.didcomm;

import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.didcommx.didcomm.crypto.EncryptResult;
import org.didcommx.didcomm.crypto.JWSKt;
import org.didcommx.didcomm.crypto.key.Key;
import org.didcommx.didcomm.crypto.key.RecipientKeySelector;
import org.didcommx.didcomm.crypto.key.SenderKeySelector;
import org.didcommx.didcomm.diddoc.DIDCommService;
import org.didcommx.didcomm.diddoc.DIDDocResolver;
import org.didcommx.didcomm.message.Message;
import org.didcommx.didcomm.model.PackEncryptedParams;
import org.didcommx.didcomm.model.PackEncryptedResult;
import org.didcommx.didcomm.model.PackPlaintextParams;
import org.didcommx.didcomm.model.PackPlaintextResult;
import org.didcommx.didcomm.model.PackSignedParams;
import org.didcommx.didcomm.model.PackSignedResult;
import org.didcommx.didcomm.model.ServiceMetadata;
import org.didcommx.didcomm.model.UnpackParams;
import org.didcommx.didcomm.model.UnpackResult;
import org.didcommx.didcomm.operations.FromPriorKt;
import org.didcommx.didcomm.operations.PackEncryptKt;
import org.didcommx.didcomm.operations.UnpackKt;
import org.didcommx.didcomm.protocols.routing.RoutingKt;
import org.didcommx.didcomm.protocols.routing.WrapInForwardResult;
import org.didcommx.didcomm.secret.SecretResolver;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/didcommx/didcomm/DIDComm;", "", "didDocResolver", "Lorg/didcommx/didcomm/diddoc/DIDDocResolver;", "secretResolver", "Lorg/didcommx/didcomm/secret/SecretResolver;", "(Lorg/didcommx/didcomm/diddoc/DIDDocResolver;Lorg/didcommx/didcomm/secret/SecretResolver;)V", "packEncrypted", "Lorg/didcommx/didcomm/model/PackEncryptedResult;", "params", "Lorg/didcommx/didcomm/model/PackEncryptedParams;", "packPlaintext", "Lorg/didcommx/didcomm/model/PackPlaintextResult;", "Lorg/didcommx/didcomm/model/PackPlaintextParams;", "packSigned", "Lorg/didcommx/didcomm/model/PackSignedResult;", "Lorg/didcommx/didcomm/model/PackSignedParams;", "unpack", "Lorg/didcommx/didcomm/model/UnpackResult;", "Lorg/didcommx/didcomm/model/UnpackParams;", "didcomm"})
public final class DIDComm {
    @NotNull
    private final DIDDocResolver didDocResolver;
    @NotNull
    private final SecretResolver secretResolver;

    public DIDComm(@NotNull DIDDocResolver didDocResolver, @NotNull SecretResolver secretResolver) {
        Intrinsics.checkNotNullParameter((Object)didDocResolver, (String)"didDocResolver");
        Intrinsics.checkNotNullParameter((Object)secretResolver, (String)"secretResolver");
        this.didDocResolver = didDocResolver;
        this.secretResolver = secretResolver;
    }

    @NotNull
    public final PackPlaintextResult packPlaintext(@NotNull PackPlaintextParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        DIDDocResolver dIDDocResolver = params.getDidDocResolver();
        DIDDocResolver didDocResolver = dIDDocResolver == null ? this.didDocResolver : dIDDocResolver;
        SecretResolver secretResolver = params.getSecretResolver();
        SecretResolver secretResolver2 = secretResolver == null ? this.secretResolver : secretResolver;
        SenderKeySelector senderKeySelector = new SenderKeySelector(didDocResolver, secretResolver2);
        Pair<Message, String> pair = FromPriorKt.packFromPrior(params.getMessage(), params.getFromPriorIssuerKid(), senderKeySelector);
        Message message = (Message)pair.component1();
        String fromPriorIssuerKid = (String)pair.component2();
        return new PackPlaintextResult(message.toString(), fromPriorIssuerKid);
    }

    @NotNull
    public final PackSignedResult packSigned(@NotNull PackSignedParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        DIDDocResolver dIDDocResolver = params.getDidDocResolver();
        DIDDocResolver didDocResolver = dIDDocResolver == null ? this.didDocResolver : dIDDocResolver;
        SecretResolver secretResolver = params.getSecretResolver();
        SecretResolver secretResolver2 = secretResolver == null ? this.secretResolver : secretResolver;
        SenderKeySelector senderKeySelector = new SenderKeySelector(didDocResolver, secretResolver2);
        Pair<Message, String> pair = FromPriorKt.packFromPrior(params.getMessage(), params.getFromPriorIssuerKid(), senderKeySelector);
        Message message = (Message)pair.component1();
        String fromPriorIssuerKid = (String)pair.component2();
        Key signFromKey = senderKeySelector.findSigningKey(params.getSignFrom());
        String msg = JWSKt.sign(message.toString(), signFromKey);
        return new PackSignedResult(msg, signFromKey.getId(), fromPriorIssuerKid);
    }

    @NotNull
    public final PackEncryptedResult packEncrypted(@NotNull PackEncryptedParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        DIDDocResolver dIDDocResolver = params.getDidDocResolver();
        DIDDocResolver didDocResolver = dIDDocResolver == null ? this.didDocResolver : dIDDocResolver;
        SecretResolver secretResolver = params.getSecretResolver();
        SecretResolver secretResolver2 = secretResolver == null ? this.secretResolver : secretResolver;
        SenderKeySelector senderKeySelector = new SenderKeySelector(didDocResolver, secretResolver2);
        Pair<Message, String> pair = FromPriorKt.packFromPrior(params.getMessage(), params.getFromPriorIssuerKid(), senderKeySelector);
        Message message = (Message)pair.component1();
        String fromPriorIssuerKid = (String)pair.component2();
        Pair<String, String> pair2 = PackEncryptKt.signIfNeeded(message.toString(), params, senderKeySelector);
        String payload = (String)pair2.component1();
        String signFromKid = (String)pair2.component2();
        Pair<EncryptResult, List<Key>> pair3 = PackEncryptKt.encrypt(params, payload, senderKeySelector);
        EncryptResult encryptedResult = (EncryptResult)pair3.component1();
        List recipientKeys = (List)pair3.component2();
        EncryptResult encryptResult = PackEncryptKt.protectSenderIfNeeded(params, encryptedResult, recipientKeys);
        String packedMessage = encryptResult.component1();
        List didServicesChain = RoutingKt.resolveDIDCommServicesChain$default(didDocResolver, params.getTo(), params.getForwardServiceId(), false, 8, null);
        WrapInForwardResult wrapInForwardResult = PackEncryptKt.wrapInForwardIfNeeded(packedMessage, params, didServicesChain, didDocResolver, secretResolver2);
        if (wrapInForwardResult != null) {
            packedMessage = wrapInForwardResult.getMsgEncrypted().getPackedMessage();
        }
        ServiceMetadata serviceMetadata = didServicesChain.isEmpty() ? null : new ServiceMetadata(((DIDCommService)CollectionsKt.last((List)didServicesChain)).getId(), ((DIDCommService)CollectionsKt.first((List)didServicesChain)).getServiceEndpoint());
        return new PackEncryptedResult(packedMessage, encryptedResult.getToKids(), encryptedResult.getFromKid(), signFromKid, fromPriorIssuerKid, serviceMetadata);
    }

    @NotNull
    public final UnpackResult unpack(@NotNull UnpackParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        DIDDocResolver dIDDocResolver = params.getDidDocResolver();
        DIDDocResolver didDocResolver = dIDDocResolver == null ? this.didDocResolver : dIDDocResolver;
        SecretResolver secretResolver = params.getSecretResolver();
        SecretResolver secretResolver2 = secretResolver == null ? this.secretResolver : secretResolver;
        RecipientKeySelector recipientKeySelector = new RecipientKeySelector(didDocResolver, secretResolver2);
        return UnpackKt.unpack(params, recipientKeySelector);
    }
}

