/*
 * Decompiled with CFR 0.152.
 */
package org.didcommx.didcomm.crypto;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEDecrypterMulti;
import com.nimbusds.jose.JWEEncrypterMulti;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.JWEObjectJSON;
import com.nimbusds.jose.JWEProvider;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.UnprotectedHeader;
import com.nimbusds.jose.crypto.ECDH1PUDecrypterMulti;
import com.nimbusds.jose.crypto.ECDH1PUEncrypterMulti;
import com.nimbusds.jose.crypto.ECDH1PUX25519DecrypterMulti;
import com.nimbusds.jose.crypto.ECDH1PUX25519EncrypterMulti;
import com.nimbusds.jose.crypto.ECDHDecrypterMulti;
import com.nimbusds.jose.crypto.ECDHEncrypterMulti;
import com.nimbusds.jose.crypto.X25519DecrypterMulti;
import com.nimbusds.jose.crypto.X25519EncrypterMulti;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.OctetKeyPair;
import com.nimbusds.jose.util.Base64URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.didcommx.didcomm.common.AnonCryptAlg;
import org.didcommx.didcomm.common.AuthCryptAlg;
import org.didcommx.didcomm.common.CryptAlg;
import org.didcommx.didcomm.common.Typ;
import org.didcommx.didcomm.crypto.DecryptResult;
import org.didcommx.didcomm.crypto.EncryptResult;
import org.didcommx.didcomm.crypto.key.Key;
import org.didcommx.didcomm.exceptions.DIDCommException;
import org.didcommx.didcomm.exceptions.MalformedMessageException;
import org.didcommx.didcomm.exceptions.UnsupportedAlgorithm;
import org.didcommx.didcomm.exceptions.UnsupportedCurveException;
import org.didcommx.didcomm.exceptions.UnsupportedJWKException;
import org.didcommx.didcomm.utils.DIDUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a$\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u001a\u001e\u0010\t\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\nH\u0002\u001a&\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00072\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002\u001a$\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\n\u001a,\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\b2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u001a&\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\b2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\nH\u0002\u001a.\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00072\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\b2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002\u001a,\u0010\u0016\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\b2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\n\u001a\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u001b"}, d2={"anonDecrypt", "Lorg/didcommx/didcomm/crypto/DecryptResult;", "jwe", "Lcom/nimbusds/jose/JWEObjectJSON;", "decryptByAllKeys", "", "to", "Lkotlin/sequences/Sequence;", "Lorg/didcommx/didcomm/crypto/key/Key;", "anonDecryptForAllKeys", "", "anonDecryptForOneKey", "anonEncrypt", "Lorg/didcommx/didcomm/crypto/EncryptResult;", "payload", "", "anon", "Lorg/didcommx/didcomm/common/AnonCryptAlg;", "authDecrypt", "from", "authDecryptForAllKeys", "authDecryptForOneKey", "authEncrypt", "auth", "Lorg/didcommx/didcomm/common/AuthCryptAlg;", "getCryptoAlg", "Lorg/didcommx/didcomm/common/CryptAlg;", "didcomm"})
public final class JWEKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final EncryptResult authEncrypt(@NotNull String payload, @NotNull AuthCryptAlg auth, @NotNull Key from, @NotNull List<? extends Key> to) {
        Object object;
        List $this$mapTo$iv$iv;
        Object object2;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)auth, (String)"auth");
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter(to, (String)"to");
        String skid = from.getId();
        Iterable $this$map$iv = to;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        int $i$f$mapTo = 0;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            Key key = (Key)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            object2 = it.getId();
            collection.add(object2);
        }
        List kids = CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
        Base64URL apu = Base64URL.encode(from.getId());
        Base64URL apv = DIDUtilsKt.calculateAPV(kids);
        destination$iv$iv = auth;
        $i$f$mapTo = WhenMappings.$EnumSwitchMapping$0[((Enum)destination$iv$iv).ordinal()];
        if ($i$f$mapTo != 1) {
            throw new NoWhenBranchMatchedException();
        }
        iterable = new Pair((Object)JWEAlgorithm.ECDH_1PU_A256KW, (Object)EncryptionMethod.A256CBC_HS512);
        JWEAlgorithm alg = (JWEAlgorithm)iterable.component1();
        EncryptionMethod enc = (EncryptionMethod)iterable.component2();
        JWEHeader jweHeader = new JWEHeader.Builder(alg, enc).type(new JOSEObjectType(Typ.Encrypted.getTyp())).agreementPartyVInfo(apv).agreementPartyUInfo(apu).senderKeyID(skid).build();
        JWK sender2 = from.getJwk();
        Iterable $this$map$iv2 = to;
        boolean $i$f$map2 = false;
        Iterable iterable2 = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Key key = (Key)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            object2 = com.nimbusds.jose.util.Pair.of(new UnprotectedHeader.Builder().keyID(it.getId()).build(), it.getJwk());
            collection.add(object2);
        }
        List recipients = (List)destination$iv$iv2;
        try {
            JWEProvider jWEProvider;
            List list;
            com.nimbusds.jose.util.Pair pair;
            com.nimbusds.jose.util.Pair pair2;
            boolean $i$f$asKey;
            com.nimbusds.jose.util.Pair $this$asKey$iv$iv;
            com.nimbusds.jose.util.Pair it$iv;
            boolean bl;
            Collection collection2;
            Iterable $this$mapTo$iv$iv$iv;
            boolean $i$f$mapTo3;
            Collection destination$iv$iv$iv;
            boolean $i$f$map3;
            Iterable $this$map$iv$iv;
            Object $this$asKeys$iv;
            boolean $i$f$asKeys;
            JWK jWK;
            object = sender2;
            if (object instanceof ECKey) {
                Object item$iv$iv;
                $this$mapTo$iv$iv = recipients;
                jWK = (ECKey)sender2;
                $i$f$asKeys = false;
                $this$map$iv$iv = (Iterable)$this$asKeys$iv;
                $i$f$map3 = false;
                item$iv$iv = $this$map$iv$iv;
                destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv, (int)10));
                $i$f$mapTo3 = false;
                for (Object item$iv$iv$iv : $this$mapTo$iv$iv$iv) {
                    com.nimbusds.jose.util.Pair pair3 = (com.nimbusds.jose.util.Pair)item$iv$iv$iv;
                    collection2 = destination$iv$iv$iv;
                    bl = false;
                    $this$asKey$iv$iv = it$iv;
                    $i$f$asKey = false;
                    Object r = $this$asKey$iv$iv.getRight();
                    if (!(r != null ? r instanceof ECKey : true)) {
                        throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Can not cast JWK to ", (Object)ECKey.class.getName()));
                    }
                    pair2 = com.nimbusds.jose.util.Pair.of($this$asKey$iv$iv.getLeft(), (ECKey)$this$asKey$iv$iv.getRight());
                    Intrinsics.checkNotNullExpressionValue(pair2, (String)"of(left, right as Key)");
                    pair = pair2;
                    collection2.add(pair);
                }
                List list2 = list = (List)destination$iv$iv$iv;
                JWK jWK2 = jWK;
                jWEProvider = new ECDH1PUEncrypterMulti((ECKey)jWK2, list2);
            } else if (object instanceof OctetKeyPair) {
                $this$asKeys$iv = recipients;
                jWK = (OctetKeyPair)sender2;
                $i$f$asKeys = false;
                $this$map$iv$iv = (Iterable)$this$asKeys$iv;
                $i$f$map3 = false;
                $this$mapTo$iv$iv$iv = $this$map$iv$iv;
                destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv, (int)10));
                $i$f$mapTo3 = false;
                for (Object item$iv$iv$iv : $this$mapTo$iv$iv$iv) {
                    it$iv = (com.nimbusds.jose.util.Pair)item$iv$iv$iv;
                    collection2 = destination$iv$iv$iv;
                    bl = false;
                    $this$asKey$iv$iv = it$iv;
                    $i$f$asKey = false;
                    Object r = $this$asKey$iv$iv.getRight();
                    if (!(r != null ? r instanceof OctetKeyPair : true)) {
                        throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Can not cast JWK to ", (Object)OctetKeyPair.class.getName()));
                    }
                    pair2 = com.nimbusds.jose.util.Pair.of($this$asKey$iv$iv.getLeft(), (OctetKeyPair)$this$asKey$iv$iv.getRight());
                    Intrinsics.checkNotNullExpressionValue(pair2, (String)"of(left, right as Key)");
                    pair = pair2;
                    collection2.add(pair);
                }
                List list3 = list = (List)destination$iv$iv$iv;
                JWK jWK3 = jWK;
                jWEProvider = new ECDH1PUX25519EncrypterMulti((OctetKeyPair)jWK3, list3);
            } else {
                $this$asKeys$iv = sender2.getClass().getName();
                Intrinsics.checkNotNullExpressionValue((Object)$this$asKeys$iv, (String)"sender.javaClass.name");
                throw new UnsupportedJWKException((String)$this$asKeys$iv);
            }
            object = jWEProvider;
        }
        catch (JOSEException e) {
            throw new UnsupportedCurveException("The key subtype is not supported");
        }
        Object encryptor = object;
        object = new JWEObjectJSON(jweHeader, new Payload(Base64URL.encode(payload)));
        boolean bl = false;
        boolean bl2 = false;
        Object $this$authEncrypt_u24lambda_u2d2 = object;
        boolean bl3 = false;
        try {
            ((JWEObjectJSON)$this$authEncrypt_u24lambda_u2d2).encrypt((JWEEncrypterMulti)encryptor);
        }
        catch (JOSEException e) {
            throw new DIDCommException("JWE cannot be encrypted", e);
        }
        bl = false;
        bl2 = false;
        Object $this$authEncrypt_u24lambda_u2d3 = object;
        boolean bl4 = false;
        String string = ((JWEObjectJSON)$this$authEncrypt_u24lambda_u2d3).serialize();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"serialize()");
        return new EncryptResult(string, kids, from.getId());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final EncryptResult anonEncrypt(@NotNull String payload, @NotNull AnonCryptAlg anon, @NotNull List<? extends Key> to) {
        Object object;
        void $this$mapTo$iv$iv;
        Pair pair;
        Object object2;
        Collection collection;
        AnonCryptAlg $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)anon, (String)"anon");
        Intrinsics.checkNotNullParameter(to, (String)"to");
        Iterable $this$map$iv = to;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv22 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv2.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv = iterator.next();
            Key key = (Key)item$iv$iv;
            collection = destination$iv$iv22;
            boolean bl = false;
            object2 = it.getId();
            collection.add(object2);
        }
        List kids = CollectionsKt.sorted((Iterable)((List)destination$iv$iv22));
        Base64URL apv = DIDUtilsKt.calculateAPV(kids);
        $this$mapTo$iv$iv2 = anon;
        int destination$iv$iv22 = WhenMappings.$EnumSwitchMapping$1[$this$mapTo$iv$iv2.ordinal()];
        switch (destination$iv$iv22) {
            case 1: {
                pair = new Pair((Object)JWEAlgorithm.ECDH_ES_A256KW, (Object)EncryptionMethod.A256CBC_HS512);
                break;
            }
            case 2: {
                pair = new Pair((Object)JWEAlgorithm.ECDH_ES_A256KW, (Object)EncryptionMethod.XC20P);
                break;
            }
            case 3: {
                pair = new Pair((Object)JWEAlgorithm.ECDH_ES_A256KW, (Object)EncryptionMethod.A256GCM);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Pair pair2 = pair;
        JWEAlgorithm alg = (JWEAlgorithm)pair2.component1();
        EncryptionMethod enc = (EncryptionMethod)pair2.component2();
        JWEHeader jweHeader = new JWEHeader.Builder(alg, enc).agreementPartyVInfo(apv).build();
        Iterable $this$map$iv2 = to;
        boolean $i$f$map2 = false;
        Iterable bl = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Key key = (Key)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            object2 = com.nimbusds.jose.util.Pair.of(new UnprotectedHeader.Builder().keyID(it.getId()).build(), it.getJwk());
            collection.add(object2);
        }
        List recipients = (List)destination$iv$iv;
        try {
            JWEProvider jWEProvider;
            List list;
            com.nimbusds.jose.util.Pair pair3;
            com.nimbusds.jose.util.Pair pair4;
            boolean $i$f$asKey;
            com.nimbusds.jose.util.Pair $this$asKey$iv$iv;
            com.nimbusds.jose.util.Pair it$iv;
            boolean bl3;
            Collection collection2;
            Iterable $this$mapTo$iv$iv$iv;
            boolean $i$f$mapTo3;
            Collection destination$iv$iv$iv;
            boolean $i$f$map3;
            Iterable $this$map$iv$iv;
            boolean $i$f$asKeys;
            Object $this$asKeys$iv;
            JWK recipient = (JWK)((com.nimbusds.jose.util.Pair)CollectionsKt.first((List)recipients)).getRight();
            if (recipient instanceof ECKey) {
                Object item$iv$iv;
                $this$asKeys$iv = recipients;
                $i$f$asKeys = false;
                $this$map$iv$iv = (Iterable)$this$asKeys$iv;
                $i$f$map3 = false;
                item$iv$iv = $this$map$iv$iv;
                destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv, (int)10));
                $i$f$mapTo3 = false;
                for (Object item$iv$iv$iv : $this$mapTo$iv$iv$iv) {
                    com.nimbusds.jose.util.Pair pair5 = (com.nimbusds.jose.util.Pair)item$iv$iv$iv;
                    collection2 = destination$iv$iv$iv;
                    bl3 = false;
                    $this$asKey$iv$iv = it$iv;
                    $i$f$asKey = false;
                    Object r = $this$asKey$iv$iv.getRight();
                    if (!(r != null ? r instanceof ECKey : true)) {
                        throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Can not cast JWK to ", (Object)ECKey.class.getName()));
                    }
                    pair4 = com.nimbusds.jose.util.Pair.of($this$asKey$iv$iv.getLeft(), (ECKey)$this$asKey$iv$iv.getRight());
                    Intrinsics.checkNotNullExpressionValue(pair4, (String)"of(left, right as Key)");
                    pair3 = pair4;
                    collection2.add(pair3);
                }
                List list2 = list = (List)destination$iv$iv$iv;
                jWEProvider = new ECDHEncrypterMulti(list2);
            } else if (recipient instanceof OctetKeyPair) {
                $this$asKeys$iv = recipients;
                $i$f$asKeys = false;
                $this$map$iv$iv = (Iterable)$this$asKeys$iv;
                $i$f$map3 = false;
                $this$mapTo$iv$iv$iv = $this$map$iv$iv;
                destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv, (int)10));
                $i$f$mapTo3 = false;
                for (Object item$iv$iv$iv : $this$mapTo$iv$iv$iv) {
                    it$iv = (com.nimbusds.jose.util.Pair)item$iv$iv$iv;
                    collection2 = destination$iv$iv$iv;
                    bl3 = false;
                    $this$asKey$iv$iv = it$iv;
                    $i$f$asKey = false;
                    Object r = $this$asKey$iv$iv.getRight();
                    if (!(r != null ? r instanceof OctetKeyPair : true)) {
                        throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Can not cast JWK to ", (Object)OctetKeyPair.class.getName()));
                    }
                    pair4 = com.nimbusds.jose.util.Pair.of($this$asKey$iv$iv.getLeft(), (OctetKeyPair)$this$asKey$iv$iv.getRight());
                    Intrinsics.checkNotNullExpressionValue(pair4, (String)"of(left, right as Key)");
                    pair3 = pair4;
                    collection2.add(pair3);
                }
                List list3 = list = (List)destination$iv$iv$iv;
                jWEProvider = new X25519EncrypterMulti(list3);
            } else {
                $this$asKeys$iv = recipient.getClass().getName();
                Intrinsics.checkNotNullExpressionValue((Object)$this$asKeys$iv, (String)"recipient.javaClass.name");
                throw new UnsupportedJWKException((String)$this$asKeys$iv);
            }
            object = jWEProvider;
        }
        catch (JOSEException e) {
            throw new UnsupportedCurveException("The key subtype is not supported");
        }
        JWEProvider encryptor = object;
        object = new JWEObjectJSON(jweHeader, new Payload(Base64URL.encode(payload)));
        boolean bl4 = false;
        boolean bl5 = false;
        Object $this$anonEncrypt_u24lambda_u2d6 = object;
        boolean bl6 = false;
        try {
            ((JWEObjectJSON)$this$anonEncrypt_u24lambda_u2d6).encrypt((JWEEncrypterMulti)encryptor);
        }
        catch (JOSEException e) {
            throw new DIDCommException("JWE cannot be encrypted", e);
        }
        bl4 = false;
        bl5 = false;
        Object $this$anonEncrypt_u24lambda_u2d7 = object;
        boolean bl7 = false;
        String string = ((JWEObjectJSON)$this$anonEncrypt_u24lambda_u2d7).serialize();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"serialize()");
        return new EncryptResult(string, kids, null, 4, null);
    }

    @NotNull
    public static final DecryptResult authDecrypt(@NotNull JWEObjectJSON jwe, boolean decryptByAllKeys, @NotNull Key from, @NotNull Sequence<? extends Key> to) {
        DecryptResult decryptResult;
        Intrinsics.checkNotNullParameter((Object)jwe, (String)"jwe");
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter(to, (String)"to");
        if (decryptByAllKeys) {
            decryptResult = JWEKt.authDecryptForAllKeys(jwe, from, SequencesKt.toList(to));
        } else {
            DecryptResult decryptResult2 = (DecryptResult)SequencesKt.firstOrNull((Sequence)SequencesKt.filterNotNull(JWEKt.authDecryptForOneKey(jwe, from, to)));
            if (decryptResult2 == null) {
                throw new MalformedMessageException("Decrypt failed", null, 2, null);
            }
            decryptResult = decryptResult2;
        }
        return decryptResult;
    }

    @NotNull
    public static final DecryptResult anonDecrypt(@NotNull JWEObjectJSON jwe, boolean decryptByAllKeys, @NotNull Sequence<? extends Key> to) {
        DecryptResult decryptResult;
        Intrinsics.checkNotNullParameter((Object)jwe, (String)"jwe");
        Intrinsics.checkNotNullParameter(to, (String)"to");
        if (decryptByAllKeys) {
            decryptResult = JWEKt.anonDecryptForAllKeys(jwe, SequencesKt.toList(to));
        } else {
            DecryptResult decryptResult2 = (DecryptResult)SequencesKt.firstOrNull((Sequence)SequencesKt.filterNotNull(JWEKt.anonDecryptForOneKey(jwe, to)));
            if (decryptResult2 == null) {
                throw new MalformedMessageException("Decrypt failed", null, 2, null);
            }
            decryptResult = decryptResult2;
        }
        return decryptResult;
    }

    private static final Sequence<DecryptResult> authDecryptForOneKey(JWEObjectJSON jwe, Key from, Sequence<? extends Key> to) {
        return SequencesKt.map(to, (Function1)((Function1)new Function1<Key, DecryptResult>(jwe, from){
            final /* synthetic */ JWEObjectJSON $jwe;
            final /* synthetic */ Key $from;
            {
                this.$jwe = $jwe;
                this.$from = $from;
                super(1);
            }

            @Nullable
            public final DecryptResult invoke(@NotNull Key it) {
                DecryptResult decryptResult;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                try {
                    decryptResult = JWEKt.access$authDecryptForAllKeys(this.$jwe, this.$from, CollectionsKt.listOf((Object)it));
                }
                catch (MalformedMessageException e) {
                    decryptResult = null;
                }
                return decryptResult;
            }
        }));
    }

    private static final Sequence<DecryptResult> anonDecryptForOneKey(JWEObjectJSON jwe, Sequence<? extends Key> to) {
        return SequencesKt.map(to, (Function1)((Function1)new Function1<Key, DecryptResult>(jwe){
            final /* synthetic */ JWEObjectJSON $jwe;
            {
                this.$jwe = $jwe;
                super(1);
            }

            @Nullable
            public final DecryptResult invoke(@NotNull Key it) {
                DecryptResult decryptResult;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                try {
                    decryptResult = JWEKt.access$anonDecryptForAllKeys(this.$jwe, CollectionsKt.listOf((Object)it));
                }
                catch (MalformedMessageException e) {
                    decryptResult = null;
                }
                return decryptResult;
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private static final DecryptResult authDecryptForAllKeys(JWEObjectJSON jwe, Key from, List<? extends Key> to) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object object;
        Collection<String> collection;
        com.nimbusds.jose.util.Pair pair;
        com.nimbusds.jose.util.Pair pair2;
        boolean $i$f$asKey;
        com.nimbusds.jose.util.Pair $this$asKey$iv$iv;
        com.nimbusds.jose.util.Pair it$iv;
        boolean bl;
        Collection collection2;
        Iterable $this$mapTo$iv$iv$iv;
        boolean $i$f$mapTo;
        Collection destination$iv$iv$iv;
        boolean $i$f$map;
        Iterable $this$map$iv$iv2;
        Object $this$asKeys$iv;
        boolean $i$f$asKeys;
        Object object2;
        List $this$mapTo$iv$iv2;
        JWK sender2 = from.getJwk();
        Iterable $this$map$iv2 = to;
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            Key key = (Key)item$iv$iv;
            Collection collection3 = destination$iv$iv;
            boolean bl2 = false;
            com.nimbusds.jose.util.Pair<UnprotectedHeader, JWK> pair3 = com.nimbusds.jose.util.Pair.of(new UnprotectedHeader.Builder().keyID(it.getId()).build(), it.getJwk());
            collection3.add(pair3);
        }
        List recipients = (List)destination$iv$iv;
        JWK $i$f$map22 = sender2;
        if ($i$f$map22 instanceof ECKey) {
            try {
                Object item$iv$iv;
                $this$mapTo$iv$iv2 = recipients;
                object2 = (ECKey)sender2;
                $i$f$asKeys = false;
                $this$map$iv$iv2 = (Iterable)$this$asKeys$iv;
                $i$f$map = false;
                item$iv$iv = $this$map$iv$iv2;
                destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv2, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv$iv : $this$mapTo$iv$iv$iv) {
                    com.nimbusds.jose.util.Pair pair4 = (com.nimbusds.jose.util.Pair)item$iv$iv$iv;
                    collection2 = destination$iv$iv$iv;
                    bl = false;
                    $this$asKey$iv$iv = it$iv;
                    $i$f$asKey = false;
                    Object r = $this$asKey$iv$iv.getRight();
                    if (!(r != null ? r instanceof ECKey : true)) {
                        throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Can not cast JWK to ", (Object)ECKey.class.getName()));
                    }
                    pair2 = com.nimbusds.jose.util.Pair.of($this$asKey$iv$iv.getLeft(), (ECKey)$this$asKey$iv$iv.getRight());
                    Intrinsics.checkNotNullExpressionValue(pair2, (String)"of(left, right as Key)");
                    pair = pair2;
                    collection2.add(pair);
                }
                collection = (List)destination$iv$iv$iv;
                List list = collection;
                JWK jWK = object2;
                $this$asKeys$iv = new ECDH1PUDecrypterMulti((ECKey)jWK, list);
            }
            catch (JOSEException e) {
                String $this$map$iv$iv2 = ((ECKey)sender2).getCurve().getName();
                Intrinsics.checkNotNullExpressionValue((Object)$this$map$iv$iv2, (String)"sender.curve.name");
                throw new UnsupportedCurveException($this$map$iv$iv2);
            }
            object = $this$asKeys$iv;
        } else if ($i$f$map22 instanceof OctetKeyPair) {
            try {
                $this$asKeys$iv = recipients;
                object2 = (OctetKeyPair)sender2;
                $i$f$asKeys = false;
                $this$map$iv$iv2 = (Iterable)$this$asKeys$iv;
                $i$f$map = false;
                $this$mapTo$iv$iv$iv = $this$map$iv$iv2;
                destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv2, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv$iv : $this$mapTo$iv$iv$iv) {
                    it$iv = (com.nimbusds.jose.util.Pair)item$iv$iv$iv;
                    collection2 = destination$iv$iv$iv;
                    bl = false;
                    $this$asKey$iv$iv = it$iv;
                    $i$f$asKey = false;
                    Object r = $this$asKey$iv$iv.getRight();
                    if (!(r != null ? r instanceof OctetKeyPair : true)) {
                        throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Can not cast JWK to ", (Object)OctetKeyPair.class.getName()));
                    }
                    pair2 = com.nimbusds.jose.util.Pair.of($this$asKey$iv$iv.getLeft(), (OctetKeyPair)$this$asKey$iv$iv.getRight());
                    Intrinsics.checkNotNullExpressionValue(pair2, (String)"of(left, right as Key)");
                    pair = pair2;
                    collection2.add(pair);
                }
                collection = (List)destination$iv$iv$iv;
                List list = collection;
                JWK jWK = object2;
                $this$asKeys$iv = new ECDH1PUX25519DecrypterMulti((OctetKeyPair)jWK, list);
            }
            catch (JOSEException e) {
                String $this$map$iv$iv3 = ((OctetKeyPair)sender2).getCurve().getName();
                Intrinsics.checkNotNullExpressionValue((Object)$this$map$iv$iv3, (String)"sender.curve.name");
                throw new UnsupportedCurveException($this$map$iv$iv3);
            }
            object = $this$asKeys$iv;
        } else {
            $this$asKeys$iv = sender2.getClass().getName();
            Intrinsics.checkNotNullExpressionValue((Object)$this$asKeys$iv, (String)"sender.javaClass.name");
            throw new UnsupportedJWKException((String)$this$asKeys$iv);
        }
        Object decrypter = object;
        try {
            jwe.decrypt((JWEDecrypterMulti)decrypter);
        }
        catch (Throwable t) {
            throw new MalformedMessageException("Decrypt is failed", t);
        }
        Object t = jwe.getPayload().toJSONObject();
        Intrinsics.checkNotNullExpressionValue(t, (String)"jwe.payload.toJSONObject()");
        Map<String, Object> map = t;
        t = to;
        object2 = map;
        boolean $i$f$map3 = false;
        void e = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Key $i$f$mapTo4 = (Key)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl3 = false;
            String string = it.getId();
            collection.add(string);
        }
        collection = (List)destination$iv$iv2;
        String string = from.getId();
        List list = collection;
        Object object3 = object2;
        return new DecryptResult((Map<String, ? extends Object>)object3, list, string);
    }

    /*
     * WARNING - void declaration
     */
    private static final DecryptResult anonDecryptForAllKeys(JWEObjectJSON jwe, List<? extends Key> to) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object object;
        Object object2;
        com.nimbusds.jose.util.Pair pair;
        com.nimbusds.jose.util.Pair pair2;
        boolean $i$f$asKey;
        com.nimbusds.jose.util.Pair $this$asKey$iv$iv;
        com.nimbusds.jose.util.Pair it$iv;
        boolean bl;
        Collection collection2;
        Iterable $this$mapTo$iv$iv$iv;
        boolean $i$f$mapTo;
        Collection destination$iv$iv$iv;
        boolean $i$f$map;
        Iterable $this$map$iv$iv2;
        boolean $i$f$asKeys;
        Object $this$asKeys$iv;
        void $this$mapTo$iv$iv2;
        Iterable $this$map$iv2 = to;
        boolean $i$f$map2 = false;
        Iterable iterable = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            Key key = (Key)item$iv$iv;
            Collection collection3 = destination$iv$iv;
            boolean bl2 = false;
            com.nimbusds.jose.util.Pair<UnprotectedHeader, JWK> pair3 = com.nimbusds.jose.util.Pair.of(new UnprotectedHeader.Builder().keyID(it.getId()).build(), it.getJwk());
            collection3.add(pair3);
        }
        List recipients = (List)destination$iv$iv;
        JWK recipient = (JWK)((com.nimbusds.jose.util.Pair)CollectionsKt.first((List)recipients)).getRight();
        if (recipient instanceof ECKey) {
            try {
                Object item$iv$iv;
                $this$asKeys$iv = recipients;
                $i$f$asKeys = false;
                $this$map$iv$iv2 = (Iterable)$this$asKeys$iv;
                $i$f$map = false;
                item$iv$iv = $this$map$iv$iv2;
                destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv2, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv$iv : $this$mapTo$iv$iv$iv) {
                    com.nimbusds.jose.util.Pair pair4 = (com.nimbusds.jose.util.Pair)item$iv$iv$iv;
                    collection2 = destination$iv$iv$iv;
                    bl = false;
                    $this$asKey$iv$iv = it$iv;
                    $i$f$asKey = false;
                    Object r = $this$asKey$iv$iv.getRight();
                    if (!(r != null ? r instanceof ECKey : true)) {
                        throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Can not cast JWK to ", (Object)ECKey.class.getName()));
                    }
                    pair2 = com.nimbusds.jose.util.Pair.of($this$asKey$iv$iv.getLeft(), (ECKey)$this$asKey$iv$iv.getRight());
                    Intrinsics.checkNotNullExpressionValue(pair2, (String)"of(left, right as Key)");
                    pair = pair2;
                    collection2.add(pair);
                }
                object2 = (List)destination$iv$iv$iv;
                List list = object2;
                $this$asKeys$iv = new ECDHDecrypterMulti(list);
            }
            catch (JOSEException e) {
                String $this$map$iv$iv2 = ((ECKey)recipient).getCurve().getName();
                Intrinsics.checkNotNullExpressionValue((Object)$this$map$iv$iv2, (String)"recipient.curve.name");
                throw new UnsupportedCurveException($this$map$iv$iv2);
            }
            object = $this$asKeys$iv;
        } else if (recipient instanceof OctetKeyPair) {
            try {
                $this$asKeys$iv = recipients;
                $i$f$asKeys = false;
                $this$map$iv$iv2 = (Iterable)$this$asKeys$iv;
                $i$f$map = false;
                $this$mapTo$iv$iv$iv = $this$map$iv$iv2;
                destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv2, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv$iv : $this$mapTo$iv$iv$iv) {
                    it$iv = (com.nimbusds.jose.util.Pair)item$iv$iv$iv;
                    collection2 = destination$iv$iv$iv;
                    bl = false;
                    $this$asKey$iv$iv = it$iv;
                    $i$f$asKey = false;
                    Object r = $this$asKey$iv$iv.getRight();
                    if (!(r != null ? r instanceof OctetKeyPair : true)) {
                        throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Can not cast JWK to ", (Object)OctetKeyPair.class.getName()));
                    }
                    pair2 = com.nimbusds.jose.util.Pair.of($this$asKey$iv$iv.getLeft(), (OctetKeyPair)$this$asKey$iv$iv.getRight());
                    Intrinsics.checkNotNullExpressionValue(pair2, (String)"of(left, right as Key)");
                    pair = pair2;
                    collection2.add(pair);
                }
                object2 = (List)destination$iv$iv$iv;
                List list = object2;
                $this$asKeys$iv = new X25519DecrypterMulti(list);
            }
            catch (JOSEException e) {
                String $this$map$iv$iv3 = ((OctetKeyPair)recipient).getCurve().getName();
                Intrinsics.checkNotNullExpressionValue((Object)$this$map$iv$iv3, (String)"recipient.curve.name");
                throw new UnsupportedCurveException($this$map$iv$iv3);
            }
            object = $this$asKeys$iv;
        } else {
            $this$asKeys$iv = recipient.getClass().getName();
            Intrinsics.checkNotNullExpressionValue((Object)$this$asKeys$iv, (String)"recipient.javaClass.name");
            throw new UnsupportedJWKException((String)$this$asKeys$iv);
        }
        Object decrypter = object;
        try {
            jwe.decrypt((JWEDecrypterMulti)decrypter);
        }
        catch (Throwable t) {
            throw new MalformedMessageException("Decrypt is failed", t);
        }
        Object t = jwe.getPayload().toJSONObject();
        Intrinsics.checkNotNullExpressionValue(t, (String)"jwe.payload.toJSONObject()");
        Map<String, Object> map = t;
        t = to;
        object2 = map;
        boolean $i$f$map3 = false;
        void e = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Key $i$f$mapTo4 = (Key)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl3 = false;
            String string = it.getId();
            collection.add(string);
        }
        collection = (List)destination$iv$iv2;
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 4;
        String string = null;
        List list = collection;
        Object object3 = object2;
        return new DecryptResult((Map)object3, list, string, n, defaultConstructorMarker);
    }

    @NotNull
    public static final CryptAlg getCryptoAlg(@NotNull JWEObjectJSON jwe) {
        CryptAlg cryptAlg;
        Intrinsics.checkNotNullParameter((Object)jwe, (String)"jwe");
        JWEAlgorithm alg = jwe.getHeader().getAlgorithm();
        EncryptionMethod enc = jwe.getHeader().getEncryptionMethod();
        if (Intrinsics.areEqual((Object)alg, (Object)JWEAlgorithm.ECDH_1PU_A256KW) && Intrinsics.areEqual((Object)enc, (Object)EncryptionMethod.A256CBC_HS512)) {
            cryptAlg = AuthCryptAlg.A256CBC_HS512_ECDH_1PU_A256KW;
        } else if (Intrinsics.areEqual((Object)alg, (Object)JWEAlgorithm.ECDH_ES_A256KW) && Intrinsics.areEqual((Object)enc, (Object)EncryptionMethod.A256CBC_HS512)) {
            cryptAlg = AnonCryptAlg.A256CBC_HS512_ECDH_ES_A256KW;
        } else if (Intrinsics.areEqual((Object)alg, (Object)JWEAlgorithm.ECDH_ES_A256KW) && Intrinsics.areEqual((Object)enc, (Object)EncryptionMethod.XC20P)) {
            cryptAlg = AnonCryptAlg.XC20P_ECDH_ES_A256KW;
        } else if (Intrinsics.areEqual((Object)alg, (Object)JWEAlgorithm.ECDH_ES_A256KW) && Intrinsics.areEqual((Object)enc, (Object)EncryptionMethod.A256GCM)) {
            cryptAlg = AnonCryptAlg.A256GCM_ECDH_ES_A256KW;
        } else {
            throw new UnsupportedAlgorithm(alg.getName() + '+' + enc.getName(), null, 2, null);
        }
        return cryptAlg;
    }

    public static final /* synthetic */ DecryptResult access$authDecryptForAllKeys(JWEObjectJSON jwe, Key from, List to) {
        return JWEKt.authDecryptForAllKeys(jwe, from, to);
    }

    public static final /* synthetic */ DecryptResult access$anonDecryptForAllKeys(JWEObjectJSON jwe, List to) {
        return JWEKt.anonDecryptForAllKeys(jwe, to);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[AuthCryptAlg.values().length];
            nArray[AuthCryptAlg.A256CBC_HS512_ECDH_1PU_A256KW.ordinal()] = 1;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[AnonCryptAlg.values().length];
            nArray[AnonCryptAlg.A256CBC_HS512_ECDH_ES_A256KW.ordinal()] = 1;
            nArray[AnonCryptAlg.XC20P_ECDH_ES_A256KW.ordinal()] = 2;
            nArray[AnonCryptAlg.A256GCM_ECDH_ES_A256KW.ordinal()] = 3;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

