/*
 * Decompiled with CFR 0.152.
 */
package org.didcommx.didcomm.crypto;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSObjectJSON;
import com.nimbusds.jose.JWSProvider;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.UnprotectedHeader;
import com.nimbusds.jose.crypto.ECDSASigner;
import com.nimbusds.jose.crypto.ECDSAVerifier;
import com.nimbusds.jose.crypto.Ed25519Signer;
import com.nimbusds.jose.crypto.Ed25519Verifier;
import com.nimbusds.jose.crypto.impl.BaseJWSProvider;
import com.nimbusds.jose.jwk.Curve;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.OctetKeyPair;
import com.nimbusds.jose.util.Base64URL;
import java.security.SignatureException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.didcommx.didcomm.common.SignAlg;
import org.didcommx.didcomm.common.Typ;
import org.didcommx.didcomm.crypto.key.Key;
import org.didcommx.didcomm.exceptions.DIDCommException;
import org.didcommx.didcomm.exceptions.MalformedMessageException;
import org.didcommx.didcomm.exceptions.UnsupportedAlgorithm;
import org.didcommx.didcomm.exceptions.UnsupportedCurveException;
import org.didcommx.didcomm.exceptions.UnsupportedJWKException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u00052\u0006\u0010\u0007\u001a\u00020\b\u001a\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r\u001a\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u0011"}, d2={"getCryptoAlg", "Lorg/didcommx/didcomm/common/SignAlg;", "signature", "Lcom/nimbusds/jose/JWSObjectJSON$Signature;", "getJWSAlgorithm", "Lcom/nimbusds/jose/JWSAlgorithm;", "kotlin.jvm.PlatformType", "jwk", "Lcom/nimbusds/jose/jwk/JWK;", "sign", "", "payload", "key", "Lorg/didcommx/didcomm/crypto/key/Key;", "verify", "", "signAlg", "didcomm"})
public final class JWSKt {
    @NotNull
    public static final String sign(@NotNull String payload, @NotNull Key key) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        JWK jwk = key.getJwk();
        JWSAlgorithm alg = JWSKt.getJWSAlgorithm(jwk);
        try {
            JWSProvider jWSProvider;
            boolean $i$f$asKey;
            JWK $this$asKey$iv;
            object = alg;
            if (Intrinsics.areEqual((Object)object, (Object)JWSAlgorithm.ES256)) {
                $this$asKey$iv = jwk;
                $i$f$asKey = false;
                if (!($this$asKey$iv instanceof ECKey)) {
                    throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Can not cast JWK to ", (Object)ECKey.class.getName()));
                }
                jWSProvider = new ECDSASigner((ECKey)$this$asKey$iv);
            } else if (Intrinsics.areEqual((Object)object, (Object)JWSAlgorithm.ES256K)) {
                $this$asKey$iv = jwk;
                $i$f$asKey = false;
                if (!($this$asKey$iv instanceof ECKey)) {
                    throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Can not cast JWK to ", (Object)ECKey.class.getName()));
                }
                jWSProvider = new ECDSASigner((ECKey)$this$asKey$iv);
            } else if (Intrinsics.areEqual((Object)object, (Object)JWSAlgorithm.EdDSA)) {
                $this$asKey$iv = jwk;
                $i$f$asKey = false;
                JWK jWK = $this$asKey$iv;
                if (!(jWK != null ? jWK instanceof OctetKeyPair : true)) {
                    throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Can not cast JWK to ", (Object)OctetKeyPair.class.getName()));
                }
                jWSProvider = new Ed25519Signer((OctetKeyPair)$this$asKey$iv);
            } else {
                String $this$asKey$iv2 = alg.getName();
                Intrinsics.checkNotNullExpressionValue((Object)$this$asKey$iv2, (String)"alg.name");
                throw new UnsupportedAlgorithm($this$asKey$iv2, null, 2, null);
            }
            object = jWSProvider;
        }
        catch (JOSEException e) {
            String string = alg.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"alg.name");
            throw new UnsupportedAlgorithm(string, null, 2, null);
        }
        Object signer = object;
        JWSHeader jwsProtectedHeader = new JWSHeader.Builder(alg).type(new JOSEObjectType(Typ.Signed.getTyp())).build();
        UnprotectedHeader jwsUnprotectedHeader = new UnprotectedHeader.Builder().keyID(key.getId()).build();
        JWSObjectJSON jWSObjectJSON = new JWSObjectJSON(new Payload(Base64URL.encode(payload)));
        boolean bl = false;
        boolean bl2 = false;
        JWSObjectJSON $this$sign_u24lambda_u2d0 = jWSObjectJSON;
        boolean bl3 = false;
        try {
            $this$sign_u24lambda_u2d0.sign(jwsProtectedHeader, jwsUnprotectedHeader, (JWSSigner)signer);
        }
        catch (JOSEException e) {
            if (e.getCause() instanceof SignatureException) {
                throw new UnsupportedAlgorithm("Unsupported signature algorithm", e.getCause());
            }
            throw new DIDCommException("JWS cannot be signed", e);
        }
        String string = jWSObjectJSON.serializeGeneral();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"JWSObjectJSON(Payload(Base64URL.encode(payload)))\n        .apply {\n            try {\n                sign(jwsProtectedHeader, jwsUnprotectedHeader, signer)\n            } catch (e: JOSEException) {\n                // this can be thrown if the signature type is not supported\n                // example: curve256k1 is not supported in JDK >= 15\n                if (e.cause is SignatureException) {\n                    throw UnsupportedAlgorithm(\"Unsupported signature algorithm\", e.cause)\n                }\n                throw DIDCommException(\"JWS cannot be signed\", e)\n            }\n        }\n        .serializeGeneral()");
        return string;
    }

    public static final void verify(@NotNull JWSObjectJSON.Signature signature, @NotNull SignAlg signAlg, @NotNull Key key) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        Intrinsics.checkNotNullParameter((Object)((Object)signAlg), (String)"signAlg");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        JWK jwk = key.getJwk();
        try {
            BaseJWSProvider baseJWSProvider;
            object = signAlg;
            int n = WhenMappings.$EnumSwitchMapping$0[object.ordinal()];
            switch (n) {
                case 1: {
                    JWK $this$asKey$iv = jwk;
                    boolean $i$f$asKey = false;
                    if (!($this$asKey$iv instanceof ECKey)) {
                        throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Can not cast JWK to ", (Object)ECKey.class.getName()));
                    }
                    ECDSAVerifier eCDSAVerifier = new ECDSAVerifier((ECKey)$this$asKey$iv);
                    baseJWSProvider = eCDSAVerifier;
                    break;
                }
                case 2: {
                    JWK $this$asKey$iv = jwk;
                    boolean $i$f$asKey = false;
                    if (!($this$asKey$iv instanceof ECKey)) {
                        throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Can not cast JWK to ", (Object)ECKey.class.getName()));
                    }
                    ECDSAVerifier eCDSAVerifier = new ECDSAVerifier((ECKey)$this$asKey$iv);
                    baseJWSProvider = eCDSAVerifier;
                    break;
                }
                case 3: {
                    JWK $this$asKey$iv = jwk;
                    boolean $i$f$asKey = false;
                    JWK jWK = $this$asKey$iv;
                    if (!(jWK != null ? jWK instanceof OctetKeyPair : true)) {
                        throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Can not cast JWK to ", (Object)OctetKeyPair.class.getName()));
                    }
                    Ed25519Verifier ed25519Verifier = new Ed25519Verifier((OctetKeyPair)$this$asKey$iv);
                    baseJWSProvider = ed25519Verifier;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            object = baseJWSProvider;
        }
        catch (JOSEException e) {
            throw new UnsupportedAlgorithm(signAlg.name(), null, 2, null);
        }
        Object verifier = object;
        try {
            if (!signature.verify((JWSVerifier)verifier)) {
                throw new MalformedMessageException("Invalid signature", null, 2, null);
            }
        }
        catch (JOSEException e) {
            if (e.getCause() instanceof SignatureException) {
                throw new UnsupportedAlgorithm("Unsupported signature algorithm", e.getCause());
            }
            throw new DIDCommException("JWS signature cannot be verified", e);
        }
    }

    @NotNull
    public static final SignAlg getCryptoAlg(@NotNull JWSObjectJSON.Signature signature) {
        SignAlg signAlg;
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        JWSAlgorithm alg = signature.getHeader().getAlgorithm();
        if (Intrinsics.areEqual((Object)alg, (Object)JWSAlgorithm.ES256)) {
            signAlg = SignAlg.ES256;
        } else if (Intrinsics.areEqual((Object)alg, (Object)JWSAlgorithm.ES256K)) {
            signAlg = SignAlg.ES256K;
        } else if (Intrinsics.areEqual((Object)alg, (Object)JWSAlgorithm.EdDSA)) {
            signAlg = SignAlg.ED25519;
        } else {
            String string = alg.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"alg.name");
            throw new UnsupportedAlgorithm(string, null, 2, null);
        }
        return signAlg;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final JWSAlgorithm getJWSAlgorithm(@NotNull JWK jwk) {
        JWSAlgorithm jWSAlgorithm;
        Intrinsics.checkNotNullParameter((Object)jwk, (String)"jwk");
        JWK jWK = jwk;
        if (jWK instanceof ECKey) {
            Curve curve = ((ECKey)jwk).getCurve();
            if (Intrinsics.areEqual((Object)curve, (Object)Curve.P_256)) {
                jWSAlgorithm = JWSAlgorithm.ES256;
                return jWSAlgorithm;
            }
            if (Intrinsics.areEqual((Object)curve, (Object)Curve.SECP256K1)) {
                jWSAlgorithm = JWSAlgorithm.ES256K;
                return jWSAlgorithm;
            }
            String string = ((ECKey)jwk).getCurve().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jwk.curve.name");
            throw new UnsupportedCurveException(string);
        }
        if (!(jWK instanceof OctetKeyPair)) {
            String string = jwk.getClass().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jwk.javaClass.name");
            throw new UnsupportedJWKException(string);
        }
        Curve curve = ((OctetKeyPair)jwk).getCurve();
        if (Intrinsics.areEqual((Object)curve, (Object)Curve.Ed25519)) {
            jWSAlgorithm = JWSAlgorithm.EdDSA;
            return jWSAlgorithm;
        }
        String string = ((OctetKeyPair)jwk).getCurve().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jwk.curve.name");
        throw new UnsupportedCurveException(string);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SignAlg.values().length];
            nArray[SignAlg.ES256.ordinal()] = 1;
            nArray[SignAlg.ES256K.ordinal()] = 2;
            nArray[SignAlg.ED25519.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

