/*
 * Decompiled with CFR 0.152.
 */
package org.didcommx.didcomm.crypto;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.JWSProvider;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.ECDSASigner;
import com.nimbusds.jose.crypto.ECDSAVerifier;
import com.nimbusds.jose.crypto.Ed25519Signer;
import com.nimbusds.jose.crypto.Ed25519Verifier;
import com.nimbusds.jose.crypto.impl.BaseJWSProvider;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.OctetKeyPair;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.text.ParseException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.didcommx.didcomm.common.SignAlg;
import org.didcommx.didcomm.crypto.JWSKt;
import org.didcommx.didcomm.crypto.key.Key;
import org.didcommx.didcomm.exceptions.DIDCommException;
import org.didcommx.didcomm.exceptions.MalformedMessageException;
import org.didcommx.didcomm.exceptions.UnsupportedAlgorithm;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u0016\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\f"}, d2={"getCryptoAlg", "Lorg/didcommx/didcomm/common/SignAlg;", "jws", "Lcom/nimbusds/jose/JWSObject;", "signJwt", "", "jwtClaimsSet", "Lcom/nimbusds/jwt/JWTClaimsSet;", "key", "Lorg/didcommx/didcomm/crypto/key/Key;", "verifyJwt", "serializedJwt", "didcomm"})
public final class JWTKt {
    @NotNull
    public static final String signJwt(@NotNull JWTClaimsSet jwtClaimsSet, @NotNull Key key) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)jwtClaimsSet, (String)"jwtClaimsSet");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        JWK jwk = key.getJwk();
        JWSAlgorithm alg = JWSKt.getJWSAlgorithm(jwk);
        try {
            JWSProvider jWSProvider;
            boolean $i$f$asKey;
            JWK $this$asKey$iv;
            object = alg;
            if (Intrinsics.areEqual((Object)object, (Object)JWSAlgorithm.ES256)) {
                $this$asKey$iv = jwk;
                $i$f$asKey = false;
                if (!($this$asKey$iv instanceof ECKey)) {
                    throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Can not cast JWK to ", (Object)ECKey.class.getName()));
                }
                jWSProvider = new ECDSASigner((ECKey)$this$asKey$iv);
            } else if (Intrinsics.areEqual((Object)object, (Object)JWSAlgorithm.ES256K)) {
                $this$asKey$iv = jwk;
                $i$f$asKey = false;
                if (!($this$asKey$iv instanceof ECKey)) {
                    throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Can not cast JWK to ", (Object)ECKey.class.getName()));
                }
                jWSProvider = new ECDSASigner((ECKey)$this$asKey$iv);
            } else if (Intrinsics.areEqual((Object)object, (Object)JWSAlgorithm.EdDSA)) {
                $this$asKey$iv = jwk;
                $i$f$asKey = false;
                JWK jWK = $this$asKey$iv;
                if (!(jWK != null ? jWK instanceof OctetKeyPair : true)) {
                    throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Can not cast JWK to ", (Object)OctetKeyPair.class.getName()));
                }
                jWSProvider = new Ed25519Signer((OctetKeyPair)$this$asKey$iv);
            } else {
                String $this$asKey$iv2 = alg.getName();
                Intrinsics.checkNotNullExpressionValue((Object)$this$asKey$iv2, (String)"alg.name");
                throw new UnsupportedAlgorithm($this$asKey$iv2, null, 2, null);
            }
            object = jWSProvider;
        }
        catch (JOSEException e) {
            String string = alg.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"alg.name");
            throw new UnsupportedAlgorithm(string, null, 2, null);
        }
        Object signer = object;
        JWSHeader jwsHeader = new JWSHeader.Builder(alg).keyID(key.getId()).build();
        SignedJWT signedJWT = new SignedJWT(jwsHeader, jwtClaimsSet);
        boolean bl = false;
        boolean bl2 = false;
        SignedJWT $this$signJwt_u24lambda_u2d0 = signedJWT;
        boolean bl3 = false;
        try {
            $this$signJwt_u24lambda_u2d0.sign((JWSSigner)signer);
        }
        catch (JOSEException e) {
            throw new DIDCommException("JWT cannot be signed", e);
        }
        String string = signedJWT.serialize();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SignedJWT(jwsHeader, jwtClaimsSet)\n        .apply {\n            try {\n                sign(signer)\n            } catch (e: JOSEException) {\n                throw DIDCommException(\"JWT cannot be signed\", e)\n            }\n        }\n        .serialize()");
        return string;
    }

    @NotNull
    public static final JWTClaimsSet verifyJwt(@NotNull String serializedJwt, @NotNull Key key) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)serializedJwt, (String)"serializedJwt");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        SignedJWT signedJWT = null;
        try {
            SignedJWT signedJWT2 = SignedJWT.parse(serializedJwt);
            Intrinsics.checkNotNullExpressionValue((Object)signedJWT2, (String)"parse(serializedJwt)");
            signedJWT = signedJWT2;
        }
        catch (ParseException e) {
            throw new MalformedMessageException("JWT cannot be deserialized", e);
        }
        SignAlg signAlg = JWTKt.getCryptoAlg(signedJWT);
        JWK jwk = key.getJwk();
        try {
            BaseJWSProvider baseJWSProvider;
            object = signAlg;
            int n = WhenMappings.$EnumSwitchMapping$0[object.ordinal()];
            switch (n) {
                case 1: {
                    JWK $this$asKey$iv = jwk;
                    boolean $i$f$asKey = false;
                    if (!($this$asKey$iv instanceof ECKey)) {
                        throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Can not cast JWK to ", (Object)ECKey.class.getName()));
                    }
                    ECDSAVerifier eCDSAVerifier = new ECDSAVerifier((ECKey)$this$asKey$iv);
                    baseJWSProvider = eCDSAVerifier;
                    break;
                }
                case 2: {
                    JWK $this$asKey$iv = jwk;
                    boolean $i$f$asKey = false;
                    if (!($this$asKey$iv instanceof ECKey)) {
                        throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Can not cast JWK to ", (Object)ECKey.class.getName()));
                    }
                    ECDSAVerifier eCDSAVerifier = new ECDSAVerifier((ECKey)$this$asKey$iv);
                    baseJWSProvider = eCDSAVerifier;
                    break;
                }
                case 3: {
                    JWK $this$asKey$iv = jwk;
                    boolean $i$f$asKey = false;
                    JWK jWK = $this$asKey$iv;
                    if (!(jWK != null ? jWK instanceof OctetKeyPair : true)) {
                        throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Can not cast JWK to ", (Object)OctetKeyPair.class.getName()));
                    }
                    Ed25519Verifier ed25519Verifier = new Ed25519Verifier((OctetKeyPair)$this$asKey$iv);
                    baseJWSProvider = ed25519Verifier;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            object = baseJWSProvider;
        }
        catch (JOSEException e) {
            throw new UnsupportedAlgorithm(signAlg.name(), null, 2, null);
        }
        Object verifier = object;
        if (!signedJWT.verify((JWSVerifier)verifier)) {
            throw new MalformedMessageException("JWT has an invalid signature", null, 2, null);
        }
        try {
            object = signedJWT.getJWTClaimsSet();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"signedJWT.jwtClaimsSet");
            return object;
        }
        catch (ParseException e) {
            throw new MalformedMessageException("JWT payload cannot be parsed", e);
        }
    }

    @NotNull
    public static final SignAlg getCryptoAlg(@NotNull JWSObject jws) {
        SignAlg signAlg;
        Intrinsics.checkNotNullParameter((Object)jws, (String)"jws");
        JWSAlgorithm alg = jws.getHeader().getAlgorithm();
        if (Intrinsics.areEqual((Object)alg, (Object)JWSAlgorithm.ES256)) {
            signAlg = SignAlg.ES256;
        } else if (Intrinsics.areEqual((Object)alg, (Object)JWSAlgorithm.ES256K)) {
            signAlg = SignAlg.ES256K;
        } else if (Intrinsics.areEqual((Object)alg, (Object)JWSAlgorithm.EdDSA)) {
            signAlg = SignAlg.ED25519;
        } else {
            String string = alg.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"alg.name");
            throw new UnsupportedAlgorithm(string, null, 2, null);
        }
        return signAlg;
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SignAlg.values().length];
            nArray[SignAlg.ES256.ordinal()] = 1;
            nArray[SignAlg.ES256K.ordinal()] = 2;
            nArray[SignAlg.ED25519.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

