/*
 * Decompiled with CFR 0.152.
 */
package org.didcommx.didcomm.crypto;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEObjectJSON;
import com.nimbusds.jose.JWSObjectJSON;
import java.text.ParseException;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.didcommx.didcomm.exceptions.MalformedMessageException;
import org.didcommx.didcomm.message.Message;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\u0003\u0004\u0005B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0003\u0006\u0007\b\u00a8\u0006\t"}, d2={"Lorg/didcommx/didcomm/crypto/ParseResult;", "", "()V", "JWE", "JWM", "JWS", "Lorg/didcommx/didcomm/crypto/ParseResult$JWM;", "Lorg/didcommx/didcomm/crypto/ParseResult$JWS;", "Lorg/didcommx/didcomm/crypto/ParseResult$JWE;", "didcomm"})
public abstract class ParseResult {
    private ParseResult() {
    }

    public /* synthetic */ ParseResult(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/didcommx/didcomm/crypto/ParseResult$JWM;", "Lorg/didcommx/didcomm/crypto/ParseResult;", "message", "Lorg/didcommx/didcomm/message/Message;", "(Lorg/didcommx/didcomm/message/Message;)V", "getMessage", "()Lorg/didcommx/didcomm/message/Message;", "didcomm"})
    public static final class JWM
    extends ParseResult {
        @NotNull
        private final Message message;

        public JWM(@NotNull Message message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            super(null);
            this.message = message;
        }

        @NotNull
        public final Message getMessage() {
            return this.message;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lorg/didcommx/didcomm/crypto/ParseResult$JWS;", "Lorg/didcommx/didcomm/crypto/ParseResult;", "rawMessage", "", "", "", "(Ljava/util/Map;)V", "message", "Lcom/nimbusds/jose/JWSObjectJSON;", "getMessage", "()Lcom/nimbusds/jose/JWSObjectJSON;", "getRawMessage", "()Ljava/util/Map;", "didcomm"})
    public static final class JWS
    extends ParseResult {
        @NotNull
        private final Map<String, Object> rawMessage;
        @NotNull
        private final JWSObjectJSON message;

        /*
         * WARNING - void declaration
         */
        public JWS(@NotNull Map<String, ? extends Object> rawMessage) {
            JWSObjectJSON jWSObjectJSON;
            Intrinsics.checkNotNullParameter(rawMessage, (String)"rawMessage");
            super(null);
            this.rawMessage = rawMessage;
            JWS jWS = this;
            try {
                JWS jWS2 = jWS;
                jWSObjectJSON = JWSObjectJSON.parse(this.rawMessage);
                Intrinsics.checkNotNullExpressionValue((Object)jWSObjectJSON, (String)"{\n            JWSObjectJSON.parse(rawMessage)\n        }");
            }
            catch (JOSEException jOSEException) {
                void e;
                JWS jWS3 = jWS;
                throw new MalformedMessageException("Message cannot be parsed", (Throwable)e);
            }
            jWS2.message = jWSObjectJSON;
        }

        @NotNull
        public final Map<String, Object> getRawMessage() {
            return this.rawMessage;
        }

        @NotNull
        public final JWSObjectJSON getMessage() {
            return this.message;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/didcommx/didcomm/crypto/ParseResult$JWE;", "Lorg/didcommx/didcomm/crypto/ParseResult;", "rawMessage", "", "", "", "(Ljava/util/Map;)V", "message", "Lcom/nimbusds/jose/JWEObjectJSON;", "getMessage", "()Lcom/nimbusds/jose/JWEObjectJSON;", "didcomm"})
    public static final class JWE
    extends ParseResult {
        @NotNull
        private final JWEObjectJSON message;

        /*
         * WARNING - void declaration
         */
        public JWE(@NotNull Map<String, ? extends Object> rawMessage) {
            JWEObjectJSON jWEObjectJSON;
            Intrinsics.checkNotNullParameter(rawMessage, (String)"rawMessage");
            super(null);
            JWE jWE = this;
            try {
                JWE jWE2 = jWE;
                jWEObjectJSON = JWEObjectJSON.parse(rawMessage);
                Intrinsics.checkNotNullExpressionValue((Object)jWEObjectJSON, (String)"{\n            JWEObjectJSON.parse(rawMessage)\n        }");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                void e;
                JWE jWE3 = jWE;
                String string = e.getLocalizedMessage();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"e.localizedMessage");
                throw new MalformedMessageException(string, (Throwable)e);
            }
            catch (ParseException e) {
                JWE jWE4 = jWE;
                String string = e.getLocalizedMessage();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"e.localizedMessage");
                throw new MalformedMessageException(string, e);
            }
            jWE2.message = jWEObjectJSON;
        }

        @NotNull
        public final JWEObjectJSON getMessage() {
            return this.message;
        }
    }
}

