/*
 * Decompiled with CFR 0.152.
 */
package org.didcommx.didcomm.crypto.key;

import com.nimbusds.jose.jwk.Curve;
import com.nimbusds.jose.jwk.CurveBasedJWK;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.util.Base64URL;
import io.ipfs.multibase.Base58;
import io.ipfs.multibase.Multibase;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.didcommx.didcomm.common.VerificationMaterialFormat;
import org.didcommx.didcomm.common.VerificationMethodType;
import org.didcommx.didcomm.diddoc.VerificationMethod;
import org.didcommx.didcomm.exceptions.UnsupportedCurveException;
import org.didcommx.didcomm.exceptions.UnsupportedJWKException;
import org.didcommx.didcomm.exceptions.UnsupportedSecretMaterialFormatException;
import org.didcommx.didcomm.exceptions.UnsupportedSecretTypeException;
import org.didcommx.didcomm.exceptions.UnsupportedVerificationMethodMaterialFormatException;
import org.didcommx.didcomm.exceptions.UnsupportedVerificationMethodTypeException;
import org.didcommx.didcomm.secret.Secret;
import org.didcommx.didcomm.utils.Codec;
import org.didcommx.didcomm.utils.MulticodecUtilsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u0000 \u00102\u00020\u0001:\u0006\u000e\u000f\u0010\u0011\u0012\u0013R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u0082\u0001\u0005\u0014\u0015\u0016\u0017\u0018\u00a8\u0006\u0019"}, d2={"Lorg/didcommx/didcomm/crypto/key/Key;", "", "curve", "Lcom/nimbusds/jose/jwk/Curve;", "getCurve", "()Lcom/nimbusds/jose/jwk/Curve;", "id", "", "getId", "()Ljava/lang/String;", "jwk", "Lcom/nimbusds/jose/jwk/JWK;", "getJwk", "()Lcom/nimbusds/jose/jwk/JWK;", "Base58PrivateKey", "Base58PublicKey", "Companion", "JsonWebKey", "MultibasePrivateKey", "MultibasePublicKey", "Lorg/didcommx/didcomm/crypto/key/Key$JsonWebKey;", "Lorg/didcommx/didcomm/crypto/key/Key$Base58PublicKey;", "Lorg/didcommx/didcomm/crypto/key/Key$Base58PrivateKey;", "Lorg/didcommx/didcomm/crypto/key/Key$MultibasePublicKey;", "Lorg/didcommx/didcomm/crypto/key/Key$MultibasePrivateKey;", "didcomm"})
public interface Key {
    @NotNull
    public static final Companion Companion = org.didcommx.didcomm.crypto.key.Key$Companion.$$INSTANCE;

    @NotNull
    public String getId();

    @NotNull
    public JWK getJwk();

    @NotNull
    public Curve getCurve();

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/didcommx/didcomm/crypto/key/Key$Companion;", "", "()V", "CURVE25519_POINT_SIZE", "", "ED25519", "", "X25519", "fromSecret", "Lorg/didcommx/didcomm/crypto/key/Key;", "secret", "Lorg/didcommx/didcomm/secret/Secret;", "fromVerificationMethod", "method", "Lorg/didcommx/didcomm/diddoc/VerificationMethod;", "didcomm"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final String X25519 = "X25519";
        @NotNull
        private static final String ED25519 = "Ed25519";
        private static final int CURVE25519_POINT_SIZE = 32;

        private Companion() {
        }

        @NotNull
        public final Key fromVerificationMethod(@NotNull VerificationMethod method) {
            Key key;
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            VerificationMethodType verificationMethodType = method.getType();
            int n = WhenMappings.$EnumSwitchMapping$0[verificationMethodType.ordinal()];
            switch (n) {
                case 1: {
                    if (method.getVerificationMaterial().getFormat() != VerificationMaterialFormat.JWK) {
                        throw new UnsupportedVerificationMethodMaterialFormatException(method.getVerificationMaterial().getFormat(), method.getType());
                    }
                    key = new JsonWebKey(method.getId(), method.getVerificationMaterial().getValue());
                    break;
                }
                case 2: 
                case 3: {
                    String string;
                    if (method.getVerificationMaterial().getFormat() != VerificationMaterialFormat.BASE58) {
                        throw new UnsupportedVerificationMethodMaterialFormatException(method.getVerificationMaterial().getFormat(), method.getType());
                    }
                    VerificationMethodType verificationMethodType2 = method.getType();
                    int n2 = WhenMappings.$EnumSwitchMapping$0[verificationMethodType2.ordinal()];
                    switch (n2) {
                        case 2: {
                            string = X25519;
                            break;
                        }
                        case 3: {
                            string = ED25519;
                            break;
                        }
                        default: {
                            throw new UnsupportedVerificationMethodTypeException(method.getType());
                        }
                    }
                    String curve = string;
                    key = new Base58PublicKey(method.getId(), curve, method.getVerificationMaterial().getValue());
                    break;
                }
                case 4: 
                case 5: {
                    String string;
                    if (method.getVerificationMaterial().getFormat() != VerificationMaterialFormat.MULTIBASE) {
                        throw new UnsupportedVerificationMethodMaterialFormatException(method.getVerificationMaterial().getFormat(), method.getType());
                    }
                    VerificationMethodType verificationMethodType3 = method.getType();
                    int n3 = WhenMappings.$EnumSwitchMapping$0[verificationMethodType3.ordinal()];
                    switch (n3) {
                        case 4: {
                            string = X25519;
                            break;
                        }
                        case 5: {
                            string = ED25519;
                            break;
                        }
                        default: {
                            throw new UnsupportedVerificationMethodTypeException(method.getType());
                        }
                    }
                    String curve = string;
                    key = new MultibasePublicKey(method.getId(), curve, method.getVerificationMaterial().getValue());
                    break;
                }
                default: {
                    throw new UnsupportedVerificationMethodTypeException(method.getType());
                }
            }
            return key;
        }

        @NotNull
        public final Key fromSecret(@NotNull Secret secret) {
            Key key;
            Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
            VerificationMethodType verificationMethodType = secret.getType();
            int n = WhenMappings.$EnumSwitchMapping$0[verificationMethodType.ordinal()];
            switch (n) {
                case 1: {
                    if (secret.getVerificationMaterial().getFormat() != VerificationMaterialFormat.JWK) {
                        throw new UnsupportedSecretMaterialFormatException(secret.getVerificationMaterial().getFormat(), secret.getType());
                    }
                    key = new JsonWebKey(secret.getKid(), secret.getVerificationMaterial().getValue());
                    break;
                }
                case 2: 
                case 3: {
                    String string;
                    if (secret.getVerificationMaterial().getFormat() != VerificationMaterialFormat.BASE58) {
                        throw new UnsupportedSecretMaterialFormatException(secret.getVerificationMaterial().getFormat(), secret.getType());
                    }
                    VerificationMethodType verificationMethodType2 = secret.getType();
                    int n2 = WhenMappings.$EnumSwitchMapping$0[verificationMethodType2.ordinal()];
                    switch (n2) {
                        case 2: {
                            string = X25519;
                            break;
                        }
                        case 3: {
                            string = ED25519;
                            break;
                        }
                        default: {
                            throw new UnsupportedSecretTypeException(secret.getType());
                        }
                    }
                    String curve = string;
                    key = new Base58PrivateKey(secret.getKid(), curve, secret.getVerificationMaterial().getValue());
                    break;
                }
                case 4: 
                case 5: {
                    String string;
                    if (secret.getVerificationMaterial().getFormat() != VerificationMaterialFormat.MULTIBASE) {
                        throw new UnsupportedSecretMaterialFormatException(secret.getVerificationMaterial().getFormat(), secret.getType());
                    }
                    VerificationMethodType verificationMethodType3 = secret.getType();
                    int n3 = WhenMappings.$EnumSwitchMapping$0[verificationMethodType3.ordinal()];
                    switch (n3) {
                        case 4: {
                            string = X25519;
                            break;
                        }
                        case 5: {
                            string = ED25519;
                            break;
                        }
                        default: {
                            throw new UnsupportedSecretTypeException(secret.getType());
                        }
                    }
                    String curve = string;
                    key = new MultibasePrivateKey(secret.getKid(), curve, secret.getVerificationMaterial().getValue());
                    break;
                }
                default: {
                    throw new UnsupportedSecretTypeException(secret.getType());
                }
            }
            return key;
        }

        static {
            $$INSTANCE = new Companion();
        }

        @Metadata(mv={1, 5, 1}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[VerificationMethodType.values().length];
                nArray[VerificationMethodType.JSON_WEB_KEY_2020.ordinal()] = 1;
                nArray[VerificationMethodType.X25519_KEY_AGREEMENT_KEY_2019.ordinal()] = 2;
                nArray[VerificationMethodType.ED25519_VERIFICATION_KEY_2018.ordinal()] = 3;
                nArray[VerificationMethodType.X25519_KEY_AGREEMENT_KEY_2020.ordinal()] = 4;
                nArray[VerificationMethodType.ED25519_VERIFICATION_KEY_2020.ordinal()] = 5;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u001e\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@RX\u0096.\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001e\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\r@RX\u0096.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lorg/didcommx/didcomm/crypto/key/Key$JsonWebKey;", "Lorg/didcommx/didcomm/crypto/key/Key;", "id", "", "materialValue", "(Ljava/lang/String;Ljava/lang/String;)V", "<set-?>", "Lcom/nimbusds/jose/jwk/Curve;", "curve", "getCurve", "()Lcom/nimbusds/jose/jwk/Curve;", "getId", "()Ljava/lang/String;", "Lcom/nimbusds/jose/jwk/JWK;", "jwk", "getJwk", "()Lcom/nimbusds/jose/jwk/JWK;", "didcomm"})
    private static final class JsonWebKey
    implements Key {
        @NotNull
        private final String id;
        private JWK jwk;
        private Curve curve;

        public JsonWebKey(@NotNull String id, @NotNull String materialValue) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)materialValue, (String)"materialValue");
            this.id = id;
            JWK jwk = JWK.parse(materialValue);
            if (!(jwk instanceof CurveBasedJWK)) {
                String string = jwk.getClass().getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jwk::class.java.name");
                throw new UnsupportedJWKException(string);
            }
            this.jwk = jwk;
            Curve curve = ((CurveBasedJWK)((Object)jwk)).getCurve();
            Intrinsics.checkNotNullExpressionValue((Object)curve, (String)"jwk.curve");
            this.curve = curve;
        }

        @Override
        @NotNull
        public String getId() {
            return this.id;
        }

        @Override
        @NotNull
        public JWK getJwk() {
            JWK jWK = this.jwk;
            if (jWK != null) {
                return jWK;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"jwk");
            throw null;
        }

        @Override
        @NotNull
        public Curve getCurve() {
            Curve curve = this.curve;
            if (curve != null) {
                return curve;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"curve");
            throw null;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006R\u001e\u0010\u0004\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@RX\u0096.\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001e\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\r@RX\u0096.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lorg/didcommx/didcomm/crypto/key/Key$Base58PublicKey;", "Lorg/didcommx/didcomm/crypto/key/Key;", "id", "", "curve", "materialValue", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "<set-?>", "Lcom/nimbusds/jose/jwk/Curve;", "getCurve", "()Lcom/nimbusds/jose/jwk/Curve;", "getId", "()Ljava/lang/String;", "Lcom/nimbusds/jose/jwk/JWK;", "jwk", "getJwk", "()Lcom/nimbusds/jose/jwk/JWK;", "didcomm"})
    private static final class Base58PublicKey
    implements Key {
        @NotNull
        private final String id;
        private JWK jwk;
        private Curve curve;

        public Base58PublicKey(@NotNull String id, @NotNull String curve, @NotNull String materialValue) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)curve, (String)"curve");
            Intrinsics.checkNotNullParameter((Object)materialValue, (String)"materialValue");
            this.id = id;
            byte[] rawValue = Base58.decode(materialValue);
            String string = Base64URL.encode(rawValue).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encode(rawValue).toString()");
            String base64URLValue = string;
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"kty", (Object)"OKP"), TuplesKt.to((Object)"crv", (Object)curve), TuplesKt.to((Object)"x", (Object)base64URLValue)};
            Map jwkJson = MapsKt.mapOf((Pair[])pairArray);
            JWK jwk = JWK.parse(jwkJson);
            if (!(jwk instanceof CurveBasedJWK)) {
                String string2 = jwk.getClass().getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"jwk::class.java.name");
                throw new UnsupportedJWKException(string2);
            }
            this.jwk = jwk;
            Curve curve2 = ((CurveBasedJWK)((Object)jwk)).getCurve();
            Intrinsics.checkNotNullExpressionValue((Object)curve2, (String)"jwk.curve");
            this.curve = curve2;
        }

        @Override
        @NotNull
        public String getId() {
            return this.id;
        }

        @Override
        @NotNull
        public JWK getJwk() {
            JWK jWK = this.jwk;
            if (jWK != null) {
                return jWK;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"jwk");
            throw null;
        }

        @Override
        @NotNull
        public Curve getCurve() {
            Curve curve = this.curve;
            if (curve != null) {
                return curve;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"curve");
            throw null;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006R\u001e\u0010\u0004\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@RX\u0096.\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001e\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\r@RX\u0096.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lorg/didcommx/didcomm/crypto/key/Key$Base58PrivateKey;", "Lorg/didcommx/didcomm/crypto/key/Key;", "id", "", "curve", "materialValue", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "<set-?>", "Lcom/nimbusds/jose/jwk/Curve;", "getCurve", "()Lcom/nimbusds/jose/jwk/Curve;", "getId", "()Ljava/lang/String;", "Lcom/nimbusds/jose/jwk/JWK;", "jwk", "getJwk", "()Lcom/nimbusds/jose/jwk/JWK;", "didcomm"})
    private static final class Base58PrivateKey
    implements Key {
        @NotNull
        private final String id;
        private JWK jwk;
        private Curve curve;

        public Base58PrivateKey(@NotNull String id, @NotNull String curve, @NotNull String materialValue) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)curve, (String)"curve");
            Intrinsics.checkNotNullParameter((Object)materialValue, (String)"materialValue");
            this.id = id;
            byte[] rawValue = Base58.decode(materialValue);
            Intrinsics.checkNotNullExpressionValue((Object)rawValue, (String)"rawValue");
            byte[] rawValueD = ArraysKt.sliceArray((byte[])rawValue, (IntRange)RangesKt.until((int)0, (int)32));
            byte[] rawValueX = ArraysKt.sliceArray((byte[])rawValue, (IntRange)RangesKt.until((int)32, (int)rawValue.length));
            String string = Base64URL.encode(rawValueD).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encode(rawValueD).toString()");
            String base64URLValueD = string;
            String string2 = Base64URL.encode(rawValueX).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"encode(rawValueX).toString()");
            String base64URLValueX = string2;
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"kty", (Object)"OKP"), TuplesKt.to((Object)"crv", (Object)curve), TuplesKt.to((Object)"x", (Object)base64URLValueX), TuplesKt.to((Object)"d", (Object)base64URLValueD)};
            Map jwkJson = MapsKt.mapOf((Pair[])pairArray);
            JWK jwk = JWK.parse(jwkJson);
            if (!(jwk instanceof CurveBasedJWK)) {
                String string3 = jwk.getClass().getName();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"jwk::class.java.name");
                throw new UnsupportedJWKException(string3);
            }
            this.jwk = jwk;
            Curve curve2 = ((CurveBasedJWK)((Object)jwk)).getCurve();
            Intrinsics.checkNotNullExpressionValue((Object)curve2, (String)"jwk.curve");
            this.curve = curve2;
        }

        @Override
        @NotNull
        public String getId() {
            return this.id;
        }

        @Override
        @NotNull
        public JWK getJwk() {
            JWK jWK = this.jwk;
            if (jWK != null) {
                return jWK;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"jwk");
            throw null;
        }

        @Override
        @NotNull
        public Curve getCurve() {
            Curve curve = this.curve;
            if (curve != null) {
                return curve;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"curve");
            throw null;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006R\u001e\u0010\u0004\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@RX\u0096.\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001e\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\r@RX\u0096.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lorg/didcommx/didcomm/crypto/key/Key$MultibasePublicKey;", "Lorg/didcommx/didcomm/crypto/key/Key;", "id", "", "curve", "materialValue", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "<set-?>", "Lcom/nimbusds/jose/jwk/Curve;", "getCurve", "()Lcom/nimbusds/jose/jwk/Curve;", "getId", "()Ljava/lang/String;", "Lcom/nimbusds/jose/jwk/JWK;", "jwk", "getJwk", "()Lcom/nimbusds/jose/jwk/JWK;", "didcomm"})
    private static final class MultibasePublicKey
    implements Key {
        @NotNull
        private final String id;
        private JWK jwk;
        private Curve curve;

        public MultibasePublicKey(@NotNull String id, @NotNull String curve, @NotNull String materialValue) {
            Codec codec;
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)curve, (String)"curve");
            Intrinsics.checkNotNullParameter((Object)materialValue, (String)"materialValue");
            this.id = id;
            byte[] prefixedRawValue = Multibase.decode(materialValue);
            Intrinsics.checkNotNullExpressionValue((Object)prefixedRawValue, (String)"prefixedRawValue");
            Pair<Codec, byte[]> pair = MulticodecUtilsKt.fromMulticodec(prefixedRawValue);
            Codec codec2 = (Codec)((Object)pair.component1());
            byte[] rawValue = (byte[])pair.component2();
            String string = curve;
            if (Intrinsics.areEqual((Object)string, (Object)"X25519")) {
                codec = Codec.X25519_PUB;
            } else if (Intrinsics.areEqual((Object)string, (Object)"Ed25519")) {
                codec = Codec.ED25519_PUB;
            } else {
                throw new UnsupportedCurveException(curve);
            }
            Codec expectedCodec = codec;
            if (codec2 != expectedCodec) {
                throw new IllegalArgumentException("Multicoded prefix " + codec2.getPrefix() + " is not valid for publicKeyMultibase and " + curve + " curve");
            }
            String string2 = Base64URL.encode(rawValue).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"encode(rawValue).toString()");
            String base64URLValue = string2;
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"kty", (Object)"OKP"), TuplesKt.to((Object)"crv", (Object)curve), TuplesKt.to((Object)"x", (Object)base64URLValue)};
            Map jwkJson = MapsKt.mapOf((Pair[])pairArray);
            JWK jwk = JWK.parse(jwkJson);
            if (!(jwk instanceof CurveBasedJWK)) {
                String string3 = jwk.getClass().getName();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"jwk::class.java.name");
                throw new UnsupportedJWKException(string3);
            }
            this.jwk = jwk;
            Curve curve2 = ((CurveBasedJWK)((Object)jwk)).getCurve();
            Intrinsics.checkNotNullExpressionValue((Object)curve2, (String)"jwk.curve");
            this.curve = curve2;
        }

        @Override
        @NotNull
        public String getId() {
            return this.id;
        }

        @Override
        @NotNull
        public JWK getJwk() {
            JWK jWK = this.jwk;
            if (jWK != null) {
                return jWK;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"jwk");
            throw null;
        }

        @Override
        @NotNull
        public Curve getCurve() {
            Curve curve = this.curve;
            if (curve != null) {
                return curve;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"curve");
            throw null;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006R\u001e\u0010\u0004\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@RX\u0096.\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001e\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\r@RX\u0096.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lorg/didcommx/didcomm/crypto/key/Key$MultibasePrivateKey;", "Lorg/didcommx/didcomm/crypto/key/Key;", "id", "", "curve", "materialValue", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "<set-?>", "Lcom/nimbusds/jose/jwk/Curve;", "getCurve", "()Lcom/nimbusds/jose/jwk/Curve;", "getId", "()Ljava/lang/String;", "Lcom/nimbusds/jose/jwk/JWK;", "jwk", "getJwk", "()Lcom/nimbusds/jose/jwk/JWK;", "didcomm"})
    private static final class MultibasePrivateKey
    implements Key {
        @NotNull
        private final String id;
        private JWK jwk;
        private Curve curve;

        public MultibasePrivateKey(@NotNull String id, @NotNull String curve, @NotNull String materialValue) {
            Codec codec;
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)curve, (String)"curve");
            Intrinsics.checkNotNullParameter((Object)materialValue, (String)"materialValue");
            this.id = id;
            byte[] prefixedRawValue = Multibase.decode(materialValue);
            Intrinsics.checkNotNullExpressionValue((Object)prefixedRawValue, (String)"prefixedRawValue");
            Pair<Codec, byte[]> pair = MulticodecUtilsKt.fromMulticodec(prefixedRawValue);
            Codec codec2 = (Codec)((Object)pair.component1());
            byte[] rawValue = (byte[])pair.component2();
            String string = curve;
            if (Intrinsics.areEqual((Object)string, (Object)"X25519")) {
                codec = Codec.X25519_PRIV;
            } else if (Intrinsics.areEqual((Object)string, (Object)"Ed25519")) {
                codec = Codec.ED25519_PRIV;
            } else {
                throw new UnsupportedCurveException(curve);
            }
            Codec expectedCodec = codec;
            if (codec2 != expectedCodec) {
                throw new IllegalArgumentException("Multicoded prefix " + codec2.getPrefix() + " is not valid for publicKeyMultibase and " + curve + " curve");
            }
            byte[] rawValueD = ArraysKt.sliceArray((byte[])rawValue, (IntRange)RangesKt.until((int)0, (int)32));
            byte[] rawValueX = ArraysKt.sliceArray((byte[])rawValue, (IntRange)RangesKt.until((int)32, (int)rawValue.length));
            String string2 = Base64URL.encode(rawValueD).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"encode(rawValueD).toString()");
            String base64URLValueD = string2;
            String string3 = Base64URL.encode(rawValueX).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"encode(rawValueX).toString()");
            String base64URLValueX = string3;
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"kty", (Object)"OKP"), TuplesKt.to((Object)"crv", (Object)curve), TuplesKt.to((Object)"x", (Object)base64URLValueX), TuplesKt.to((Object)"d", (Object)base64URLValueD)};
            Map jwkJson = MapsKt.mapOf((Pair[])pairArray);
            JWK jwk = JWK.parse(jwkJson);
            if (!(jwk instanceof CurveBasedJWK)) {
                String string4 = jwk.getClass().getName();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"jwk::class.java.name");
                throw new UnsupportedJWKException(string4);
            }
            this.jwk = jwk;
            Curve curve2 = ((CurveBasedJWK)((Object)jwk)).getCurve();
            Intrinsics.checkNotNullExpressionValue((Object)curve2, (String)"jwk.curve");
            this.curve = curve2;
        }

        @Override
        @NotNull
        public String getId() {
            return this.id;
        }

        @Override
        @NotNull
        public JWK getJwk() {
            JWK jWK = this.jwk;
            if (jWK != null) {
                return jWK;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"jwk");
            throw null;
        }

        @Override
        @NotNull
        public Curve getCurve() {
            Curve curve = this.curve;
            if (curve != null) {
                return curve;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"curve");
            throw null;
        }
    }
}

