/*
 * Decompiled with CFR 0.152.
 */
package org.didcommx.didcomm.crypto.key;

import com.nimbusds.jose.jwk.Curve;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.didcommx.didcomm.crypto.key.Key;
import org.didcommx.didcomm.crypto.key.RecipientKeySelector;
import org.didcommx.didcomm.diddoc.DIDDoc;
import org.didcommx.didcomm.diddoc.DIDDocResolver;
import org.didcommx.didcomm.diddoc.VerificationMethod;
import org.didcommx.didcomm.exceptions.DIDUrlNotFoundException;
import org.didcommx.didcomm.exceptions.IncompatibleCryptoException;
import org.didcommx.didcomm.exceptions.SecretNotFoundException;
import org.didcommx.didcomm.secret.Secret;
import org.didcommx.didcomm.secret.SecretResolver;
import org.didcommx.didcomm.utils.DIDUtilsKt;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ.\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u000e2\u0006\u0010\u000f\u001a\u00020\f2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ&\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u000e\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\fJ\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/didcommx/didcomm/crypto/key/RecipientKeySelector;", "", "didDocResolver", "Lorg/didcommx/didcomm/diddoc/DIDDocResolver;", "secretResolver", "Lorg/didcommx/didcomm/secret/SecretResolver;", "(Lorg/didcommx/didcomm/diddoc/DIDDocResolver;Lorg/didcommx/didcomm/secret/SecretResolver;)V", "findAnonCryptKeys", "Lkotlin/sequences/Sequence;", "Lorg/didcommx/didcomm/crypto/key/Key;", "to", "", "", "findAuthCryptKeys", "Lkotlin/Pair;", "from", "findRecipientKeys", "curve", "Lcom/nimbusds/jose/jwk/Curve;", "findVerificationKey", "signFrom", "hasKeysForForwardNext", "", "next", "didcomm"})
public final class RecipientKeySelector {
    @NotNull
    private final DIDDocResolver didDocResolver;
    @NotNull
    private final SecretResolver secretResolver;

    public RecipientKeySelector(@NotNull DIDDocResolver didDocResolver, @NotNull SecretResolver secretResolver) {
        Intrinsics.checkNotNullParameter((Object)didDocResolver, (String)"didDocResolver");
        Intrinsics.checkNotNullParameter((Object)secretResolver, (String)"secretResolver");
        this.didDocResolver = didDocResolver;
        this.secretResolver = secretResolver;
    }

    @NotNull
    public final Key findVerificationKey(@NotNull String signFrom) {
        List<String> list;
        Intrinsics.checkNotNullParameter((Object)signFrom, (String)"signFrom");
        RecipientKeySelector recipientKeySelector = this;
        boolean bl = false;
        boolean bl2 = false;
        RecipientKeySelector recipientKeySelector2 = recipientKeySelector;
        Key.Companion companion = Key.Companion;
        boolean bl3 = false;
        boolean bl4 = DIDUtilsKt.isDIDFragment(signFrom);
        boolean bl5 = false;
        boolean bl6 = false;
        if (!bl4) {
            boolean bl7 = false;
            String string = Intrinsics.stringPlus((String)"'DID URL' is expected as a signature verification key. Got: ", (Object)signFrom);
            throw (Throwable)new IllegalStateException(string.toString());
        }
        List<String> list2 = list = DIDUtilsKt.divideDIDFragment(signFrom);
        boolean bl8 = false;
        String did = list2.get(0);
        VerificationMethod verificationMethod = this.didDocResolver.resolve(did).map(arg_0 -> RecipientKeySelector.findVerificationKey$lambda-2$lambda-1(signFrom, arg_0)).orElseThrow(new Supplier(signFrom, did){
            final /* synthetic */ String $signFrom;
            final /* synthetic */ String $did;
            {
                this.$signFrom = $signFrom;
                this.$did = $did;
            }

            public final Void get() {
                throw new DIDUrlNotFoundException(this.$signFrom, this.$did);
            }
        });
        VerificationMethod verificationMethod2 = verificationMethod;
        Intrinsics.checkNotNullExpressionValue((Object)verificationMethod2, (String)"let {\n            check(isDIDFragment(signFrom)) { \"'DID URL' is expected as a signature verification key. Got: $signFrom\" }\n\n            val (did) = divideDIDFragment(signFrom)\n            didDocResolver.resolve(did)\n                .map { it.findVerificationMethod(signFrom) }\n                .orElseThrow { throw DIDUrlNotFoundException(signFrom, did) }\n        }");
        return companion.fromVerificationMethod(verificationMethod2);
    }

    @NotNull
    public final Pair<Key, Sequence<Key>> findAuthCryptKeys(@NotNull String from, @NotNull List<String> to) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter(to, (String)"to");
        boolean bl = DIDUtilsKt.isDIDFragment(from);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = Intrinsics.stringPlus((String)"'DID URL' is expected as a sender key. Got: ", (Object)from);
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Pair pair2 = pair = DIDUtilsKt.divideDIDFragment(from);
        boolean bl5 = false;
        String did = pair2.get(0);
        pair2 = this.didDocResolver.resolve(did).map(arg_0 -> RecipientKeySelector.findAuthCryptKeys$lambda-4(from, arg_0)).map(RecipientKeySelector::findAuthCryptKeys$lambda-5).map(arg_0 -> RecipientKeySelector.findAuthCryptKeys$lambda-6(this, to, arg_0)).orElseThrow(() -> RecipientKeySelector.findAuthCryptKeys$lambda-7(from, did));
        Intrinsics.checkNotNullExpressionValue((Object)pair2, (String)"didDocResolver.resolve(did)\n            .map { it.findVerificationMethod(from) }\n            .map { Key.fromVerificationMethod(it) }\n            .map { Pair(it, findRecipientKeys(to, it.curve)) }\n            .orElseThrow { DIDUrlNotFoundException(from, did) }");
        return pair2;
    }

    public final boolean hasKeysForForwardNext(@NotNull String next) {
        Intrinsics.checkNotNullParameter((Object)next, (String)"next");
        List nextKids = DIDUtilsKt.isDIDFragment(next) ? CollectionsKt.listOf((Object)next) : this.didDocResolver.resolve(next).map(RecipientKeySelector::hasKeysForForwardNext$lambda-8).orElse(CollectionsKt.emptyList());
        Intrinsics.checkNotNullExpressionValue((Object)nextKids, (String)"nextKids");
        Collection collection = this.secretResolver.findKeys(nextKids);
        boolean bl = false;
        return !collection.isEmpty();
    }

    @NotNull
    public final Sequence<Key> findAnonCryptKeys(@NotNull List<String> to) {
        Intrinsics.checkNotNullParameter(to, (String)"to");
        Iterable $this$forEach$iv = to;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            boolean bl2 = DIDUtilsKt.isDIDFragment(it);
            boolean bl3 = false;
            boolean bl4 = false;
            if (bl2) continue;
            boolean bl5 = false;
            String string = Intrinsics.stringPlus((String)"'DID URL' is expected as a recipient key. Got: ", (Object)it);
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Unit unit = Unit.INSTANCE;
        boolean bl = false;
        boolean bl6 = false;
        Unit $this$findAnonCryptKeys_u24lambda_u2d11 = unit;
        boolean bl7 = false;
        return this.findRecipientKeys(to, null);
    }

    private final Sequence<Key> findRecipientKeys(List<String> to, Curve curve) {
        Collection collection = this.secretResolver.findKeys(to);
        boolean bl = false;
        if (collection.isEmpty()) {
            boolean bl2 = false;
            throw new SecretNotFoundException(CollectionsKt.joinToString$default((Iterable)to, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
        }
        return SequencesKt.ifEmpty((Sequence)SequencesKt.map((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)collection), (Function1)findRecipientKeys.2.INSTANCE), (Function1)((Function1)new Function1<String, Secret>(this){
            final /* synthetic */ RecipientKeySelector this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final Secret invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return RecipientKeySelector.access$getSecretResolver$p(this.this$0).findKey(it).orElse(null);
            }
        })), (Function1)findRecipientKeys.4.INSTANCE), (Function1)((Function1)new Function1<Key, Key>(curve){
            final /* synthetic */ Curve $curve;
            {
                this.$curve = $curve;
                super(1);
            }

            @NotNull
            public final Key invoke(@NotNull Key it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (this.$curve != null && !Intrinsics.areEqual((Object)this.$curve, (Object)it.getCurve())) {
                    throw new IncompatibleCryptoException("The recipient '" + it.getId() + "' curve is not compatible to '" + this.$curve.getName() + '\'');
                }
                return it;
            }
        })), (Function0)findRecipientKeys.6.INSTANCE);
    }

    private static final VerificationMethod findVerificationKey$lambda-2$lambda-1(String $signFrom, DIDDoc it) {
        Intrinsics.checkNotNullParameter((Object)$signFrom, (String)"$signFrom");
        return it.findVerificationMethod($signFrom);
    }

    private static final VerificationMethod findAuthCryptKeys$lambda-4(String $from, DIDDoc it) {
        Intrinsics.checkNotNullParameter((Object)$from, (String)"$from");
        return it.findVerificationMethod($from);
    }

    private static final Key findAuthCryptKeys$lambda-5(VerificationMethod it) {
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return Key.Companion.fromVerificationMethod(it);
    }

    private static final Pair findAuthCryptKeys$lambda-6(RecipientKeySelector this$0, List $to, Key it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$to, (String)"$to");
        return new Pair((Object)it, this$0.findRecipientKeys($to, it.getCurve()));
    }

    private static final DIDUrlNotFoundException findAuthCryptKeys$lambda-7(String $from, String $did) {
        Intrinsics.checkNotNullParameter((Object)$from, (String)"$from");
        Intrinsics.checkNotNullParameter((Object)$did, (String)"$did");
        return new DIDUrlNotFoundException($from, $did);
    }

    private static final List hasKeysForForwardNext$lambda-8(DIDDoc it) {
        return it.getKeyAgreements();
    }

    public static final /* synthetic */ SecretResolver access$getSecretResolver$p(RecipientKeySelector $this) {
        return $this.secretResolver;
    }
}

