/*
 * Decompiled with CFR 0.152.
 */
package org.didcommx.didcomm.crypto.key;

import com.nimbusds.jose.jwk.Curve;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.didcommx.didcomm.crypto.key.Key;
import org.didcommx.didcomm.crypto.key.SenderKeySelector;
import org.didcommx.didcomm.diddoc.DIDDoc;
import org.didcommx.didcomm.diddoc.DIDDocResolver;
import org.didcommx.didcomm.diddoc.VerificationMethod;
import org.didcommx.didcomm.exceptions.DIDDocException;
import org.didcommx.didcomm.exceptions.DIDDocNotResolvedException;
import org.didcommx.didcomm.exceptions.IncompatibleCryptoException;
import org.didcommx.didcomm.exceptions.SecretNotFoundException;
import org.didcommx.didcomm.secret.Secret;
import org.didcommx.didcomm.secret.SecretResolver;
import org.didcommx.didcomm.utils.DIDUtilsKt;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bJ(\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\r2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000bJ&\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u000e\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/didcommx/didcomm/crypto/key/SenderKeySelector;", "", "didDocResolver", "Lorg/didcommx/didcomm/diddoc/DIDDocResolver;", "secretResolver", "Lorg/didcommx/didcomm/secret/SecretResolver;", "(Lorg/didcommx/didcomm/diddoc/DIDDocResolver;Lorg/didcommx/didcomm/secret/SecretResolver;)V", "findAnonCryptKeys", "", "Lorg/didcommx/didcomm/crypto/key/Key;", "to", "", "findAuthCryptKeys", "Lkotlin/Pair;", "from", "findRecipientKeys", "didDoc", "Lorg/didcommx/didcomm/diddoc/DIDDoc;", "curve", "Lcom/nimbusds/jose/jwk/Curve;", "findSigningKey", "signFrom", "didcomm"})
public final class SenderKeySelector {
    @NotNull
    private final DIDDocResolver didDocResolver;
    @NotNull
    private final SecretResolver secretResolver;

    public SenderKeySelector(@NotNull DIDDocResolver didDocResolver, @NotNull SecretResolver secretResolver) {
        Intrinsics.checkNotNullParameter((Object)didDocResolver, (String)"didDocResolver");
        Intrinsics.checkNotNullParameter((Object)secretResolver, (String)"secretResolver");
        this.didDocResolver = didDocResolver;
        this.secretResolver = secretResolver;
    }

    @NotNull
    public final Key findSigningKey(@NotNull String signFrom) {
        Secret secret;
        Intrinsics.checkNotNullParameter((Object)signFrom, (String)"signFrom");
        if (DIDUtilsKt.isDIDFragment(signFrom)) {
            secret = this.secretResolver.findKey(signFrom).orElseThrow(new Supplier(signFrom){
                final /* synthetic */ String $signFrom;
                {
                    this.$signFrom = $signFrom;
                }

                public final Void get() {
                    throw new SecretNotFoundException(this.$signFrom);
                }
            });
        } else {
            DIDDoc didDoc2 = this.didDocResolver.resolve(signFrom).orElseThrow(new Supplier(signFrom){
                final /* synthetic */ String $signFrom;
                {
                    this.$signFrom = $signFrom;
                }

                public final Void get() {
                    throw new DIDDocNotResolvedException(this.$signFrom);
                }
            });
            String string = (String)CollectionsKt.firstOrNull(didDoc2.getAuthentications());
            if (string == null) {
                throw new DIDDocException("The DID Doc '" + didDoc2.getDid() + "' does not contain compatible 'authentication' verification methods");
            }
            String authentication = string;
            secret = this.secretResolver.findKey(authentication).orElseThrow(new Supplier(signFrom){
                final /* synthetic */ String $signFrom;
                {
                    this.$signFrom = $signFrom;
                }

                public final Void get() {
                    throw new SecretNotFoundException(this.$signFrom);
                }
            });
        }
        Secret secret2 = secret;
        Intrinsics.checkNotNullExpressionValue((Object)secret2, (String)"signFrom: String): Key = Key.fromSecret(\n        if (isDIDFragment(signFrom)) {\n            secretResolver.findKey(signFrom).orElseThrow { throw SecretNotFoundException(signFrom) }\n        } else {\n            val didDoc = didDocResolver.resolve(signFrom).orElseThrow { throw DIDDocNotResolvedException(signFrom) }\n\n            val authentication = didDoc.authentications.firstOrNull()\n                ?: throw DIDDocException(\"The DID Doc '${didDoc.did}' does not contain compatible 'authentication' verification methods\")\n\n            secretResolver.findKey(authentication).orElseThrow { throw SecretNotFoundException(signFrom) }\n        }");
        return Key.Companion.fromSecret(secret2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Pair<Key, List<Key>> findAuthCryptKeys(@NotNull String from, @NotNull String to) {
        Pair pair;
        List<String> list;
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        List<String> list2 = list = DIDUtilsKt.divideDIDFragment(from);
        boolean bl = false;
        String didFrom = list2.get(0);
        List<String> list3 = list2 = DIDUtilsKt.divideDIDFragment(to);
        boolean bl2 = false;
        String didTo = list3.get(0);
        DIDDoc didDocTo2 = this.didDocResolver.resolve(didTo).orElseThrow(new Supplier(didTo){
            final /* synthetic */ String $didTo;
            {
                this.$didTo = $didTo;
            }

            public final Void get() {
                throw new DIDDocNotResolvedException(this.$didTo);
            }
        });
        if (DIDUtilsKt.isDIDFragment(from)) {
            Key sender2 = this.secretResolver.findKey(from).map(SenderKeySelector::findAuthCryptKeys$lambda-0).orElseThrow(new Supplier(from){
                final /* synthetic */ String $from;
                {
                    this.$from = $from;
                }

                public final Void get() {
                    throw new SecretNotFoundException(this.$from);
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)didDocTo2, (String)"didDocTo");
            Collection collection = this.findRecipientKeys(didDocTo2, to, sender2.getCurve());
            boolean bl3 = false;
            if (collection.isEmpty()) {
                boolean bl4 = false;
                throw new IncompatibleCryptoException("The recipient '" + to + "' curve is not compatible to '" + sender2.getCurve().getName() + '\'');
            }
            List recipients = (List)collection;
            pair = new Pair((Object)sender2, (Object)recipients);
        } else {
            Object v2;
            DIDDoc didDocFrom2;
            block5: {
                void $this$firstOrNull$iv;
                didDocFrom2 = this.didDocResolver.resolve(didFrom).orElseThrow(new Supplier(didFrom){
                    final /* synthetic */ String $didFrom;
                    {
                        this.$didFrom = $didFrom;
                    }

                    public final Void get() {
                        throw new DIDDocNotResolvedException(this.$didFrom);
                    }
                });
                Sequence sequence = SequencesKt.map((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)didDocFrom2.getKeyAgreements()), (Function1)((Function1)new Function1<String, Optional<Secret>>(this){
                    final /* synthetic */ SenderKeySelector this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final Optional<Secret> invoke(@NotNull String it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return SenderKeySelector.access$getSecretResolver$p(this.this$0).findKey(it);
                    }
                })), (Function1)findAuthCryptKeys.2.INSTANCE), (Function1)findAuthCryptKeys.3.INSTANCE), (Function1)findAuthCryptKeys.4.INSTANCE), (Function1)((Function1)new Function1<Key, Pair<? extends Key, ? extends List<? extends Key>>>(this, didDocTo2, to){
                    final /* synthetic */ SenderKeySelector this$0;
                    final /* synthetic */ DIDDoc $didDocTo;
                    final /* synthetic */ String $to;
                    {
                        this.this$0 = $receiver;
                        this.$didDocTo = $didDocTo;
                        this.$to = $to;
                        super(1);
                    }

                    @NotNull
                    public final Pair<Key, List<Key>> invoke(@NotNull Key it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        DIDDoc dIDDoc = this.$didDocTo;
                        Intrinsics.checkNotNullExpressionValue((Object)dIDDoc, (String)"didDocTo");
                        return new Pair((Object)it, (Object)SenderKeySelector.access$findRecipientKeys(this.this$0, dIDDoc, this.$to, it.getCurve()));
                    }
                }));
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Pair it = (Pair)element$iv;
                    boolean bl5 = false;
                    Collection collection = (Collection)it.getSecond();
                    boolean bl6 = false;
                    boolean bl7 = !collection.isEmpty();
                    if (!bl7) continue;
                    v2 = element$iv;
                    break block5;
                }
                v2 = null;
            }
            Pair pair2 = v2;
            if (pair2 == null) {
                throw new IncompatibleCryptoException("The DID Docs '" + didDocFrom2.getDid() + "' and '" + didDocTo2.getDid() + "' do not contain compatible 'keyAgreement' verification methods");
            }
            pair = pair2;
        }
        return pair;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Key> findAnonCryptKeys(@NotNull String to) {
        List list;
        List<String> list2;
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        List<String> list3 = list2 = DIDUtilsKt.divideDIDFragment(to);
        boolean bl = false;
        String did = list3.get(0);
        DIDDoc didDoc2 = this.didDocResolver.resolve(did).orElseThrow(new Supplier(did){
            final /* synthetic */ String $did;
            {
                this.$did = $did;
            }

            public final Void get() {
                throw new DIDDocNotResolvedException(this.$did);
            }
        });
        if (DIDUtilsKt.isDIDFragment(to)) {
            VerificationMethod method = didDoc2.findVerificationMethod(to);
            list = CollectionsKt.listOf((Object)Key.Companion.fromVerificationMethod(method));
        } else {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Object object;
            Object it;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Iterable iterable = didDoc2.getKeyAgreements();
            boolean $i$f$map = false;
            void var8_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                object = didDoc2.findVerificationMethod((String)it);
                collection.add(object);
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (VerificationMethod)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl3 = false;
                object = Key.Companion.fromVerificationMethod((VerificationMethod)it);
                collection.add(object);
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (Key)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl4 = false;
                object = it.getCurve();
                collection.add(object);
            }
            Curve selectedCurve = (Curve)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
            $this$map$iv = didDoc2.getKeyAgreements();
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl5 = false;
                object = didDoc2.findVerificationMethod((String)it);
                collection.add(object);
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (VerificationMethod)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl6 = false;
                object = Key.Companion.fromVerificationMethod((VerificationMethod)it);
                collection.add(object);
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Key)element$iv$iv;
                boolean bl7 = false;
                if (!Intrinsics.areEqual((Object)selectedCurve, (Object)it.getCurve())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            iterable = (List)destination$iv$iv;
            boolean bl8 = false;
            if (iterable.isEmpty()) {
                boolean bl9 = false;
                throw new DIDDocException("The DID Doc '" + didDoc2.getDid() + "' does not contain compatible 'keyAgreement' verification methods");
            }
            list = (List)iterable;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final List<Key> findRecipientKeys(DIDDoc didDoc2, String to, Curve curve) {
        List list;
        if (DIDUtilsKt.isDIDFragment(to)) {
            boolean bl;
            VerificationMethod method = didDoc2.findVerificationMethod(to);
            Key key = Key.Companion.fromVerificationMethod(method);
            boolean bl2 = bl = !Intrinsics.areEqual((Object)curve, (Object)key.getCurve());
            if (bl) {
                boolean bl3 = false;
                list = CollectionsKt.emptyList();
                return list;
            } else {
                if (bl) throw new NoWhenBranchMatchedException();
                list = CollectionsKt.listOf((Object)key);
            }
            return list;
        } else {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Object object;
            Object it;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Iterable method = didDoc2.getKeyAgreements();
            boolean $i$f$map = false;
            void var6_9 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                object = didDoc2.findVerificationMethod((String)it);
                collection.add(object);
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (VerificationMethod)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                object = Key.Companion.fromVerificationMethod((VerificationMethod)it);
                collection.add(object);
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Key)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)curve, (Object)it.getCurve())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    private static final Key findAuthCryptKeys$lambda-0(Secret it) {
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return Key.Companion.fromSecret(it);
    }

    public static final /* synthetic */ SecretResolver access$getSecretResolver$p(SenderKeySelector $this) {
        return $this.secretResolver;
    }

    public static final /* synthetic */ List access$findRecipientKeys(SenderKeySelector $this, DIDDoc didDoc2, String to, Curve curve) {
        return $this.findRecipientKeys(didDoc2, to, curve);
    }
}

