/*
 * Decompiled with CFR 0.152.
 */
package org.didcommx.didcomm.diddoc;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.didcommx.didcomm.diddoc.DIDCommService;
import org.didcommx.didcomm.diddoc.VerificationMethod;
import org.didcommx.didcomm.exceptions.DIDDocException;
import org.didcommx.didcomm.exceptions.DIDUrlNotFoundException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J\u000f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u0005H\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\n0\u0005H\u00c6\u0003JS\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u000e\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u0003J\u000e\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u0003J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J\t\u0010!\u001a\u00020\u0003H\u00d6\u0001R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\r\u00a8\u0006\""}, d2={"Lorg/didcommx/didcomm/diddoc/DIDDoc;", "", "did", "", "keyAgreements", "", "authentications", "verificationMethods", "Lorg/didcommx/didcomm/diddoc/VerificationMethod;", "didCommServices", "Lorg/didcommx/didcomm/diddoc/DIDCommService;", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getAuthentications", "()Ljava/util/List;", "getDid", "()Ljava/lang/String;", "getDidCommServices", "getKeyAgreements", "getVerificationMethods", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "findDIDCommService", "id", "findVerificationMethod", "hashCode", "", "toString", "didcomm"})
public final class DIDDoc {
    @NotNull
    private final String did;
    @NotNull
    private final List<String> keyAgreements;
    @NotNull
    private final List<String> authentications;
    @NotNull
    private final List<VerificationMethod> verificationMethods;
    @NotNull
    private final List<DIDCommService> didCommServices;

    public DIDDoc(@NotNull String did, @NotNull List<String> keyAgreements, @NotNull List<String> authentications, @NotNull List<VerificationMethod> verificationMethods, @NotNull List<DIDCommService> didCommServices) {
        Intrinsics.checkNotNullParameter((Object)did, (String)"did");
        Intrinsics.checkNotNullParameter(keyAgreements, (String)"keyAgreements");
        Intrinsics.checkNotNullParameter(authentications, (String)"authentications");
        Intrinsics.checkNotNullParameter(verificationMethods, (String)"verificationMethods");
        Intrinsics.checkNotNullParameter(didCommServices, (String)"didCommServices");
        this.did = did;
        this.keyAgreements = keyAgreements;
        this.authentications = authentications;
        this.verificationMethods = verificationMethods;
        this.didCommServices = didCommServices;
    }

    @NotNull
    public final String getDid() {
        return this.did;
    }

    @NotNull
    public final List<String> getKeyAgreements() {
        return this.keyAgreements;
    }

    @NotNull
    public final List<String> getAuthentications() {
        return this.authentications;
    }

    @NotNull
    public final List<VerificationMethod> getVerificationMethods() {
        return this.verificationMethods;
    }

    @NotNull
    public final List<DIDCommService> getDidCommServices() {
        return this.didCommServices;
    }

    @NotNull
    public final VerificationMethod findVerificationMethod(@NotNull String id) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Iterable iterable = this.verificationMethods;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                VerificationMethod it = (VerificationMethod)t;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)id)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        VerificationMethod verificationMethod = v0;
        if (verificationMethod == null) {
            throw new DIDUrlNotFoundException(id, this.did);
        }
        return verificationMethod;
    }

    @NotNull
    public final DIDCommService findDIDCommService(@NotNull String id) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Iterable iterable = this.didCommServices;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                DIDCommService it = (DIDCommService)t;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)id)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        DIDCommService dIDCommService = v0;
        if (dIDCommService == null) {
            throw new DIDDocException("DIDComm service '" + id + "' not found in DID Doc '" + this.did + '\'');
        }
        return dIDCommService;
    }

    @NotNull
    public final String component1() {
        return this.did;
    }

    @NotNull
    public final List<String> component2() {
        return this.keyAgreements;
    }

    @NotNull
    public final List<String> component3() {
        return this.authentications;
    }

    @NotNull
    public final List<VerificationMethod> component4() {
        return this.verificationMethods;
    }

    @NotNull
    public final List<DIDCommService> component5() {
        return this.didCommServices;
    }

    @NotNull
    public final DIDDoc copy(@NotNull String did, @NotNull List<String> keyAgreements, @NotNull List<String> authentications, @NotNull List<VerificationMethod> verificationMethods, @NotNull List<DIDCommService> didCommServices) {
        Intrinsics.checkNotNullParameter((Object)did, (String)"did");
        Intrinsics.checkNotNullParameter(keyAgreements, (String)"keyAgreements");
        Intrinsics.checkNotNullParameter(authentications, (String)"authentications");
        Intrinsics.checkNotNullParameter(verificationMethods, (String)"verificationMethods");
        Intrinsics.checkNotNullParameter(didCommServices, (String)"didCommServices");
        return new DIDDoc(did, keyAgreements, authentications, verificationMethods, didCommServices);
    }

    public static /* synthetic */ DIDDoc copy$default(DIDDoc dIDDoc, String string, List list, List list2, List list3, List list4, int n, Object object) {
        if ((n & 1) != 0) {
            string = dIDDoc.did;
        }
        if ((n & 2) != 0) {
            list = dIDDoc.keyAgreements;
        }
        if ((n & 4) != 0) {
            list2 = dIDDoc.authentications;
        }
        if ((n & 8) != 0) {
            list3 = dIDDoc.verificationMethods;
        }
        if ((n & 0x10) != 0) {
            list4 = dIDDoc.didCommServices;
        }
        return dIDDoc.copy(string, list, list2, list3, list4);
    }

    @NotNull
    public String toString() {
        return "DIDDoc(did=" + this.did + ", keyAgreements=" + this.keyAgreements + ", authentications=" + this.authentications + ", verificationMethods=" + this.verificationMethods + ", didCommServices=" + this.didCommServices + ')';
    }

    public int hashCode() {
        int result = this.did.hashCode();
        result = result * 31 + ((Object)this.keyAgreements).hashCode();
        result = result * 31 + ((Object)this.authentications).hashCode();
        result = result * 31 + ((Object)this.verificationMethods).hashCode();
        result = result * 31 + ((Object)this.didCommServices).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DIDDoc)) {
            return false;
        }
        DIDDoc dIDDoc = (DIDDoc)other;
        if (!Intrinsics.areEqual((Object)this.did, (Object)dIDDoc.did)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.keyAgreements, dIDDoc.keyAgreements)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.authentications, dIDDoc.authentications)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.verificationMethods, dIDDoc.verificationMethods)) {
            return false;
        }
        return Intrinsics.areEqual(this.didCommServices, dIDDoc.didCommServices);
    }
}

