/*
 * Decompiled with CFR 0.152.
 */
package org.didcommx.didcomm.model;

import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.didcommx.didcomm.common.AnonCryptAlg;
import org.didcommx.didcomm.common.AuthCryptAlg;
import org.didcommx.didcomm.diddoc.DIDDocResolver;
import org.didcommx.didcomm.exceptions.DIDCommIllegalArgumentException;
import org.didcommx.didcomm.message.Message;
import org.didcommx.didcomm.secret.SecretResolver;
import org.didcommx.didcomm.utils.DIDUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b'\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\b\u0018\u0000 D2\u00020\u0001:\u0002CDB\u000f\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0087\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\b\u0012\b\u0010\n\u001a\u0004\u0018\u00010\b\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0011\u0012\u0014\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0014\u0012\b\u0010\u0015\u001a\u0004\u0018\u00010\b\u0012\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017\u0012\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019\u00a2\u0006\u0002\u0010\u001aJ\t\u00100\u001a\u00020\u0006H\u00c6\u0003J\u0017\u00101\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0014H\u00c6\u0003J\u000b\u00102\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\u000b\u00103\u001a\u0004\u0018\u00010\u0017H\u00c6\u0003J\u000b\u00104\u001a\u0004\u0018\u00010\u0019H\u00c6\u0003J\t\u00105\u001a\u00020\bH\u00c6\u0003J\u000b\u00106\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\u000b\u00107\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\u000b\u00108\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\t\u00109\u001a\u00020\rH\u00c6\u0003J\t\u0010:\u001a\u00020\u000fH\u00c6\u0003J\t\u0010;\u001a\u00020\u0011H\u00c6\u0003J\t\u0010<\u001a\u00020\u0011H\u00c6\u0003J\u00a5\u0001\u0010=\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u00112\u0016\b\u0002\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u00142\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u00172\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u00c6\u0001J\u0013\u0010>\u001a\u00020\u00112\b\u0010?\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010@\u001a\u00020AH\u00d6\u0001J\t\u0010B\u001a\u00020\bH\u00d6\u0001R\u0013\u0010\u0016\u001a\u0004\u0018\u00010\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u001f\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0013\u0010\u0015\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0013\u0010\t\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010&R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010&R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\"R\u0013\u0010\u0018\u001a\u0004\u0018\u00010\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0013\u0010\n\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010&R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010&\u00a8\u0006E"}, d2={"Lorg/didcommx/didcomm/model/PackEncryptedParams;", "", "builder", "Lorg/didcommx/didcomm/model/PackEncryptedParams$Builder;", "(Lorg/didcommx/didcomm/model/PackEncryptedParams$Builder;)V", "message", "Lorg/didcommx/didcomm/message/Message;", "to", "", "from", "signFrom", "fromPriorIssuerKid", "encAlgAuth", "Lorg/didcommx/didcomm/common/AuthCryptAlg;", "encAlgAnon", "Lorg/didcommx/didcomm/common/AnonCryptAlg;", "protectSenderId", "", "forward", "forwardHeaders", "", "forwardServiceId", "didDocResolver", "Lorg/didcommx/didcomm/diddoc/DIDDocResolver;", "secretResolver", "Lorg/didcommx/didcomm/secret/SecretResolver;", "(Lorg/didcommx/didcomm/message/Message;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lorg/didcommx/didcomm/common/AuthCryptAlg;Lorg/didcommx/didcomm/common/AnonCryptAlg;ZZLjava/util/Map;Ljava/lang/String;Lorg/didcommx/didcomm/diddoc/DIDDocResolver;Lorg/didcommx/didcomm/secret/SecretResolver;)V", "getDidDocResolver", "()Lorg/didcommx/didcomm/diddoc/DIDDocResolver;", "getEncAlgAnon", "()Lorg/didcommx/didcomm/common/AnonCryptAlg;", "getEncAlgAuth", "()Lorg/didcommx/didcomm/common/AuthCryptAlg;", "getForward", "()Z", "getForwardHeaders", "()Ljava/util/Map;", "getForwardServiceId", "()Ljava/lang/String;", "getFrom", "getFromPriorIssuerKid", "getMessage", "()Lorg/didcommx/didcomm/message/Message;", "getProtectSenderId", "getSecretResolver", "()Lorg/didcommx/didcomm/secret/SecretResolver;", "getSignFrom", "getTo", "component1", "component10", "component11", "component12", "component13", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "other", "hashCode", "", "toString", "Builder", "Companion", "didcomm"})
public final class PackEncryptedParams {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Message message;
    @NotNull
    private final String to;
    @Nullable
    private final String from;
    @Nullable
    private final String signFrom;
    @Nullable
    private final String fromPriorIssuerKid;
    @NotNull
    private final AuthCryptAlg encAlgAuth;
    @NotNull
    private final AnonCryptAlg encAlgAnon;
    private final boolean protectSenderId;
    private final boolean forward;
    @Nullable
    private final Map<String, Object> forwardHeaders;
    @Nullable
    private final String forwardServiceId;
    @Nullable
    private final DIDDocResolver didDocResolver;
    @Nullable
    private final SecretResolver secretResolver;

    public PackEncryptedParams(@NotNull Message message, @NotNull String to, @Nullable String from, @Nullable String signFrom, @Nullable String fromPriorIssuerKid, @NotNull AuthCryptAlg encAlgAuth, @NotNull AnonCryptAlg encAlgAnon, boolean protectSenderId, boolean forward, @Nullable Map<String, ? extends Object> forwardHeaders, @Nullable String forwardServiceId, @Nullable DIDDocResolver didDocResolver, @Nullable SecretResolver secretResolver) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Intrinsics.checkNotNullParameter((Object)encAlgAuth, (String)"encAlgAuth");
        Intrinsics.checkNotNullParameter((Object)encAlgAnon, (String)"encAlgAnon");
        this.message = message;
        this.to = to;
        this.from = from;
        this.signFrom = signFrom;
        this.fromPriorIssuerKid = fromPriorIssuerKid;
        this.encAlgAuth = encAlgAuth;
        this.encAlgAnon = encAlgAnon;
        this.protectSenderId = protectSenderId;
        this.forward = forward;
        this.forwardHeaders = forwardHeaders;
        this.forwardServiceId = forwardServiceId;
        this.didDocResolver = didDocResolver;
        this.secretResolver = secretResolver;
    }

    @NotNull
    public final Message getMessage() {
        return this.message;
    }

    @NotNull
    public final String getTo() {
        return this.to;
    }

    @Nullable
    public final String getFrom() {
        return this.from;
    }

    @Nullable
    public final String getSignFrom() {
        return this.signFrom;
    }

    @Nullable
    public final String getFromPriorIssuerKid() {
        return this.fromPriorIssuerKid;
    }

    @NotNull
    public final AuthCryptAlg getEncAlgAuth() {
        return this.encAlgAuth;
    }

    @NotNull
    public final AnonCryptAlg getEncAlgAnon() {
        return this.encAlgAnon;
    }

    public final boolean getProtectSenderId() {
        return this.protectSenderId;
    }

    public final boolean getForward() {
        return this.forward;
    }

    @Nullable
    public final Map<String, Object> getForwardHeaders() {
        return this.forwardHeaders;
    }

    @Nullable
    public final String getForwardServiceId() {
        return this.forwardServiceId;
    }

    @Nullable
    public final DIDDocResolver getDidDocResolver() {
        return this.didDocResolver;
    }

    @Nullable
    public final SecretResolver getSecretResolver() {
        return this.secretResolver;
    }

    private PackEncryptedParams(Builder builder) {
        this(builder.getMessage(), builder.getTo(), builder.getFrom$didcomm(), builder.getSignFrom$didcomm(), builder.getFromPriorIssuerKid$didcomm(), builder.getEncAlgAuth$didcomm(), builder.getEncAlgAnon$didcomm(), builder.getProtectSenderId$didcomm(), builder.getForward$didcomm(), builder.getForwardHeaders$didcomm(), builder.getForwardServiceId$didcomm(), builder.getDidDocResolver$didcomm(), builder.getSecretResolver$didcomm());
    }

    @NotNull
    public final Message component1() {
        return this.message;
    }

    @NotNull
    public final String component2() {
        return this.to;
    }

    @Nullable
    public final String component3() {
        return this.from;
    }

    @Nullable
    public final String component4() {
        return this.signFrom;
    }

    @Nullable
    public final String component5() {
        return this.fromPriorIssuerKid;
    }

    @NotNull
    public final AuthCryptAlg component6() {
        return this.encAlgAuth;
    }

    @NotNull
    public final AnonCryptAlg component7() {
        return this.encAlgAnon;
    }

    public final boolean component8() {
        return this.protectSenderId;
    }

    public final boolean component9() {
        return this.forward;
    }

    @Nullable
    public final Map<String, Object> component10() {
        return this.forwardHeaders;
    }

    @Nullable
    public final String component11() {
        return this.forwardServiceId;
    }

    @Nullable
    public final DIDDocResolver component12() {
        return this.didDocResolver;
    }

    @Nullable
    public final SecretResolver component13() {
        return this.secretResolver;
    }

    @NotNull
    public final PackEncryptedParams copy(@NotNull Message message, @NotNull String to, @Nullable String from, @Nullable String signFrom, @Nullable String fromPriorIssuerKid, @NotNull AuthCryptAlg encAlgAuth, @NotNull AnonCryptAlg encAlgAnon, boolean protectSenderId, boolean forward, @Nullable Map<String, ? extends Object> forwardHeaders, @Nullable String forwardServiceId, @Nullable DIDDocResolver didDocResolver, @Nullable SecretResolver secretResolver) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Intrinsics.checkNotNullParameter((Object)encAlgAuth, (String)"encAlgAuth");
        Intrinsics.checkNotNullParameter((Object)encAlgAnon, (String)"encAlgAnon");
        return new PackEncryptedParams(message, to, from, signFrom, fromPriorIssuerKid, encAlgAuth, encAlgAnon, protectSenderId, forward, forwardHeaders, forwardServiceId, didDocResolver, secretResolver);
    }

    public static /* synthetic */ PackEncryptedParams copy$default(PackEncryptedParams packEncryptedParams, Message message, String string, String string2, String string3, String string4, AuthCryptAlg authCryptAlg, AnonCryptAlg anonCryptAlg, boolean bl, boolean bl2, Map map, String string5, DIDDocResolver dIDDocResolver, SecretResolver secretResolver, int n, Object object) {
        if ((n & 1) != 0) {
            message = packEncryptedParams.message;
        }
        if ((n & 2) != 0) {
            string = packEncryptedParams.to;
        }
        if ((n & 4) != 0) {
            string2 = packEncryptedParams.from;
        }
        if ((n & 8) != 0) {
            string3 = packEncryptedParams.signFrom;
        }
        if ((n & 0x10) != 0) {
            string4 = packEncryptedParams.fromPriorIssuerKid;
        }
        if ((n & 0x20) != 0) {
            authCryptAlg = packEncryptedParams.encAlgAuth;
        }
        if ((n & 0x40) != 0) {
            anonCryptAlg = packEncryptedParams.encAlgAnon;
        }
        if ((n & 0x80) != 0) {
            bl = packEncryptedParams.protectSenderId;
        }
        if ((n & 0x100) != 0) {
            bl2 = packEncryptedParams.forward;
        }
        if ((n & 0x200) != 0) {
            map = packEncryptedParams.forwardHeaders;
        }
        if ((n & 0x400) != 0) {
            string5 = packEncryptedParams.forwardServiceId;
        }
        if ((n & 0x800) != 0) {
            dIDDocResolver = packEncryptedParams.didDocResolver;
        }
        if ((n & 0x1000) != 0) {
            secretResolver = packEncryptedParams.secretResolver;
        }
        return packEncryptedParams.copy(message, string, string2, string3, string4, authCryptAlg, anonCryptAlg, bl, bl2, map, string5, dIDDocResolver, secretResolver);
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("PackEncryptedParams(message=").append(this.message).append(", to=").append(this.to).append(", from=").append((Object)this.from).append(", signFrom=").append((Object)this.signFrom).append(", fromPriorIssuerKid=").append((Object)this.fromPriorIssuerKid).append(", encAlgAuth=").append(this.encAlgAuth).append(", encAlgAnon=").append(this.encAlgAnon).append(", protectSenderId=").append(this.protectSenderId).append(", forward=").append(this.forward).append(", forwardHeaders=").append(this.forwardHeaders).append(", forwardServiceId=").append((Object)this.forwardServiceId).append(", didDocResolver=");
        stringBuilder.append(this.didDocResolver).append(", secretResolver=").append(this.secretResolver).append(')');
        return stringBuilder.toString();
    }

    public int hashCode() {
        int result = this.message.hashCode();
        result = result * 31 + this.to.hashCode();
        result = result * 31 + (this.from == null ? 0 : this.from.hashCode());
        result = result * 31 + (this.signFrom == null ? 0 : this.signFrom.hashCode());
        result = result * 31 + (this.fromPriorIssuerKid == null ? 0 : this.fromPriorIssuerKid.hashCode());
        result = result * 31 + this.encAlgAuth.hashCode();
        result = result * 31 + this.encAlgAnon.hashCode();
        int n = this.protectSenderId ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        result = result * 31 + n;
        int n2 = this.forward ? 1 : 0;
        if (n2 != 0) {
            n2 = 1;
        }
        result = result * 31 + n2;
        result = result * 31 + (this.forwardHeaders == null ? 0 : ((Object)this.forwardHeaders).hashCode());
        result = result * 31 + (this.forwardServiceId == null ? 0 : this.forwardServiceId.hashCode());
        result = result * 31 + (this.didDocResolver == null ? 0 : this.didDocResolver.hashCode());
        result = result * 31 + (this.secretResolver == null ? 0 : this.secretResolver.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PackEncryptedParams)) {
            return false;
        }
        PackEncryptedParams packEncryptedParams = (PackEncryptedParams)other;
        if (!Intrinsics.areEqual((Object)this.message, (Object)packEncryptedParams.message)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.to, (Object)packEncryptedParams.to)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.from, (Object)packEncryptedParams.from)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.signFrom, (Object)packEncryptedParams.signFrom)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.fromPriorIssuerKid, (Object)packEncryptedParams.fromPriorIssuerKid)) {
            return false;
        }
        if (this.encAlgAuth != packEncryptedParams.encAlgAuth) {
            return false;
        }
        if (this.encAlgAnon != packEncryptedParams.encAlgAnon) {
            return false;
        }
        if (this.protectSenderId != packEncryptedParams.protectSenderId) {
            return false;
        }
        if (this.forward != packEncryptedParams.forward) {
            return false;
        }
        if (!Intrinsics.areEqual(this.forwardHeaders, packEncryptedParams.forwardHeaders)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.forwardServiceId, (Object)packEncryptedParams.forwardServiceId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.didDocResolver, (Object)packEncryptedParams.didDocResolver)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.secretResolver, (Object)packEncryptedParams.secretResolver);
    }

    public /* synthetic */ PackEncryptedParams(Builder builder, DefaultConstructorMarker $constructor_marker) {
        this(builder);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lorg/didcommx/didcomm/model/PackEncryptedParams$Companion;", "", "()V", "builder", "Lorg/didcommx/didcomm/model/PackEncryptedParams$Builder;", "message", "Lorg/didcommx/didcomm/message/Message;", "to", "", "didcomm"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Builder builder(@NotNull Message message, @NotNull String to) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)to, (String)"to");
            return new Builder(message, to);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010.\u001a\u00020/J\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\bJ\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\fJ\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0010J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0014J\u001a\u0010\u0019\u001a\u00020\u00002\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0018J\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0005J\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u0005J\u000e\u0010!\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u0005J\u000e\u0010%\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u0014J\u000e\u0010(\u001a\u00020\u00002\u0006\u0010(\u001a\u00020'J\u000e\u0010+\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u0005R\"\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\u0007\u001a\u0004\u0018\u00010\b@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\r\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\f@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\u0010@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001e\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\u0014@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R:\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u00182\u0014\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0018@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\"\u0010\u001c\u001a\u0004\u0018\u00010\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\"\u0010\u001f\u001a\u0004\u0018\u00010\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001eR\"\u0010!\u001a\u0004\u0018\u00010\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u001eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u001e\u0010%\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\u0014@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0017R\"\u0010(\u001a\u0004\u0018\u00010'2\b\u0010\u0007\u001a\u0004\u0018\u00010'@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\"\u0010+\u001a\u0004\u0018\u00010\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\u001eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\u001e\u00a8\u00060"}, d2={"Lorg/didcommx/didcomm/model/PackEncryptedParams$Builder;", "", "message", "Lorg/didcommx/didcomm/message/Message;", "to", "", "(Lorg/didcommx/didcomm/message/Message;Ljava/lang/String;)V", "<set-?>", "Lorg/didcommx/didcomm/diddoc/DIDDocResolver;", "didDocResolver", "getDidDocResolver$didcomm", "()Lorg/didcommx/didcomm/diddoc/DIDDocResolver;", "Lorg/didcommx/didcomm/common/AnonCryptAlg;", "encAlgAnon", "getEncAlgAnon$didcomm", "()Lorg/didcommx/didcomm/common/AnonCryptAlg;", "Lorg/didcommx/didcomm/common/AuthCryptAlg;", "encAlgAuth", "getEncAlgAuth$didcomm", "()Lorg/didcommx/didcomm/common/AuthCryptAlg;", "", "forward", "getForward$didcomm", "()Z", "", "forwardHeaders", "getForwardHeaders$didcomm", "()Ljava/util/Map;", "forwardServiceId", "getForwardServiceId$didcomm", "()Ljava/lang/String;", "from", "getFrom$didcomm", "fromPriorIssuerKid", "getFromPriorIssuerKid$didcomm", "getMessage", "()Lorg/didcommx/didcomm/message/Message;", "protectSenderId", "getProtectSenderId$didcomm", "Lorg/didcommx/didcomm/secret/SecretResolver;", "secretResolver", "getSecretResolver$didcomm", "()Lorg/didcommx/didcomm/secret/SecretResolver;", "signFrom", "getSignFrom$didcomm", "getTo", "build", "Lorg/didcommx/didcomm/model/PackEncryptedParams;", "didcomm"})
    public static final class Builder {
        @NotNull
        private final Message message;
        @NotNull
        private final String to;
        @Nullable
        private String from;
        @Nullable
        private String signFrom;
        @Nullable
        private String fromPriorIssuerKid;
        @Nullable
        private DIDDocResolver didDocResolver;
        @Nullable
        private SecretResolver secretResolver;
        @NotNull
        private AuthCryptAlg encAlgAuth;
        @NotNull
        private AnonCryptAlg encAlgAnon;
        private boolean protectSenderId;
        private boolean forward;
        @Nullable
        private Map<String, ? extends Object> forwardHeaders;
        @Nullable
        private String forwardServiceId;

        public Builder(@NotNull Message message, @NotNull String to) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)to, (String)"to");
            this.message = message;
            this.to = to;
            this.encAlgAuth = AuthCryptAlg.A256CBC_HS512_ECDH_1PU_A256KW;
            this.encAlgAnon = AnonCryptAlg.XC20P_ECDH_ES_A256KW;
            this.forward = true;
        }

        @NotNull
        public final Message getMessage() {
            return this.message;
        }

        @NotNull
        public final String getTo() {
            return this.to;
        }

        @Nullable
        public final String getFrom$didcomm() {
            return this.from;
        }

        @Nullable
        public final String getSignFrom$didcomm() {
            return this.signFrom;
        }

        @Nullable
        public final String getFromPriorIssuerKid$didcomm() {
            return this.fromPriorIssuerKid;
        }

        @Nullable
        public final DIDDocResolver getDidDocResolver$didcomm() {
            return this.didDocResolver;
        }

        @Nullable
        public final SecretResolver getSecretResolver$didcomm() {
            return this.secretResolver;
        }

        @NotNull
        public final AuthCryptAlg getEncAlgAuth$didcomm() {
            return this.encAlgAuth;
        }

        @NotNull
        public final AnonCryptAlg getEncAlgAnon$didcomm() {
            return this.encAlgAnon;
        }

        public final boolean getProtectSenderId$didcomm() {
            return this.protectSenderId;
        }

        public final boolean getForward$didcomm() {
            return this.forward;
        }

        @Nullable
        public final Map<String, Object> getForwardHeaders$didcomm() {
            return this.forwardHeaders;
        }

        @Nullable
        public final String getForwardServiceId$didcomm() {
            return this.forwardServiceId;
        }

        @NotNull
        public final Builder signFrom(@NotNull String signFrom) {
            Intrinsics.checkNotNullParameter((Object)signFrom, (String)"signFrom");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$signFrom_u24lambda_u2d0 = builder;
            boolean bl3 = false;
            $this$signFrom_u24lambda_u2d0.signFrom = signFrom;
            return builder;
        }

        @NotNull
        public final Builder fromPriorIssuerKid(@NotNull String fromPriorIssuerKid) {
            Intrinsics.checkNotNullParameter((Object)fromPriorIssuerKid, (String)"fromPriorIssuerKid");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$fromPriorIssuerKid_u24lambda_u2d1 = builder;
            boolean bl3 = false;
            $this$fromPriorIssuerKid_u24lambda_u2d1.fromPriorIssuerKid = fromPriorIssuerKid;
            return builder;
        }

        @NotNull
        public final Builder didDocResolver(@NotNull DIDDocResolver didDocResolver) {
            Intrinsics.checkNotNullParameter((Object)didDocResolver, (String)"didDocResolver");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$didDocResolver_u24lambda_u2d2 = builder;
            boolean bl3 = false;
            $this$didDocResolver_u24lambda_u2d2.didDocResolver = didDocResolver;
            return builder;
        }

        @NotNull
        public final Builder secretResolver(@NotNull SecretResolver secretResolver) {
            Intrinsics.checkNotNullParameter((Object)secretResolver, (String)"secretResolver");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$secretResolver_u24lambda_u2d3 = builder;
            boolean bl3 = false;
            $this$secretResolver_u24lambda_u2d3.secretResolver = secretResolver;
            return builder;
        }

        @NotNull
        public final Builder from(@NotNull String from) {
            Intrinsics.checkNotNullParameter((Object)from, (String)"from");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$from_u24lambda_u2d4 = builder;
            boolean bl3 = false;
            $this$from_u24lambda_u2d4.from = from;
            return builder;
        }

        @NotNull
        public final Builder encAlgAuth(@NotNull AuthCryptAlg encAlgAuth) {
            Intrinsics.checkNotNullParameter((Object)encAlgAuth, (String)"encAlgAuth");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$encAlgAuth_u24lambda_u2d5 = builder;
            boolean bl3 = false;
            $this$encAlgAuth_u24lambda_u2d5.encAlgAuth = encAlgAuth;
            return builder;
        }

        @NotNull
        public final Builder encAlgAnon(@NotNull AnonCryptAlg encAlgAnon) {
            Intrinsics.checkNotNullParameter((Object)encAlgAnon, (String)"encAlgAnon");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$encAlgAnon_u24lambda_u2d6 = builder;
            boolean bl3 = false;
            $this$encAlgAnon_u24lambda_u2d6.encAlgAnon = encAlgAnon;
            return builder;
        }

        @NotNull
        public final Builder protectSenderId(boolean protectSenderId) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$protectSenderId_u24lambda_u2d7 = builder;
            boolean bl3 = false;
            $this$protectSenderId_u24lambda_u2d7.protectSenderId = protectSenderId;
            return builder;
        }

        @NotNull
        public final Builder forward(boolean forward) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$forward_u24lambda_u2d8 = builder;
            boolean bl3 = false;
            $this$forward_u24lambda_u2d8.forward = forward;
            return builder;
        }

        @NotNull
        public final Builder forwardHeaders(@NotNull Map<String, ? extends Object> forwardHeaders) {
            Intrinsics.checkNotNullParameter(forwardHeaders, (String)"forwardHeaders");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$forwardHeaders_u24lambda_u2d9 = builder;
            boolean bl3 = false;
            $this$forwardHeaders_u24lambda_u2d9.forwardHeaders = forwardHeaders;
            return builder;
        }

        @NotNull
        public final Builder forwardServiceId(@NotNull String forwardServiceId) {
            Intrinsics.checkNotNullParameter((Object)forwardServiceId, (String)"forwardServiceId");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$forwardServiceId_u24lambda_u2d10 = builder;
            boolean bl3 = false;
            $this$forwardServiceId_u24lambda_u2d10.forwardServiceId = forwardServiceId;
            return builder;
        }

        @NotNull
        public final PackEncryptedParams build() {
            String from = this.from;
            String to = this.to;
            String signFrom = this.signFrom;
            String fromPriorIssuerKid = this.fromPriorIssuerKid;
            if (!DIDUtilsKt.isDID(to)) {
                throw new DIDCommIllegalArgumentException(to);
            }
            if (from != null && !DIDUtilsKt.isDID(from)) {
                throw new DIDCommIllegalArgumentException(from);
            }
            if (signFrom != null && !DIDUtilsKt.isDID(signFrom)) {
                throw new DIDCommIllegalArgumentException(signFrom);
            }
            if (this.message.getTo() != null && !this.message.getTo().contains(CollectionsKt.first(DIDUtilsKt.divideDIDFragment(to)))) {
                throw new DIDCommIllegalArgumentException(to);
            }
            if (from != null && this.message.getFrom() != null && !Intrinsics.areEqual((Object)this.message.getFrom(), (Object)CollectionsKt.first(DIDUtilsKt.divideDIDFragment(from)))) {
                throw new DIDCommIllegalArgumentException(from);
            }
            if (!(fromPriorIssuerKid == null || DIDUtilsKt.isDID(fromPriorIssuerKid) && DIDUtilsKt.isDIDFragment(fromPriorIssuerKid))) {
                throw new DIDCommIllegalArgumentException(fromPriorIssuerKid);
            }
            if (this.message.getFromPrior() != null) {
                if (Intrinsics.areEqual((Object)this.message.getFromPrior().getSub(), (Object)this.message.getFromPrior().getIss())) {
                    throw new DIDCommIllegalArgumentException(this.message.getFromPrior().getSub());
                }
                if (this.message.getFrom() != null && !Intrinsics.areEqual((Object)this.message.getFromPrior().getSub(), (Object)this.message.getFrom())) {
                    throw new DIDCommIllegalArgumentException(this.message.getFromPrior().getSub());
                }
                if (fromPriorIssuerKid != null && !Intrinsics.areEqual((Object)CollectionsKt.first(DIDUtilsKt.divideDIDFragment(fromPriorIssuerKid)), (Object)this.message.getFromPrior().getIss())) {
                    throw new DIDCommIllegalArgumentException(fromPriorIssuerKid);
                }
            }
            return new PackEncryptedParams(this, null);
        }
    }
}

