/*
 * Decompiled with CFR 0.152.
 */
package org.didcommx.didcomm.operations;

import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jwt.JWTClaimsSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.didcommx.didcomm.crypto.JWTKt;
import org.didcommx.didcomm.crypto.key.Key;
import org.didcommx.didcomm.crypto.key.RecipientKeySelector;
import org.didcommx.didcomm.crypto.key.SenderKeySelector;
import org.didcommx.didcomm.exceptions.MalformedMessageException;
import org.didcommx.didcomm.message.FromPrior;
import org.didcommx.didcomm.message.Message;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0002\u001a.\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\u00012\u0006\u0010\b\u001a\u00020\t\u001a$\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"extractFromPriorKid", "", "fromPriorJwt", "packFromPrior", "Lkotlin/Pair;", "Lorg/didcommx/didcomm/message/Message;", "message", "fromPriorIssuerKid", "keySelector", "Lorg/didcommx/didcomm/crypto/key/SenderKeySelector;", "unpackFromPrior", "Lorg/didcommx/didcomm/crypto/key/RecipientKeySelector;", "didcomm"})
public final class FromPriorKt {
    @NotNull
    public static final Pair<Message, String> packFromPrior(@NotNull Message message, @Nullable String fromPriorIssuerKid, @NotNull SenderKeySelector keySelector) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)keySelector, (String)"keySelector");
        FromPrior fromPrior = message.getFromPrior();
        if (fromPrior == null) {
            pair = null;
        } else {
            FromPrior fromPrior2 = fromPrior;
            boolean bl = false;
            boolean bl2 = false;
            FromPrior it = fromPrior2;
            boolean bl3 = false;
            String string = fromPriorIssuerKid;
            Key key = keySelector.findSigningKey(string == null ? it.getIss() : string);
            JWTClaimsSet jWTClaimsSet = JWTClaimsSet.parse(it.toJSONObject());
            Intrinsics.checkNotNullExpressionValue((Object)jWTClaimsSet, (String)"parse(it.toJSONObject())");
            Message updatedMessage = Message.copy$default(message, null, null, null, null, null, null, null, null, null, JWTKt.signJwt(jWTClaimsSet, key), null, null, null, null, null, null, 64767, null);
            pair = new Pair((Object)updatedMessage, (Object)key.getId());
        }
        Pair pair2 = pair;
        return pair2 == null ? new Pair((Object)message, null) : pair2;
    }

    @NotNull
    public static final Pair<Message, String> unpackFromPrior(@NotNull Message message, @NotNull RecipientKeySelector keySelector) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)keySelector, (String)"keySelector");
        String string = message.getFromPriorJwt();
        if (string == null) {
            pair = null;
        } else {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            String issKid = FromPriorKt.extractFromPriorKid(it);
            Key key = keySelector.findVerificationKey(issKid);
            Message updatedMessage = Message.copy$default(message, null, null, null, null, null, null, null, null, FromPrior.Companion.parse(JWTKt.verifyJwt(it, key).toJSONObject()), null, null, null, null, null, null, null, 64767, null);
            pair = new Pair((Object)updatedMessage, (Object)key.getId());
        }
        Pair pair2 = pair;
        return pair2 == null ? new Pair((Object)message, null) : pair2;
    }

    private static final String extractFromPriorKid(String fromPriorJwt) {
        String[] stringArray = new String[]{"."};
        List segments = StringsKt.split$default((CharSequence)fromPriorJwt, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (segments.size() != 3) {
            throw new MalformedMessageException("JWT cannot be deserialized", null, 2, null);
        }
        JWSHeader jwsHeader = JWSHeader.parse(new Base64URL((String)segments.get(0)));
        String string = jwsHeader.getKeyID();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jwsHeader.keyID");
        return string;
    }
}

