/*
 * Decompiled with CFR 0.152.
 */
package org.didcommx.didcomm.operations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.didcommx.didcomm.crypto.EncryptResult;
import org.didcommx.didcomm.crypto.JWEKt;
import org.didcommx.didcomm.crypto.JWSKt;
import org.didcommx.didcomm.crypto.key.Key;
import org.didcommx.didcomm.crypto.key.SenderKeySelector;
import org.didcommx.didcomm.diddoc.DIDCommService;
import org.didcommx.didcomm.diddoc.DIDDocResolver;
import org.didcommx.didcomm.model.PackEncryptedParams;
import org.didcommx.didcomm.protocols.routing.Routing;
import org.didcommx.didcomm.protocols.routing.WrapInForwardResult;
import org.didcommx.didcomm.secret.SecretResolver;
import org.didcommx.didcomm.utils.JSONUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a0\u0010\u0000\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a$\u0010\u000b\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00022\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u001a,\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00012\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n\u001a6\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00032\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018\u00a8\u0006\u0019"}, d2={"encrypt", "Lkotlin/Pair;", "Lorg/didcommx/didcomm/crypto/EncryptResult;", "", "Lorg/didcommx/didcomm/crypto/key/Key;", "params", "Lorg/didcommx/didcomm/model/PackEncryptedParams;", "payload", "", "keySelector", "Lorg/didcommx/didcomm/crypto/key/SenderKeySelector;", "protectSenderIfNeeded", "encryptResult", "recipientKeys", "signIfNeeded", "message", "wrapInForwardIfNeeded", "Lorg/didcommx/didcomm/protocols/routing/WrapInForwardResult;", "packedMessage", "didServicesChain", "Lorg/didcommx/didcomm/diddoc/DIDCommService;", "didDocResolver", "Lorg/didcommx/didcomm/diddoc/DIDDocResolver;", "secretResolver", "Lorg/didcommx/didcomm/secret/SecretResolver;", "didcomm"})
public final class PackEncryptKt {
    @NotNull
    public static final Pair<String, String> signIfNeeded(@NotNull String message, @NotNull PackEncryptedParams params, @NotNull SenderKeySelector keySelector) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)keySelector, (String)"keySelector");
        if (params.getSignFrom() != null) {
            Key key = keySelector.findSigningKey(params.getSignFrom());
            pair = new Pair((Object)JWSKt.sign(message, key), (Object)key.getId());
        } else {
            pair = new Pair((Object)message, null);
        }
        return pair;
    }

    @NotNull
    public static final Pair<EncryptResult, List<Key>> encrypt(@NotNull PackEncryptedParams params, @NotNull String payload, @NotNull SenderKeySelector keySelector) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)keySelector, (String)"keySelector");
        if (params.getFrom() != null) {
            Pair<Key, List<Key>> pair2 = keySelector.findAuthCryptKeys(params.getFrom(), params.getTo());
            Key senderKey = (Key)pair2.component1();
            List recipientKeys = (List)pair2.component2();
            pair = new Pair((Object)JWEKt.authEncrypt(payload, params.getEncAlgAuth(), senderKey, recipientKeys), (Object)recipientKeys);
        } else {
            List<Key> recipientKeys = keySelector.findAnonCryptKeys(params.getTo());
            pair = new Pair((Object)JWEKt.anonEncrypt(payload, params.getEncAlgAnon(), recipientKeys), recipientKeys);
        }
        return pair;
    }

    @NotNull
    public static final EncryptResult protectSenderIfNeeded(@NotNull PackEncryptedParams params, @NotNull EncryptResult encryptResult, @NotNull List<? extends Key> recipientKeys) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)encryptResult, (String)"encryptResult");
        Intrinsics.checkNotNullParameter(recipientKeys, (String)"recipientKeys");
        return params.getProtectSenderId() && params.getFrom() != null ? JWEKt.anonEncrypt(encryptResult.getPackedMessage(), params.getEncAlgAnon(), recipientKeys) : encryptResult;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final WrapInForwardResult wrapInForwardIfNeeded(@NotNull String packedMessage, @NotNull PackEncryptedParams params, @NotNull List<DIDCommService> didServicesChain, @NotNull DIDDocResolver didDocResolver, @NotNull SecretResolver secretResolver) {
        Intrinsics.checkNotNullParameter((Object)packedMessage, (String)"packedMessage");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter(didServicesChain, (String)"didServicesChain");
        Intrinsics.checkNotNullParameter((Object)didDocResolver, (String)"didDocResolver");
        Intrinsics.checkNotNullParameter((Object)secretResolver, (String)"secretResolver");
        if (!params.getForward() || didServicesChain.size() <= 0) {
            return null;
        }
        List routingKeys = ((DIDCommService)CollectionsKt.last(didServicesChain)).getRoutingKeys();
        if (routingKeys.isEmpty()) {
            return null;
        }
        if (didServicesChain.size() > 1) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = CollectionsKt.drop((Iterable)didServicesChain, (int)1);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                DIDCommService dIDCommService = (DIDCommService)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string = it.getServiceEndpoint();
                collection.add(string);
            }
            routingKeys = CollectionsKt.plus((Collection)((List)destination$iv$iv), (Iterable)routingKeys);
        }
        return Routing.wrapInForward$default(new Routing(didDocResolver, secretResolver), JSONUtilsKt.fromJsonToMap(packedMessage), params.getTo(), params.getEncAlgAnon(), routingKeys, params.getForwardHeaders(), null, null, 96, null);
    }
}

