/*
 * Decompiled with CFR 0.152.
 */
package org.didcommx.didcomm.operations;

import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.JWERecipient;
import com.nimbusds.jose.JWSObjectJSON;
import com.nimbusds.jose.UnprotectedHeader;
import com.nimbusds.jose.util.JSONObjectUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.didcommx.didcomm.common.AnonCryptAlg;
import org.didcommx.didcomm.common.AuthCryptAlg;
import org.didcommx.didcomm.common.CryptAlg;
import org.didcommx.didcomm.common.SignAlg;
import org.didcommx.didcomm.crypto.DecryptResult;
import org.didcommx.didcomm.crypto.JWEKt;
import org.didcommx.didcomm.crypto.JWMKt;
import org.didcommx.didcomm.crypto.JWSKt;
import org.didcommx.didcomm.crypto.ParseResult;
import org.didcommx.didcomm.crypto.key.Key;
import org.didcommx.didcomm.crypto.key.RecipientKeySelector;
import org.didcommx.didcomm.exceptions.MalformedMessageException;
import org.didcommx.didcomm.message.Message;
import org.didcommx.didcomm.model.Metadata;
import org.didcommx.didcomm.model.UnpackParams;
import org.didcommx.didcomm.model.UnpackResult;
import org.didcommx.didcomm.operations.FromPriorKt;
import org.didcommx.didcomm.protocols.routing.ForwardMessage;
import org.didcommx.didcomm.utils.DIDUtilsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000R\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a<\u0010\u0000\u001a\u00020\u00012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u001a\u0016\u0010\u0000\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0007\u001a$\u0010\u0010\u001a\u00020\u0001*\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002\u001a4\u0010\u0013\u001a\u00020\u0001*\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u001a,\u0010\u0016\u001a\u00020\u0001*\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002\u001a,\u0010\u0000\u001a\u00020\u0001*\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u001a\u001c\u0010\u0000\u001a\u00020\u0001*\u00020\u00192\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u001c\u0010\u0000\u001a\u00020\u0001*\u00020\u001a2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u001b"}, d2={"unpack", "Lorg/didcommx/didcomm/message/Message;", "packedMessage", "", "", "", "keySelector", "Lorg/didcommx/didcomm/crypto/key/RecipientKeySelector;", "metadataBuilder", "Lorg/didcommx/didcomm/model/Metadata$Builder;", "expectDecryptByAllKeys", "", "unwrapReWrappingForward", "Lorg/didcommx/didcomm/model/UnpackResult;", "params", "Lorg/didcommx/didcomm/model/UnpackParams;", "anonAuthUnpack", "Lorg/didcommx/didcomm/crypto/ParseResult$JWE;", "decryptByAllKeys", "anonUnpack", "anonCryptAlg", "Lorg/didcommx/didcomm/common/AnonCryptAlg;", "authUnpack", "authCryptAlg", "Lorg/didcommx/didcomm/common/AuthCryptAlg;", "Lorg/didcommx/didcomm/crypto/ParseResult$JWM;", "Lorg/didcommx/didcomm/crypto/ParseResult$JWS;", "didcomm"})
public final class UnpackKt {
    @NotNull
    public static final UnpackResult unpack(@NotNull UnpackParams params, @NotNull RecipientKeySelector keySelector) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)keySelector, (String)"keySelector");
        try {
            Map<String, Object> packedMessage = JSONObjectUtils.parse(params.getPackedMessage());
            Metadata.Builder metadataBuilder = new Metadata.Builder();
            Intrinsics.checkNotNullExpressionValue(packedMessage, (String)"packedMessage");
            Message msg = UnpackKt.unpack(packedMessage, keySelector, metadataBuilder, params.getExpectDecryptByAllKeys(), params.getUnwrapReWrappingForward());
            return new UnpackResult(msg, metadataBuilder.build());
        }
        catch (ParseException e) {
            throw new MalformedMessageException("Message cannot be parsed", e);
        }
    }

    private static final Message unpack(Map<String, ? extends Object> packedMessage, RecipientKeySelector keySelector, Metadata.Builder metadataBuilder, boolean expectDecryptByAllKeys, boolean unwrapReWrappingForward) {
        Message message;
        ParseResult parseResult = JWMKt.parse(packedMessage);
        if (parseResult instanceof ParseResult.JWS) {
            message = UnpackKt.unpack((ParseResult.JWS)parseResult, keySelector, metadataBuilder);
        } else if (parseResult instanceof ParseResult.JWE) {
            message = UnpackKt.unpack((ParseResult.JWE)parseResult, keySelector, expectDecryptByAllKeys, metadataBuilder, unwrapReWrappingForward);
        } else if (parseResult instanceof ParseResult.JWM) {
            message = UnpackKt.unpack((ParseResult.JWM)parseResult, keySelector, metadataBuilder);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return message;
    }

    private static final Message unpack(ParseResult.JWM $this$unpack, RecipientKeySelector keySelector, Metadata.Builder metadataBuilder) {
        metadataBuilder.fromPriorJwt($this$unpack.getMessage().getFromPriorJwt());
        Pair<Message, String> pair = FromPriorKt.unpackFromPrior($this$unpack.getMessage(), keySelector);
        Message updatedMessage = (Message)pair.component1();
        String fromPriorIssuerKid = (String)pair.component2();
        metadataBuilder.fromPriorIssuerKid(fromPriorIssuerKid);
        return updatedMessage;
    }

    private static final Message unpack(ParseResult.JWS $this$unpack, RecipientKeySelector keySelector, Metadata.Builder metadataBuilder) {
        if ($this$unpack.getMessage().getSignatures().isEmpty()) {
            throw new MalformedMessageException("Empty signatures", null, 2, null);
        }
        List<JWSObjectJSON.Signature> list = $this$unpack.getMessage().getSignatures();
        Intrinsics.checkNotNullExpressionValue(list, (String)"message.signatures");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String string;
            JWSObjectJSON.Signature it = (JWSObjectJSON.Signature)element$iv;
            boolean bl = false;
            UnprotectedHeader unprotectedHeader = it.getUnprotectedHeader();
            String string2 = string = unprotectedHeader == null ? null : unprotectedHeader.getKeyID();
            if (string == null) {
                throw new MalformedMessageException("JWS Unprotected Per-Signature header must be present", null, 2, null);
            }
            String kid = string;
            Key key = keySelector.findVerificationKey(kid);
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            SignAlg alg = JWSKt.getCryptoAlg(it);
            JWSKt.verify(it, alg, key);
            metadataBuilder.signAlg(alg).signFrom(kid);
        }
        Map<String, Object> unpackedMessage = $this$unpack.getMessage().getPayload().toJSONObject();
        metadataBuilder.nonRepudiation(true).authenticated(true).signedMessage($this$unpack.getRawMessage());
        Intrinsics.checkNotNullExpressionValue(unpackedMessage, (String)"unpackedMessage");
        ParseResult parseResult = JWMKt.parse(unpackedMessage);
        if (!(parseResult instanceof ParseResult.JWM)) {
            throw new MalformedMessageException("Malformed Message", null, 2, null);
        }
        return UnpackKt.unpack((ParseResult.JWM)parseResult, keySelector, metadataBuilder);
    }

    private static final Message unpack(ParseResult.JWE $this$unpack, RecipientKeySelector keySelector, boolean decryptByAllKeys, Metadata.Builder metadataBuilder, boolean unwrapReWrappingForward) {
        Message message;
        CryptAlg alg = JWEKt.getCryptoAlg($this$unpack.getMessage());
        if (alg instanceof AuthCryptAlg) {
            message = UnpackKt.authUnpack($this$unpack, keySelector, (AuthCryptAlg)alg, decryptByAllKeys, metadataBuilder);
        } else if (alg instanceof AnonCryptAlg) {
            message = UnpackKt.anonUnpack($this$unpack, keySelector, (AnonCryptAlg)alg, decryptByAllKeys, metadataBuilder, unwrapReWrappingForward);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return message;
    }

    /*
     * WARNING - void declaration
     */
    private static final Message authUnpack(ParseResult.JWE $this$authUnpack, RecipientKeySelector keySelector, AuthCryptAlg authCryptAlg, boolean decryptByAllKeys, Metadata.Builder metadataBuilder) {
        Message message;
        List list;
        Pair<Key, Sequence<Key>> pair;
        if ($this$authUnpack.getMessage().getHeader().getSenderKeyID() != null && !Intrinsics.areEqual((Object)$this$authUnpack.getMessage().getHeader().getAgreementPartyUInfo().decodeToString(), (Object)$this$authUnpack.getMessage().getHeader().getSenderKeyID())) {
            throw new MalformedMessageException("apu is not equal to skid", null, 2, null);
        }
        List<JWERecipient> list2 = $this$authUnpack.getMessage().getHeader();
        Pair<Key, Sequence<Key>> pair2 = list2 == null ? null : ((JWEHeader)((Object)list2)).getSenderKeyID();
        Object object = pair = pair2 == null ? $this$authUnpack.getMessage().getHeader().getAgreementPartyUInfo().decodeToString() : pair2;
        if (pair == null) {
            throw new MalformedMessageException("The \"skid\" header must be present", null, 2, null);
        }
        Pair<Key, Sequence<Key>> sender2 = pair;
        list2 = $this$authUnpack.getMessage().getRecipients();
        if (list2 == null) {
            list = null;
        } else {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = list2;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                String string;
                UnprotectedHeader unprotectedHeader;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                JWERecipient it = (JWERecipient)element$iv$iv;
                boolean bl2 = false;
                JWERecipient jWERecipient = it;
                if ((jWERecipient == null ? null : ((unprotectedHeader = jWERecipient.getHeader()) == null ? null : unprotectedHeader.getKeyID())) == null) continue;
                string = string;
                boolean bl3 = false;
                boolean bl4 = false;
                String it$iv$iv = string;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        pair2 = list;
        if (pair2 == null) {
            throw new MalformedMessageException("JWE Unprotected Per-Recipient header must be present", null, 2, null);
        }
        Pair<Key, Sequence<Key>> recipients = pair2;
        if ($this$authUnpack.getMessage().getHeader().getAgreementPartyVInfo() != null && !Intrinsics.areEqual((Object)$this$authUnpack.getMessage().getHeader().getAgreementPartyVInfo(), (Object)DIDUtilsKt.calculateAPV(recipients))) {
            throw new MalformedMessageException("apv is invalid", null, 2, null);
        }
        pair2 = keySelector.findAuthCryptKeys((String)sender2, (List<String>)recipients);
        Key from = (Key)pair2.component1();
        Sequence to = (Sequence)pair2.component2();
        DecryptResult decrypted = JWEKt.authDecrypt($this$authUnpack.getMessage(), decryptByAllKeys, from, (Sequence<? extends Key>)to);
        metadataBuilder.encryptedTo(decrypted.getToKids()).encryptedFrom(decrypted.getFromKid()).encAlgAuth(authCryptAlg).encrypted(true).authenticated(true);
        ParseResult parseResult = JWMKt.parse(decrypted.getUnpackedMessage());
        if (parseResult instanceof ParseResult.JWS) {
            message = UnpackKt.unpack((ParseResult.JWS)parseResult, keySelector, metadataBuilder);
        } else if (parseResult instanceof ParseResult.JWM) {
            message = UnpackKt.unpack((ParseResult.JWM)parseResult, keySelector, metadataBuilder);
        } else {
            throw new MalformedMessageException("Malformed Message", null, 2, null);
        }
        return message;
    }

    /*
     * WARNING - void declaration
     */
    private static final Message anonUnpack(ParseResult.JWE $this$anonUnpack, RecipientKeySelector keySelector, AnonCryptAlg anonCryptAlg, boolean decryptByAllKeys, Metadata.Builder metadataBuilder, boolean unwrapReWrappingForward) {
        Message message;
        ForwardMessage forwardMsg;
        List list;
        if ($this$anonUnpack.getMessage().getHeader().getSenderKeyID() != null && !Intrinsics.areEqual((Object)$this$anonUnpack.getMessage().getHeader().getAgreementPartyUInfo().decodeToString(), (Object)$this$anonUnpack.getMessage().getHeader().getSenderKeyID())) {
            throw new MalformedMessageException("apu is not equal to skid", null, 2, null);
        }
        List<JWERecipient> list2 = $this$anonUnpack.getMessage().getRecipients();
        if (list2 == null) {
            list = null;
        } else {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = list2;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                String string;
                UnprotectedHeader unprotectedHeader;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                JWERecipient it = (JWERecipient)element$iv$iv;
                boolean bl2 = false;
                JWERecipient jWERecipient = it;
                if ((jWERecipient == null ? null : ((unprotectedHeader = jWERecipient.getHeader()) == null ? null : unprotectedHeader.getKeyID())) == null) continue;
                string = string;
                boolean bl3 = false;
                boolean bl4 = false;
                String it$iv$iv = string;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        List list3 = list;
        if (list3 == null) {
            throw new MalformedMessageException("JWE Unprotected Per-Recipient header must be present", null, 2, null);
        }
        List recipients = list3;
        if ($this$anonUnpack.getMessage().getHeader().getAgreementPartyVInfo() != null && !Intrinsics.areEqual((Object)$this$anonUnpack.getMessage().getHeader().getAgreementPartyVInfo(), (Object)DIDUtilsKt.calculateAPV(recipients))) {
            throw new MalformedMessageException("apv is invalid", null, 2, null);
        }
        Sequence<Key> to = keySelector.findAnonCryptKeys(recipients);
        DecryptResult decrypted = JWEKt.anonDecrypt($this$anonUnpack.getMessage(), decryptByAllKeys, to);
        metadataBuilder.encryptedTo(decrypted.getToKids()).anonymousSender(true).encAlgAnon(anonCryptAlg).encrypted(true);
        ParseResult parseResult = JWMKt.parse(decrypted.getUnpackedMessage());
        if (unwrapReWrappingForward && parseResult instanceof ParseResult.JWM && (forwardMsg = ForwardMessage.Companion.fromMessage(((ParseResult.JWM)parseResult).getMessage())) != null && keySelector.hasKeysForForwardNext(forwardMsg.getForwardNext())) {
            metadataBuilder.reWrappedInForward(true);
            return UnpackKt.unpack(forwardMsg.getForwardedMsg(), keySelector, metadataBuilder, decryptByAllKeys, unwrapReWrappingForward);
        }
        ParseResult parseResult2 = parseResult;
        if (parseResult2 instanceof ParseResult.JWE) {
            message = UnpackKt.anonAuthUnpack((ParseResult.JWE)parseResult, keySelector, decryptByAllKeys, metadataBuilder);
        } else if (parseResult2 instanceof ParseResult.JWS) {
            message = UnpackKt.unpack((ParseResult.JWS)parseResult, keySelector, metadataBuilder);
        } else if (parseResult2 instanceof ParseResult.JWM) {
            message = UnpackKt.unpack((ParseResult.JWM)parseResult, keySelector, metadataBuilder);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return message;
    }

    private static final Message anonAuthUnpack(ParseResult.JWE $this$anonAuthUnpack, RecipientKeySelector keySelector, boolean decryptByAllKeys, Metadata.Builder metadataBuilder) {
        CryptAlg alg = JWEKt.getCryptoAlg($this$anonAuthUnpack.getMessage());
        if (!(alg instanceof AuthCryptAlg)) {
            throw new MalformedMessageException("Malformed Message", null, 2, null);
        }
        return UnpackKt.authUnpack($this$anonAuthUnpack, keySelector, (AuthCryptAlg)alg, decryptByAllKeys, metadataBuilder);
    }
}

