/*
 * Decompiled with CFR 0.152.
 */
package org.didcommx.didcomm.protocols.routing;

import com.nimbusds.jose.util.JSONObjectUtils;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.didcommx.didcomm.common.AnonCryptAlg;
import org.didcommx.didcomm.crypto.EncryptResult;
import org.didcommx.didcomm.crypto.key.RecipientKeySelector;
import org.didcommx.didcomm.crypto.key.SenderKeySelector;
import org.didcommx.didcomm.diddoc.DIDDocResolver;
import org.didcommx.didcomm.exceptions.MalformedMessageException;
import org.didcommx.didcomm.model.PackEncryptedParams;
import org.didcommx.didcomm.model.PackEncryptedResult;
import org.didcommx.didcomm.model.UnpackParams;
import org.didcommx.didcomm.model.UnpackResult;
import org.didcommx.didcomm.operations.PackEncryptKt;
import org.didcommx.didcomm.operations.UnpackKt;
import org.didcommx.didcomm.protocols.routing.ForwardMessage;
import org.didcommx.didcomm.protocols.routing.ForwardMessageBuilder;
import org.didcommx.didcomm.protocols.routing.UnpackForwardResult;
import org.didcommx.didcomm.protocols.routing.WrapInForwardResult;
import org.didcommx.didcomm.secret.SecretResolver;
import org.didcommx.didcomm.utils.DIDUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J0\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005Jt\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00010\u00102\u0006\u0010\u0011\u001a\u00020\n2\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0010\b\u0002\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u00152\u0018\b\u0002\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\u00102\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/didcommx/didcomm/protocols/routing/Routing;", "", "didDocResolver", "Lorg/didcommx/didcomm/diddoc/DIDDocResolver;", "secretResolver", "Lorg/didcommx/didcomm/secret/SecretResolver;", "(Lorg/didcommx/didcomm/diddoc/DIDDocResolver;Lorg/didcommx/didcomm/secret/SecretResolver;)V", "unpackForward", "Lorg/didcommx/didcomm/protocols/routing/UnpackForwardResult;", "packedMessage", "", "expectDecryptByAllKeys", "", "wrapInForward", "Lorg/didcommx/didcomm/protocols/routing/WrapInForwardResult;", "packedMsg", "", "to", "encAlgAnon", "Lorg/didcommx/didcomm/common/AnonCryptAlg;", "routingKeys", "", "headers", "didcomm"})
public final class Routing {
    @NotNull
    private final DIDDocResolver didDocResolver;
    @NotNull
    private final SecretResolver secretResolver;

    public Routing(@NotNull DIDDocResolver didDocResolver, @NotNull SecretResolver secretResolver) {
        Intrinsics.checkNotNullParameter((Object)didDocResolver, (String)"didDocResolver");
        Intrinsics.checkNotNullParameter((Object)secretResolver, (String)"secretResolver");
        this.didDocResolver = didDocResolver;
        this.secretResolver = secretResolver;
    }

    @Nullable
    public final WrapInForwardResult wrapInForward(@NotNull Map<String, ? extends Object> packedMsg, @NotNull String to, @Nullable AnonCryptAlg encAlgAnon, @Nullable List<String> routingKeys, @Nullable Map<String, ? extends Object> headers, @Nullable DIDDocResolver didDocResolver, @Nullable SecretResolver secretResolver) {
        Intrinsics.checkNotNullParameter(packedMsg, (String)"packedMsg");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        if (routingKeys == null || routingKeys.isEmpty()) {
            return null;
        }
        DIDDocResolver dIDDocResolver = didDocResolver;
        DIDDocResolver _didDocResolver = dIDDocResolver == null ? this.didDocResolver : dIDDocResolver;
        SecretResolver secretResolver2 = secretResolver;
        SecretResolver _secretResolver = secretResolver2 == null ? this.secretResolver : secretResolver2;
        SenderKeySelector keySelector = new SenderKeySelector(_didDocResolver, _secretResolver);
        ForwardMessage fwdMsg = null;
        Map<String, ? extends Object> forwardedMsg = packedMsg;
        EncryptResult encryptedResult = null;
        List tos = CollectionsKt.asReversed(routingKeys);
        List nexts = CollectionsKt.asReversed((List)CollectionsKt.plus((Collection)CollectionsKt.drop((Iterable)routingKeys, (int)1), (Object)to));
        for (Pair pair : CollectionsKt.zip((Iterable)tos, (Iterable)nexts)) {
            String _to = (String)pair.component1();
            String _next = (String)pair.component2();
            ForwardMessageBuilder fwdMsgBuilder = ForwardMessage.Companion.builder(DIDUtilsKt.didcommIdGeneratorDefault$default(null, 1, null), _next, forwardedMsg);
            Map<String, ? extends Object> map = headers;
            if (map != null) {
                Map<String, ? extends Object> $this$forEach$iv = map;
                boolean $i$f$forEach = false;
                Map<String, ? extends Object> map2 = $this$forEach$iv;
                boolean bl = false;
                Iterator<Map.Entry<String, ? extends Object>> iterator = map2.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, ? extends Object> element$iv;
                    Map.Entry<String, ? extends Object> $dstr$name$value = element$iv = iterator.next();
                    boolean bl2 = false;
                    Map.Entry<String, ? extends Object> entry = $dstr$name$value;
                    boolean bl3 = false;
                    String name = entry.getKey();
                    Map.Entry<String, ? extends Object> entry2 = $dstr$name$value;
                    boolean bl4 = false;
                    Object value = entry2.getValue();
                    fwdMsgBuilder.customHeader(name, value);
                }
            }
            fwdMsg = fwdMsgBuilder.buildForward();
            if (fwdMsg == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"fwdMsg");
                throw null;
            }
            PackEncryptedParams.Builder packParamsBuilder = new PackEncryptedParams.Builder(fwdMsg.getMessage(), _to);
            if (encAlgAnon != null) {
                packParamsBuilder.encAlgAnon(encAlgAnon);
            }
            if ((encryptedResult = (EncryptResult)PackEncryptKt.encrypt(packParamsBuilder.build(), fwdMsg.getMessage().toString(), keySelector).getFirst()) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"encryptedResult");
                throw null;
            }
            Map<String, Object> map3 = JSONObjectUtils.parse(encryptedResult.getPackedMessage());
            Intrinsics.checkNotNullExpressionValue(map3, (String)"parse(encryptedResult.packedMessage)");
            forwardedMsg = map3;
        }
        if (fwdMsg == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fwdMsg");
            throw null;
        }
        if (encryptedResult == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"encryptedResult");
            throw null;
        }
        return new WrapInForwardResult(fwdMsg, new PackEncryptedResult(encryptedResult.getPackedMessage(), encryptedResult.getToKids(), encryptedResult.getFromKid(), null, null, null, 56, null));
    }

    public static /* synthetic */ WrapInForwardResult wrapInForward$default(Routing routing, Map map, String string, AnonCryptAlg anonCryptAlg, List list, Map map2, DIDDocResolver dIDDocResolver, SecretResolver secretResolver, int n, Object object) {
        if ((n & 4) != 0) {
            anonCryptAlg = null;
        }
        if ((n & 8) != 0) {
            list = null;
        }
        if ((n & 0x10) != 0) {
            map2 = null;
        }
        if ((n & 0x20) != 0) {
            dIDDocResolver = null;
        }
        if ((n & 0x40) != 0) {
            secretResolver = null;
        }
        return routing.wrapInForward(map, string, anonCryptAlg, list, map2, dIDDocResolver, secretResolver);
    }

    @NotNull
    public final UnpackForwardResult unpackForward(@NotNull String packedMessage, boolean expectDecryptByAllKeys, @Nullable DIDDocResolver didDocResolver, @Nullable SecretResolver secretResolver) {
        UnpackForwardResult unpackForwardResult;
        ForwardMessage forwardMessage;
        Intrinsics.checkNotNullParameter((Object)packedMessage, (String)"packedMessage");
        DIDDocResolver dIDDocResolver = didDocResolver;
        DIDDocResolver _didDocResolver = dIDDocResolver == null ? this.didDocResolver : dIDDocResolver;
        SecretResolver secretResolver2 = secretResolver;
        SecretResolver _secretResolver = secretResolver2 == null ? this.secretResolver : secretResolver2;
        RecipientKeySelector recipientKeySelector = new RecipientKeySelector(_didDocResolver, _secretResolver);
        UnpackResult unpackResult = UnpackKt.unpack(new UnpackParams.Builder(packedMessage).expectDecryptByAllKeys(expectDecryptByAllKeys).unwrapReWrappingForward(false).build(), recipientKeySelector);
        ForwardMessage forwardMessage2 = forwardMessage = ForwardMessage.Companion.fromMessage(unpackResult.getMessage());
        if (forwardMessage2 == null) {
            unpackForwardResult = null;
        } else {
            ForwardMessage forwardMessage3 = forwardMessage2;
            boolean bl = false;
            boolean bl2 = false;
            ForwardMessage it = forwardMessage3;
            boolean bl3 = false;
            unpackForwardResult = new UnpackForwardResult(it, unpackResult.getMetadata().getEncryptedTo());
        }
        UnpackForwardResult unpackForwardResult2 = unpackForwardResult;
        if (unpackForwardResult2 == null) {
            throw new MalformedMessageException("Invalid forward message", null, 2, null);
        }
        return unpackForwardResult2;
    }

    public static /* synthetic */ UnpackForwardResult unpackForward$default(Routing routing, String string, boolean bl, DIDDocResolver dIDDocResolver, SecretResolver secretResolver, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            dIDDocResolver = null;
        }
        if ((n & 8) != 0) {
            secretResolver = null;
        }
        return routing.unpackForward(string, bl, dIDDocResolver, secretResolver);
    }
}

