/*
 * Decompiled with CFR 0.152.
 */
package org.didcommx.didcomm.protocols.routing;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.didcommx.didcomm.diddoc.DIDCommService;
import org.didcommx.didcomm.diddoc.DIDDoc;
import org.didcommx.didcomm.diddoc.DIDDocResolver;
import org.didcommx.didcomm.exceptions.DIDCommServiceException;
import org.didcommx.didcomm.exceptions.DIDDocException;
import org.didcommx.didcomm.exceptions.DIDDocNotResolvedException;
import org.didcommx.didcomm.utils.DIDUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\u001a&\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0001H\u0000\u001a4\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"PROFILE_DIDCOMM_AIP1", "", "PROFILE_DIDCOMM_AIP2_ENV_RFC19", "PROFILE_DIDCOMM_AIP2_ENV_RFC587", "PROFILE_DIDCOMM_V2", "findDIDCommService", "Lorg/didcommx/didcomm/diddoc/DIDCommService;", "didDocResolver", "Lorg/didcommx/didcomm/diddoc/DIDDocResolver;", "to", "serviceId", "resolveDIDCommServicesChain", "", "didRecursion", "", "didcomm"})
public final class RoutingKt {
    @NotNull
    public static final String PROFILE_DIDCOMM_AIP1 = "didcomm/aip1";
    @NotNull
    public static final String PROFILE_DIDCOMM_AIP2_ENV_RFC19 = "didcomm/aip2;env=rfc19";
    @NotNull
    public static final String PROFILE_DIDCOMM_AIP2_ENV_RFC587 = "didcomm/aip2;env=rfc587";
    @NotNull
    public static final String PROFILE_DIDCOMM_V2 = "didcomm/v2";

    @Nullable
    public static final DIDCommService findDIDCommService(@NotNull DIDDocResolver didDocResolver, @NotNull String to, @Nullable String serviceId) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)didDocResolver, (String)"didDocResolver");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        String toDid = DIDUtilsKt.getDid(to);
        DIDDoc didDoc2 = didDocResolver.resolve(toDid).orElseThrow(new Supplier(toDid){
            final /* synthetic */ String $toDid;
            {
                this.$toDid = $toDid;
            }

            public final Void get() {
                throw new DIDDocNotResolvedException(this.$toDid);
            }
        });
        if (serviceId != null) {
            DIDCommService didService = didDoc2.findDIDCommService(serviceId);
            if (didService.getAccept() != null && !didService.getAccept().isEmpty() && !didService.getAccept().contains(PROFILE_DIDCOMM_V2)) {
                throw new DIDCommServiceException(toDid, "service '" + serviceId + "' does not accept didcomm/v2 profile");
            }
            return didService;
        }
        try {
            Object v0;
            block5: {
                object = didDoc2.getDidCommServices();
                boolean bl = false;
                Object object2 = object;
                boolean bl2 = false;
                Iterator iterator = object2.iterator();
                while (iterator.hasNext()) {
                    Object t = iterator.next();
                    DIDCommService it = (DIDCommService)t;
                    boolean bl3 = false;
                    if (!(it.getAccept() == null || it.getAccept().isEmpty() || it.getAccept().contains(PROFILE_DIDCOMM_V2))) continue;
                    v0 = t;
                    break block5;
                }
                v0 = null;
            }
            object = v0;
        }
        catch (DIDDocException e) {
            object = null;
        }
        return object;
    }

    public static /* synthetic */ DIDCommService findDIDCommService$default(DIDDocResolver dIDDocResolver, String string, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        return RoutingKt.findDIDCommService(dIDDocResolver, string, string2);
    }

    @NotNull
    public static final List<DIDCommService> resolveDIDCommServicesChain(@NotNull DIDDocResolver didDocResolver, @NotNull String to, @Nullable String serviceId, boolean didRecursion) {
        Intrinsics.checkNotNullParameter((Object)didDocResolver, (String)"didDocResolver");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        DIDCommService dIDCommService = RoutingKt.findDIDCommService(didDocResolver, to, serviceId);
        if (dIDCommService == null) {
            boolean bl = false;
            return CollectionsKt.emptyList();
        }
        DIDCommService toDidService = dIDCommService;
        boolean bl = false;
        List res = new ArrayList();
        String serviceUri = toDidService.getServiceEndpoint();
        res.add(0, toDidService);
        while (DIDUtilsKt.isDIDOrDidUrl(serviceUri)) {
            String mediatorDid = serviceUri;
            if (res.size() > 1) {
                String errMsg = "mediator '" + ((DIDCommService)CollectionsKt.last((List)res)).getServiceEndpoint() + "' defines alternative endpoint '" + serviceUri + "' recursively";
                if (didRecursion) {
                    throw new NotImplementedError(errMsg);
                }
                throw new DIDCommServiceException(((DIDCommService)CollectionsKt.last((List)res)).getServiceEndpoint(), errMsg);
            }
            DIDCommService dIDCommService2 = RoutingKt.findDIDCommService$default(didDocResolver, mediatorDid, null, 4, null);
            if (dIDCommService2 == null) {
                throw new DIDCommServiceException(mediatorDid, "mediator '" + mediatorDid + "' service doc not found");
            }
            DIDCommService mediatorDidService = dIDCommService2;
            serviceUri = mediatorDidService.getServiceEndpoint();
            res.add(0, mediatorDidService);
        }
        return res;
    }

    public static /* synthetic */ List resolveDIDCommServicesChain$default(DIDDocResolver dIDDocResolver, String string, String string2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        return RoutingKt.resolveDIDCommServicesChain(dIDDocResolver, string, string2, bl);
    }
}

