/*
 * Decompiled with CFR 0.152.
 */
package org.didcommx.didcomm.secret;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.didcommx.didcomm.secret.Secret;
import org.didcommx.didcomm.secret.SecretResolverEditable;
import org.didcommx.didcomm.secret.SecretUtilsKt;
import org.didcommx.didcomm.utils.JSONUtilsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0016J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\f2\u0006\u0010\r\u001a\u00020\u0003H\u0016J\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011H\u0016J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011H\u0016J\b\u0010\u0013\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/didcommx/didcomm/secret/SecretResolverDemo;", "Lorg/didcommx/didcomm/secret/SecretResolverEditable;", "filePath", "", "(Ljava/lang/String;)V", "secrets", "", "Lorg/didcommx/didcomm/secret/Secret;", "addKey", "", "secret", "findKey", "Ljava/util/Optional;", "kid", "findKeys", "", "kids", "", "getKids", "save", "didcomm"})
public final class SecretResolverDemo
implements SecretResolverEditable {
    @NotNull
    private final String filePath;
    @NotNull
    private final Map<String, Secret> secrets;

    /*
     * WARNING - void declaration
     */
    public SecretResolverDemo(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        this.filePath = filePath;
        Object object = this.filePath;
        boolean bl = false;
        Path path = Paths.get((String)object, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"Paths.get(path)");
        object = path;
        Object object2 = new LinkOption[]{};
        boolean bl2 = false;
        if (!Files.exists((Path)object, Arrays.copyOf(object2, ((LinkOption[])object2).length))) {
            boolean bl3 = false;
            this.secrets = new LinkedHashMap();
            this.save();
        } else {
            Map map;
            String secretsJson = FilesKt.readText$default((File)new File(this.filePath), null, (int)1, null);
            SecretResolverDemo secretResolverDemo = this;
            object2 = secretsJson;
            bl2 = false;
            if (object2.length() > 0) {
                void $this$associateTo$iv$iv;
                void $this$associate$iv;
                Object object3;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                object2 = JSONUtilsKt.fromJsonToList(secretsJson);
                SecretResolverDemo secretResolverDemo2 = secretResolverDemo;
                boolean $i$f$map = false;
                void var5_9 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Map map2 = (Map)item$iv$iv;
                    object3 = destination$iv$iv;
                    boolean bl4 = false;
                    Secret secret = SecretUtilsKt.jwkToSecret((Map<String, ? extends Object>)it);
                    object3.add(secret);
                }
                object3 = (List)destination$iv$iv;
                $this$map$iv = (Iterable)object3;
                boolean $i$f$associate = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                destination$iv$iv = $this$associate$iv;
                Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateTo = false;
                for (Object element$iv$iv : $this$associateTo$iv$iv) {
                    Map map3 = destination$iv$iv2;
                    Secret it = (Secret)element$iv$iv;
                    boolean bl5 = false;
                    Pair pair = TuplesKt.to((Object)it.getKid(), (Object)it);
                    boolean bl6 = false;
                    map3.put(pair.getFirst(), pair.getSecond());
                }
                object3 = destination$iv$iv2;
                secretResolverDemo = secretResolverDemo2;
                map = MapsKt.toMutableMap((Map)object3);
            } else {
                boolean bl7 = false;
                map = new LinkedHashMap();
            }
            secretResolverDemo.secrets = map;
        }
    }

    public /* synthetic */ SecretResolverDemo(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "secrets.json";
        }
        this(string);
    }

    /*
     * WARNING - void declaration
     */
    private final void save() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.secrets.values();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Secret secret = (Secret)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Map<String, Object> map = SecretUtilsKt.secretToJwk((Secret)it);
            collection.add(map);
        }
        String secretJson = JSONUtilsKt.toJson((List)destination$iv$iv);
        File file = new File(this.filePath);
        Intrinsics.checkNotNullExpressionValue((Object)secretJson, (String)"secretJson");
        FilesKt.writeText$default((File)file, (String)secretJson, null, (int)2, null);
    }

    @Override
    public void addKey(@NotNull Secret secret) {
        Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
        this.secrets.put(secret.getKid(), secret);
        this.save();
    }

    @Override
    @NotNull
    public List<String> getKids() {
        return CollectionsKt.toList((Iterable)this.secrets.keySet());
    }

    @Override
    @NotNull
    public Optional<Secret> findKey(@NotNull String kid) {
        Intrinsics.checkNotNullParameter((Object)kid, (String)"kid");
        Optional<Secret> optional = Optional.ofNullable(this.secrets.get(kid));
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(secrets.get(kid))");
        return optional;
    }

    @Override
    @NotNull
    public Set<String> findKeys(@NotNull List<String> kids) {
        Intrinsics.checkNotNullParameter(kids, (String)"kids");
        return CollectionsKt.intersect((Iterable)kids, (Iterable)this.secrets.keySet());
    }

    public SecretResolverDemo() {
        this(null, 1, null);
    }
}

