/*
 * Decompiled with CFR 0.152.
 */
package org.didcommx.didcomm.secret;

import com.nimbusds.jose.jwk.Curve;
import com.nimbusds.jose.jwk.OctetKeyPair;
import com.nimbusds.jose.jwk.gen.OctetKeyPairGenerator;
import com.nimbusds.jose.util.JSONObjectUtils;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.didcommx.didcomm.common.VerificationMaterial;
import org.didcommx.didcomm.common.VerificationMaterialFormat;
import org.didcommx.didcomm.common.VerificationMethodType;
import org.didcommx.didcomm.secret.KeyPair;
import org.didcommx.didcomm.secret.Secret;
import org.didcommx.didcomm.utils.JSONUtilsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0003\u001a\u0006\u0010\u0000\u001a\u00020\u0001\u001a\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u001a\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u001a\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0006\u0010\n\u001a\u00020\u0004\u00a8\u0006\u000b"}, d2={"generateEd25519Keys", "Lorg/didcommx/didcomm/secret/KeyPair;", "generateX25519Keys", "jwkToSecret", "Lorg/didcommx/didcomm/secret/Secret;", "jwk", "", "", "", "secretToJwk", "secret", "didcomm"})
public final class SecretUtilsKt {
    @NotNull
    public static final Secret jwkToSecret(@NotNull Map<String, ? extends Object> jwk) {
        String string;
        Intrinsics.checkNotNullParameter(jwk, (String)"jwk");
        Object object = jwk.get("kid");
        return new Secret(object == null ? "" : ((string = object.toString()) == null ? "" : string), VerificationMethodType.JSON_WEB_KEY_2020, new VerificationMaterial(VerificationMaterialFormat.JWK, JSONUtilsKt.toJSONString(jwk)));
    }

    @NotNull
    public static final Map<String, Object> secretToJwk(@NotNull Secret secret) {
        Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
        Map<String, Object> map = JSONObjectUtils.parse(secret.getVerificationMaterial().getValue());
        Intrinsics.checkNotNullExpressionValue(map, (String)"parse(secret.verificationMaterial.value)");
        return map;
    }

    @NotNull
    public static final KeyPair generateEd25519Keys() {
        OctetKeyPair keys = (OctetKeyPair)new OctetKeyPairGenerator(Curve.Ed25519).keyIDFromThumbprint(true).generate();
        Map<String, Object> map = keys.toJSONObject();
        Intrinsics.checkNotNullExpressionValue(map, (String)"keys.toJSONObject()");
        Map<String, Object> map2 = map;
        map = keys.toPublicJWK().toJSONObject();
        Intrinsics.checkNotNullExpressionValue(map, (String)"keys.toPublicJWK().toJSONObject()");
        return new KeyPair(map2, map);
    }

    @NotNull
    public static final KeyPair generateX25519Keys() {
        OctetKeyPair keys = (OctetKeyPair)new OctetKeyPairGenerator(Curve.X25519).keyIDFromThumbprint(true).generate();
        Map<String, Object> map = keys.toJSONObject();
        Intrinsics.checkNotNullExpressionValue(map, (String)"keys.toJSONObject()");
        Map<String, Object> map2 = map;
        map = keys.toPublicJWK().toJSONObject();
        Intrinsics.checkNotNullExpressionValue(map, (String)"keys.toPublicJWK().toJSONObject()");
        return new KeyPair(map2, map);
    }
}

