/*
 * Decompiled with CFR 0.152.
 */
package org.didcommx.didcomm.utils;

import com.nimbusds.jose.util.Base64URL;
import java.security.MessageDigest;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\u001a\u0016\u0010\u0000\u001a\u0004\u0018\u00010\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u001a\u0012\u0010\u0005\u001a\u00020\u00042\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0004\u001a\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\b\u001a\u00020\u0004\u001a\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004\u001a\u0006\u0010\n\u001a\u00020\u0004\u001a\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u0004\u001a\u000e\u0010\r\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u0004\u001a\u000e\u0010\u000e\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u0004\u001a\u000e\u0010\u000f\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u0004\u00a8\u0006\u0010"}, d2={"calculateAPV", "Lcom/nimbusds/jose/util/Base64URL;", "kids", "", "", "didcommIdGeneratorDefault", "did", "divideDIDFragment", "str", "getDid", "idGeneratorDefault", "isDID", "", "isDIDFragment", "isDIDOrDidUrl", "isDIDUrl", "didcomm"})
public final class DIDUtilsKt {
    public static final boolean isDIDFragment(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        return StringsKt.contains$default((CharSequence)str, (CharSequence)"#", (boolean)false, (int)2, null);
    }

    @NotNull
    public static final List<String> divideDIDFragment(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        String[] stringArray = new String[]{"#"};
        return StringsKt.split$default((CharSequence)str, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
    }

    @NotNull
    public static final String getDid(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        return DIDUtilsKt.divideDIDFragment(str).get(0);
    }

    public static final boolean isDID(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        String[] stringArray = new String[]{":"};
        List parts = StringsKt.split$default((CharSequence)str, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        return parts.size() >= 3 && Intrinsics.areEqual(parts.get(0), (Object)"did");
    }

    public static final boolean isDIDUrl(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        List<String> parts = DIDUtilsKt.divideDIDFragment(str);
        return parts.size() == 2 && DIDUtilsKt.isDID(parts.get(0)) && !Intrinsics.areEqual((Object)parts.get(1), (Object)"");
    }

    public static final boolean isDIDOrDidUrl(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        return DIDUtilsKt.isDID(str) || DIDUtilsKt.isDIDUrl(str);
    }

    @Nullable
    public static final Base64URL calculateAPV(@NotNull List<String> kids) {
        Intrinsics.checkNotNullParameter(kids, (String)"kids");
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        return Base64URL.encode(digest.digest(StringsKt.encodeToByteArray((String)CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)kids), (CharSequence)".", null, null, (int)0, null, null, (int)62, null))));
    }

    @NotNull
    public static final String idGeneratorDefault() {
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        return string;
    }

    @NotNull
    public static final String didcommIdGeneratorDefault(@Nullable String did) {
        String res = DIDUtilsKt.idGeneratorDefault();
        if (did != null) {
            res = did + ':' + res;
        }
        return res;
    }

    public static /* synthetic */ String didcommIdGeneratorDefault$default(String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return DIDUtilsKt.didcommIdGeneratorDefault(string);
    }
}

