/*
 * Decompiled with CFR 0.152.
 */
package org.diet4j.core;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.diet4j.core.AbstractModuleRegistry;
import org.diet4j.core.AbstractScanningModuleRegistry;
import org.diet4j.core.MiniModuleMetaMap;

public class ScanningDirectoriesModuleRegistry
extends AbstractScanningModuleRegistry {
    protected File[] theDirectories;
    public static final File[] DEFAULT_MODULE_DIRECTORIES = new File[]{new File(System.getProperty("user.home") + File.separatorChar + ".m2")};
    private static final Logger log = Logger.getLogger(ScanningDirectoriesModuleRegistry.class.getName());

    public static ScanningDirectoriesModuleRegistry create(File[] dirs) {
        return ScanningDirectoriesModuleRegistry.create(dirs, AbstractModuleRegistry.DEFAULT_DO_NOT_LOAD_CLASS_PREFIXES);
    }

    public static ScanningDirectoriesModuleRegistry create(File[] dirs, String[] doNotLoadClassPrefixes) {
        if (dirs == null || dirs.length == 0) {
            dirs = DEFAULT_MODULE_DIRECTORIES;
        }
        ArrayList<JarFile> jars = new ArrayList<JarFile>();
        for (int i = 0; i < dirs.length; ++i) {
            if (!dirs[i].exists()) continue;
            if (!dirs[i].isDirectory()) {
                throw new IllegalArgumentException("Not a directory: " + dirs[i].getAbsolutePath());
            }
            try {
                List newJars = Files.walk(dirs[i].toPath(), new FileVisitOption[0]).filter(f -> {
                    String name = f.getFileName().toString();
                    return name.endsWith(".jar") || name.endsWith(".war");
                }).filter(f -> Files.isRegularFile(f, LinkOption.NOFOLLOW_LINKS)).map(f -> {
                    try {
                        return new JarFile(f.toFile());
                    }
                    catch (IOException ex) {
                        log.log(Level.SEVERE, "Cannot access {0}: {1}", new Object[]{f.toString(), ex.getLocalizedMessage()});
                        return null;
                    }
                }).filter(f -> f != null).collect(Collectors.toList());
                jars.addAll(newJars);
                continue;
            }
            catch (IOException ex) {
                log.log(Level.SEVERE, "I/O Error", ex);
            }
        }
        HashMap<String, MiniModuleMetaMap> metas = new HashMap<String, MiniModuleMetaMap>();
        ScanningDirectoriesModuleRegistry.addParsedModuleMetasFromJars(jars, metas);
        ScanningDirectoriesModuleRegistry ret = new ScanningDirectoriesModuleRegistry(dirs, metas, doNotLoadClassPrefixes);
        return ret;
    }

    protected ScanningDirectoriesModuleRegistry(File[] dirs, HashMap<String, MiniModuleMetaMap> metas, String[] doNotLoadClassPrefixes) {
        super(metas, doNotLoadClassPrefixes);
        this.theDirectories = dirs;
    }

    public File[] getScannedDirectories() {
        return this.theDirectories;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getName());
        buf.append(" (");
        buf.append(this.nameSet().size());
        buf.append(" known modules, dirs:");
        for (File d : this.theDirectories) {
            buf.append(' ');
            buf.append(d.getPath());
        }
        buf.append(')');
        return buf.toString();
    }
}

