/*
 * Decompiled with CFR 0.152.
 */
package org.diet4j.cmdline;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.text.ParseException;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.diet4j.cmdline.CmdlineParameters;
import org.diet4j.core.Module;
import org.diet4j.core.ModuleMeta;
import org.diet4j.core.ModuleRegistry;
import org.diet4j.core.ModuleRequirement;
import org.diet4j.core.ScanningDirectoriesModuleRegistry;

public abstract class CmdlineBootLoader {
    protected static File[] theModuleDirectories;
    protected static String theRunClassName;
    protected static String theRunMethodName;
    protected static ModuleRequirement theRootModuleRequirement;
    protected static String[] theRunArguments;
    private static final Logger log;

    protected CmdlineBootLoader() {
    }

    public static void main(String[] args) {
        try {
            CmdlineBootLoader.parseArguments(args);
            int ret = CmdlineBootLoader.activateRunDeactivate();
            System.exit(ret);
        }
        catch (Throwable ex) {
            CmdlineBootLoader.fatal("Something bad happened:" + (ex.getMessage() != null ? ex.getMessage() : ex.toString()));
        }
    }

    static void parseArguments(String[] args) throws IOException {
        CmdlineParameters parameters = new CmdlineParameters(new CmdlineParameters.Parameter("help", 0), new CmdlineParameters.Parameter("directory", 1, true), new CmdlineParameters.Parameter("run", 1), new CmdlineParameters.Parameter("method", 1));
        String[] remaining = parameters.parse(args);
        if (parameters.containsKey("help")) {
            CmdlineBootLoader.helpAndQuit();
        }
        if (remaining.length < 1) {
            CmdlineBootLoader.fatal("Must provide the name of one root module");
        }
        try {
            theRootModuleRequirement = ModuleRequirement.parse(remaining[0]);
        }
        catch (ParseException ex) {
            CmdlineBootLoader.fatal(ex.getLocalizedMessage());
        }
        theRunArguments = new String[remaining.length - 1];
        System.arraycopy(remaining, 1, theRunArguments, 0, theRunArguments.length);
        String[] dirs = parameters.getMany("directory");
        HashSet<File> fileDirs = new HashSet<File>();
        if (dirs != null) {
            for (String dir : dirs) {
                if (fileDirs.add(new File(dir).getCanonicalFile())) continue;
                CmdlineBootLoader.fatal("Directory (indirectly?) specified more than once in moduledirectory parameter: " + dir);
            }
        }
        theModuleDirectories = new File[fileDirs.size()];
        fileDirs.toArray(theModuleDirectories);
        theRunClassName = parameters.get("run");
        theRunMethodName = parameters.get("method");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int activateRunDeactivate() {
        int ret;
        Module rootModule;
        ModuleMeta rootModuleMeta;
        ScanningDirectoriesModuleRegistry registry = ScanningDirectoriesModuleRegistry.create(theModuleDirectories);
        try {
            rootModuleMeta = ((ModuleRegistry)registry).determineSingleResolutionCandidate(theRootModuleRequirement);
        }
        catch (Throwable ex) {
            log.log(Level.SEVERE, "Cannot find module " + theRootModuleRequirement);
            return 1;
        }
        try {
            rootModule = ((ModuleRegistry)registry).resolve(rootModuleMeta);
            rootModule.activateRecursively();
            ret = 0;
        }
        catch (Throwable ex) {
            log.log(Level.SEVERE, "Activation of module " + rootModuleMeta + " failed", ex);
            rootModule = null;
            ret = 1;
        }
        if (rootModule != null) {
            try {
                ret = rootModule.run(theRunClassName, theRunMethodName, theRunArguments);
            }
            catch (Throwable ex) {
                log.log(Level.SEVERE, "Run of module " + rootModuleMeta + " failed", ex);
                ret = 1;
            }
            finally {
                try {
                    rootModule.deactivateRecursively();
                }
                catch (Throwable ex) {
                    log.log(Level.SEVERE, "Deactivation of module " + rootModuleMeta + " failed", ex);
                    ret = 1;
                }
            }
        }
        return ret;
    }

    public static void helpAndQuit() {
        PrintStream w = System.out;
        w.println("Synopsis: (diet4j-core 0.15, built 2017-01-29T04:23:23Z)");
        w.println("[ --directory <directory> ]... [ --run <class> ][ --method <method> ] <rootmodule> [ <arg> ... ] ");
        w.println("    where:");
        w.println("       <directory>:  directory in which to look for modules");
        w.println("       <class>:      name of a non-default class whose main() method to run");
        w.println("       <method>:     name of a method in the run class to run, instead of main()");
        w.println("       <rootmodule>: name of the root module to activate, given as groupId:artifactId:version or groupId:artifactId");
        w.println("       <arg> ...:    argument(s) to the main() method of the run class");
        w.println("--help: this message");
        w.flush();
        System.exit(0);
    }

    public static void fatal(String msg) {
        log.log(Level.SEVERE, msg);
        System.exit(1);
    }

    static {
        log = Logger.getLogger(CmdlineBootLoader.class.getName());
    }
}

